/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.SimpleLogVersionRepository;
import org.neo4j.kernel.impl.transaction.SimpleTransactionIdStore;
import org.neo4j.kernel.impl.transaction.log.AppendBatchInfo;
import org.neo4j.kernel.impl.transaction.log.EmptyLogTailMetadata;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.ClosedBatchMetadata;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.ExternalStoreId;
import org.neo4j.storageengine.api.MetadataProvider;
import org.neo4j.storageengine.api.OpenTransactionMetadata;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.storageengine.api.TransactionId;

public class SimpleMetaDataProvider
implements MetadataProvider {
    private final SimpleTransactionIdStore transactionIdStore;
    private final SimpleLogVersionRepository logVersionRepository;
    private final ExternalStoreId externalStoreId = new ExternalStoreId(UUID.randomUUID());
    private final AtomicLong appendIndex = new AtomicLong();
    private volatile AppendBatchInfo appendBatchInfo = EmptyLogTailMetadata.EMPTY_APPEND_BATCH_INFO;

    public SimpleMetaDataProvider() {
        this.transactionIdStore = new SimpleTransactionIdStore();
        this.logVersionRepository = new SimpleLogVersionRepository();
    }

    public void close() throws IOException {
    }

    public long getCurrentLogVersion() {
        return this.logVersionRepository.getCurrentLogVersion();
    }

    public void setCurrentLogVersion(long version) {
        this.logVersionRepository.setCurrentLogVersion(version);
    }

    public long incrementAndGetVersion() {
        return this.logVersionRepository.incrementAndGetVersion();
    }

    public long getCheckpointLogVersion() {
        return this.logVersionRepository.getCheckpointLogVersion();
    }

    public void setCheckpointLogVersion(long version) {
        this.logVersionRepository.setCheckpointLogVersion(version);
    }

    public long incrementAndGetCheckpointLogVersion() {
        return this.logVersionRepository.incrementAndGetCheckpointLogVersion();
    }

    public StoreId getStoreId() {
        return new StoreId(1L, 1L, "engine-1", "format-1", 1, 1);
    }

    public ExternalStoreId getExternalStoreId() {
        return this.externalStoreId;
    }

    public long nextCommittingTransactionId() {
        return this.transactionIdStore.nextCommittingTransactionId();
    }

    public void transactionCommitted(long transactionId, long appendIndex, KernelVersion kernelVersion, int checksum, long commitTimestamp, long consensusIndex) {
        this.transactionIdStore.transactionCommitted(transactionId, appendIndex, kernelVersion, checksum, commitTimestamp, consensusIndex);
    }

    public long getLastCommittedTransactionId() {
        return this.transactionIdStore.getLastCommittedTransactionId();
    }

    public TransactionId getLastCommittedTransaction() {
        return this.transactionIdStore.getLastCommittedTransaction();
    }

    public long getLastClosedTransactionId() {
        return this.transactionIdStore.getLastClosedTransactionId();
    }

    public TransactionIdSnapshot getClosedTransactionSnapshot() {
        return this.transactionIdStore.getClosedTransactionSnapshot();
    }

    public ClosedTransactionMetadata getLastClosedTransaction() {
        return this.transactionIdStore.getLastClosedTransaction();
    }

    public ClosedBatchMetadata getLastClosedBatch() {
        return this.transactionIdStore.getLastClosedBatch();
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, long transactionAppendIndex, KernelVersion kernelVersion, int checksum, long commitTimestamp, long consensusIndex, long byteOffset, long logVersion, long appendIndex) {
        this.transactionIdStore.setLastCommittedAndClosedTransactionId(transactionId, transactionAppendIndex, kernelVersion, checksum, commitTimestamp, consensusIndex, byteOffset, logVersion, appendIndex);
        this.appendIndex.set(appendIndex);
        this.appendBatchInfo = new AppendBatchInfo(appendIndex, LogPosition.UNSPECIFIED);
    }

    public void transactionClosed(long transactionId, long appendIndex, KernelVersion kernelVersion, long logVersion, long byteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        this.transactionIdStore.transactionClosed(transactionId, appendIndex, kernelVersion, logVersion, byteOffset, checksum, commitTimestamp, consensusIndex);
    }

    public void batchClosed(long transactionId, long appendIndex, boolean firstBatch, boolean lastBatch, KernelVersion kernelVersion, LogPosition logPositionAfter) {
        this.transactionIdStore.batchClosed(transactionId, appendIndex, firstBatch, lastBatch, kernelVersion, logPositionAfter);
    }

    public void resetLastClosedTransaction(long transactionId, long appendIndex, KernelVersion kernelVersion, long logVersion, long byteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        this.transactionIdStore.resetLastClosedTransaction(transactionId, appendIndex, kernelVersion, byteOffset, logVersion, checksum, commitTimestamp, consensusIndex);
    }

    public void appendBatch(long transactionId, long appendIndex, boolean firstBatch, boolean lastBatch, LogPosition logPositionBefore, LogPosition logPositionAfter) {
        this.appendBatchInfo = new AppendBatchInfo(appendIndex, logPositionAfter);
    }

    public AppendBatchInfo getLastCommittedBatch() {
        return this.appendBatchInfo;
    }

    public OpenTransactionMetadata getOldestOpenTransaction() {
        return this.transactionIdStore.getOldestOpenTransaction();
    }

    public TransactionId getHighestEverClosedTransaction() {
        return this.transactionIdStore.getHighestEverClosedTransaction();
    }

    public Optional<UUID> getDatabaseIdUuid(CursorContext cursorContext) {
        throw new IllegalStateException("Not supported");
    }

    public void setDatabaseIdUuid(UUID uuid, CursorContext cursorContext) {
        throw new IllegalStateException("Not supported");
    }

    public void regenerateMetadata(StoreId storeId, UUID externalStoreUUID, CursorContext cursorContext) {
        throw new UnsupportedOperationException("RegenerateMetadata is not supported.");
    }

    public long nextAppendIndex() {
        return this.appendIndex.incrementAndGet();
    }

    public long getLastAppendIndex() {
        return this.appendIndex.getAcquire();
    }
}

