/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import java.util.concurrent.TimeUnit;
import org.neo4j.graphdb.Entity;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterable;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.AnyTokens;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.graphdb.schema.IndexDefinition;

public class GraphDatabaseServiceCleaner {
    private GraphDatabaseServiceCleaner() {
        throw new UnsupportedOperationException();
    }

    public static void cleanDatabaseContent(GraphDatabaseService db) {
        GraphDatabaseServiceCleaner.cleanupSchema(db);
        GraphDatabaseServiceCleaner.cleanupAllRelationshipsAndNodes(db);
    }

    public static void cleanupSchema(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();){
            for (ConstraintDefinition constraint : tx.schema().getConstraints()) {
                constraint.drop();
            }
            for (IndexDefinition index : tx.schema().getIndexes()) {
                index.drop();
            }
            tx.commit();
        }
        tx = db.beginTx();
        try {
            tx.schema().indexFor(AnyTokens.ANY_RELATIONSHIP_TYPES).withName("rti").create();
            tx.schema().indexFor(AnyTokens.ANY_LABELS).withName("lti").create();
            tx.commit();
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
        tx = db.beginTx();
        try {
            tx.schema().awaitIndexesOnline(1L, TimeUnit.MINUTES);
        }
        finally {
            if (tx != null) {
                tx.close();
            }
        }
    }

    public static void cleanupAllRelationshipsAndNodes(GraphDatabaseService db) {
        try (Transaction tx = db.beginTx();
             ResourceIterable allRelationships = tx.getAllRelationships();
             ResourceIterable allNodes = tx.getAllNodes();){
            allRelationships.forEach(Entity::delete);
            allNodes.forEach(Node::delete);
            tx.commit();
        }
    }
}

