/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.transaction;

import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.TransactionId;
import org.neo4j.storageengine.api.TransactionIdStore;
import org.neo4j.util.concurrent.ArrayQueueOutOfOrderSequence;
import org.neo4j.util.concurrent.OutOfOrderSequence;

public class SimpleTransactionIdStore
implements TransactionIdStore {
    private final AtomicLong committingTransactionId = new AtomicLong();
    private final OutOfOrderSequence closedTransactionId = new ArrayQueueOutOfOrderSequence(-1L, 100, new long[4]);
    private final AtomicReference<TransactionId> committedTransactionId = new AtomicReference<TransactionId>(new TransactionId(1L, -559063315, 0L, -1L));

    public SimpleTransactionIdStore() {
        this(1L, -559063315, 0L, -1L, 0L, 64L);
    }

    public SimpleTransactionIdStore(long previouslyCommittedTxId, int checksum, long previouslyCommittedTxCommitTimestamp, long previousConsensusIndex, long previouslyCommittedTxLogVersion, long previouslyCommittedTxLogByteOffset) {
        assert (previouslyCommittedTxId >= 1L) : "cannot start from a tx id less than BASE_TX_ID";
        this.setLastCommittedAndClosedTransactionId(previouslyCommittedTxId, checksum, previouslyCommittedTxCommitTimestamp, previousConsensusIndex, previouslyCommittedTxLogByteOffset, previouslyCommittedTxLogVersion);
    }

    public long nextCommittingTransactionId() {
        return this.committingTransactionId.incrementAndGet();
    }

    public long committingTransactionId() {
        return this.committingTransactionId.get();
    }

    public synchronized void transactionCommitted(long transactionId, int checksum, long commitTimestamp, long consensusIndex) {
        TransactionId current = this.committedTransactionId.get();
        if (current == null || transactionId > current.transactionId()) {
            this.committedTransactionId.set(new TransactionId(transactionId, checksum, commitTimestamp, consensusIndex));
        }
    }

    public long getLastCommittedTransactionId() {
        return this.committedTransactionId.get().transactionId();
    }

    public TransactionId getLastCommittedTransaction() {
        return this.committedTransactionId.get();
    }

    public long getLastClosedTransactionId() {
        return this.closedTransactionId.getHighestGapFreeNumber();
    }

    public TransactionIdSnapshot getClosedTransactionSnapshot() {
        return new TransactionIdSnapshot(this.closedTransactionId.reverseSnapshot());
    }

    public ClosedTransactionMetadata getLastClosedTransaction() {
        long[] data = this.closedTransactionId.get();
        return new ClosedTransactionMetadata(data[0], new LogPosition(data[1], data[2]), (int)data[3], data[4], data[5]);
    }

    public void setLastCommittedAndClosedTransactionId(long transactionId, int checksum, long commitTimestamp, long consensusIndex, long byteOffset, long logVersion) {
        this.committingTransactionId.set(transactionId);
        this.committedTransactionId.set(new TransactionId(transactionId, checksum, commitTimestamp, consensusIndex));
        this.closedTransactionId.set(transactionId, new long[]{logVersion, byteOffset, checksum, commitTimestamp, consensusIndex});
    }

    public void transactionClosed(long transactionId, long logVersion, long byteOffset, int checksum, long commitTimestamp, long consensusIndex) {
        this.closedTransactionId.offer(transactionId, new long[]{logVersion, byteOffset, checksum, commitTimestamp, consensusIndex});
    }

    public void resetLastClosedTransaction(long transactionId, long byteOffset, long logVersion, int checksum, long commitTimestamp, long consensusIndex) {
        this.closedTransactionId.set(transactionId, new long[]{logVersion, byteOffset, checksum, commitTimestamp, consensusIndex});
    }
}

