/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.schema.vector;

import java.io.Serializable;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.LazyFloatIterable;
import org.eclipse.collections.api.LazyIterable;
import org.eclipse.collections.api.block.function.Function;
import org.eclipse.collections.api.block.function.primitive.DoubleToFloatFunction;
import org.eclipse.collections.api.block.function.primitive.FloatToObjectFunction;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.factory.list.ImmutableListFactory;
import org.eclipse.collections.api.factory.primitive.FloatLists;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.api.list.MutableList;
import org.neo4j.values.storable.FloatingPointArray;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.Values;

public class VectorTestUtils {
    public static final Iterable<Value> EUCLIDEAN_VALID_VECTORS_FROM_VALUE;
    public static final Iterable<Value> EUCLIDEAN_INVALID_VECTORS_FROM_VALUE;
    public static final Iterable<List<Double>> EUCLIDEAN_VALID_VECTORS_FROM_DOUBLE_LIST;
    public static final Iterable<List<Double>> EUCLIDEAN_INVALID_VECTORS_FROM_DOUBLE_LIST;
    public static final Iterable<Value> COSINE_VALID_VECTORS_FROM_VALUE;
    public static final Iterable<Value> COSINE_INVALID_VECTORS_FROM_VALUE;
    public static final Iterable<List<Double>> COSINE_VALID_VECTORS_FROM_DOUBLE_LIST;
    public static final Iterable<List<Double>> COSINE_INVALID_VECTORS_FROM_DOUBLE_LIST;

    private static float[] toPrimitive(float ... array) {
        return array;
    }

    private static double[] promote(float ... array) {
        if (array == null) {
            return null;
        }
        double[] promoted = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            promoted[i] = array[i];
        }
        return promoted;
    }

    private static LazyIterable<float[]> signPermutations(float ... values) {
        if (values == null) {
            return null;
        }
        int floatSignBit = Integer.MIN_VALUE;
        int n = 1 << values.length;
        MutableList perms = Lists.mutable.withInitialCapacity(n);
        for (int p = 0; p < n; ++p) {
            float[] perm = new float[values.length];
            for (int i = 0; i < values.length; ++i) {
                boolean set = (p & 1 << i) != 0;
                int sign = set ? Integer.MIN_VALUE : 0;
                int value = Float.floatToRawIntBits(values[i]);
                perm[i] = Float.intBitsToFloat(value ^ sign);
            }
            perms.add((Object)perm);
        }
        return perms.asLazy();
    }

    private static LazyIterable<double[]> signPermutations(double ... values) {
        if (values == null) {
            return null;
        }
        long doubleSignBit = Long.MIN_VALUE;
        int n = 1 << values.length;
        MutableList perms = Lists.mutable.withInitialCapacity(n);
        for (int p = 0; p < n; ++p) {
            double[] perm = new double[values.length];
            for (int i = 0; i < values.length; ++i) {
                boolean set = (p & 1 << i) != 0;
                long sign = set ? Long.MIN_VALUE : 0L;
                long value = Double.doubleToRawLongBits(values[i]);
                perm[i] = Double.longBitsToDouble(value ^ sign);
            }
            perms.add((Object)perm);
        }
        return perms.asLazy();
    }

    private static double extremeSameFloatValue(double value) {
        int floatSignificandWidth = 24;
        int doubleSignificandWidth = 53;
        int mask = 0xFFFFFFF;
        return Double.longBitsToDouble(Double.doubleToRawLongBits(value) | 0xFFFFFFFL);
    }

    static {
        double smallerDoubleThanSmallestFloatButSameValue = VectorTestUtils.extremeSameFloatValue(-3.4028234663852886E38);
        double smallerDoubleThanSmallestFloat = Math.nextDown(smallerDoubleThanSmallestFloatButSameValue);
        double largerDoubleThanLargestFloatButSameValue = VectorTestUtils.extremeSameFloatValue(3.4028234663852886E38);
        double largerDoubleThanLargestFloat = Math.nextUp(largerDoubleThanLargestFloatButSameValue);
        float squareRootSmallestPositiveFloat = (float)Math.sqrt(Math.nextUp(0.0f));
        float squareRootLargestFloat = (float)Math.sqrt(3.4028234663852886E38);
        float squareRootHalfLargestFloat = (float)Math.sqrt(1.7014117331926443E38);
        double largerThanSquareRootLargestDouble = Math.nextUp(Math.sqrt(Double.MAX_VALUE));
        LazyFloatIterable floatFiniteNonZeroPositiveExtremePrimitiveFloats = FloatLists.immutable.of(new float[]{Float.MIN_VALUE, Float.MIN_NORMAL, Float.MAX_VALUE}).asLazy();
        LazyIterable floatFiniteNonZeroExtremePrimitiveFloatArrays = floatFiniteNonZeroPositiveExtremePrimitiveFloats.asLazy().flatCollect((FloatToObjectFunction & Serializable)xva$0 -> VectorTestUtils.signPermutations(xva$0));
        LazyIterable floatFiniteNonZeroExtremeBoxedFloatArrays = floatFiniteNonZeroExtremePrimitiveFloatArrays.collect(ArrayUtils::toObject);
        LazyIterable floatFiniteNonZeroExtremeFloatArrays = Lists.mutable.withAll((Iterable)floatFiniteNonZeroExtremePrimitiveFloatArrays.asLazy().collect(Values::of)).withAll((Iterable)floatFiniteNonZeroExtremeBoxedFloatArrays.asLazy().collect(Values::of)).asLazy();
        LazyIterable floatFiniteNonZeroExtremePrimitiveDoubleArrays = Lists.mutable.of((Object[])new Double[]{smallerDoubleThanSmallestFloatButSameValue, largerDoubleThanLargestFloatButSameValue, Double.MIN_VALUE, Double.MIN_NORMAL}).flatCollect((Function & Serializable)xva$0 -> VectorTestUtils.signPermutations(xva$0)).withAll((Iterable)floatFiniteNonZeroExtremePrimitiveFloatArrays.asLazy().collect(VectorTestUtils::promote)).asLazy();
        LazyIterable floatFiniteNonZeroExtremeBoxedDoubleArrays = floatFiniteNonZeroExtremePrimitiveDoubleArrays.collect(ArrayUtils::toObject);
        LazyIterable floatFiniteNonZeroExtremeDoubleArrays = Lists.mutable.withAll((Iterable)floatFiniteNonZeroExtremePrimitiveDoubleArrays.asLazy().collect(Values::of)).withAll((Iterable)floatFiniteNonZeroExtremeBoxedDoubleArrays.asLazy().collect(Values::of)).asLazy();
        LazyIterable<float[]> floatFiniteZeroPrimitiveFloatArrays = VectorTestUtils.signPermutations(0.0f);
        LazyIterable floatFiniteZeroBoxedFloatArrays = floatFiniteZeroPrimitiveFloatArrays.collect(ArrayUtils::toObject);
        LazyIterable floatFiniteZeroFloatArrays = Lists.mutable.withAll((Iterable)floatFiniteZeroPrimitiveFloatArrays.asLazy().collect(Values::of)).withAll((Iterable)floatFiniteZeroBoxedFloatArrays.asLazy().collect(Values::of)).asLazy();
        LazyIterable floatFiniteZeroPrimitiveDoubleArrays = floatFiniteZeroPrimitiveFloatArrays.collect(VectorTestUtils::promote);
        LazyIterable floatFiniteZeroBoxedDoubleArrays = floatFiniteZeroPrimitiveDoubleArrays.collect(ArrayUtils::toObject);
        LazyIterable floatFiniteZeroDoubleArrays = Lists.mutable.withAll((Iterable)floatFiniteZeroPrimitiveDoubleArrays.asLazy().collect(Values::of)).withAll((Iterable)floatFiniteZeroBoxedDoubleArrays.asLazy().collect(Values::of)).asLazy();
        LazyFloatIterable floatFiniteNonZeroSqrtExtremePrimitiveFloats = floatFiniteNonZeroPositiveExtremePrimitiveFloats.asLazy().collectDouble(Math::sqrt).collectFloat((DoubleToFloatFunction & Serializable)v -> (float)v);
        LazyIterable floatFiniteSquareL2NormPrimitiveFloatArrays = Lists.mutable.of((Object[])new float[][]{VectorTestUtils.toPrimitive(0.0f, squareRootLargestFloat), VectorTestUtils.toPrimitive(squareRootLargestFloat, 0.0f), VectorTestUtils.toPrimitive(squareRootSmallestPositiveFloat, squareRootSmallestPositiveFloat), VectorTestUtils.toPrimitive(squareRootHalfLargestFloat, squareRootHalfLargestFloat)}).withAll((Iterable)floatFiniteNonZeroSqrtExtremePrimitiveFloats.asLazy().collect((FloatToObjectFunction & Serializable)xva$0 -> VectorTestUtils.toPrimitive(xva$0))).asLazy().flatCollect(VectorTestUtils::signPermutations);
        LazyIterable floatFiniteSquareL2NormBoxedFloatArrays = floatFiniteSquareL2NormPrimitiveFloatArrays.collect(ArrayUtils::toObject);
        LazyIterable floatFiniteSquareL2NormFloatArrays = Lists.mutable.withAll((Iterable)floatFiniteSquareL2NormPrimitiveFloatArrays.asLazy().collect(Values::of)).withAll((Iterable)floatFiniteSquareL2NormBoxedFloatArrays.asLazy().collect(Values::of)).asLazy();
        LazyIterable floatFiniteSquareL2NormPrimitiveDoubleArrays = floatFiniteSquareL2NormPrimitiveFloatArrays.collect(VectorTestUtils::promote);
        LazyIterable floatFiniteSquareL2NormBoxedDoubleArrays = floatFiniteSquareL2NormPrimitiveDoubleArrays.collect(ArrayUtils::toObject);
        LazyIterable floatFiniteSquareL2NormDoubleArrays = Lists.mutable.withAll((Iterable)floatFiniteSquareL2NormPrimitiveDoubleArrays.asLazy().collect(Values::of)).withAll((Iterable)floatFiniteSquareL2NormBoxedDoubleArrays.asLazy().collect(Values::of)).asLazy();
        LazyIterable nonFloatFinitePrimitiveFloatArrays = Lists.mutable.withAll(VectorTestUtils.signPermutations(Float.NaN, Float.NEGATIVE_INFINITY, Float.POSITIVE_INFINITY)).with((Object)new float[0]).with(null).asLazy();
        LazyIterable nonFloatFiniteBoxedFloatArrays = nonFloatFinitePrimitiveFloatArrays.collect(ArrayUtils::toObject);
        LazyIterable nonFloatFiniteFloatArrays = Lists.mutable.withAll((Iterable)nonFloatFinitePrimitiveFloatArrays.asLazy().collect(Values::of)).withAll((Iterable)nonFloatFiniteBoxedFloatArrays.asLazy().collect(Values::of)).with((Object)Values.NO_VALUE).with(null).asLazy();
        LazyIterable nonFloatFinitePrimitiveDoubleArrays = Lists.mutable.of((Object[])new Double[]{smallerDoubleThanSmallestFloat, largerDoubleThanLargestFloat, Double.MAX_VALUE, Double.NaN, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY}).flatCollect((Function & Serializable)xva$0 -> VectorTestUtils.signPermutations(xva$0)).withAll((Iterable)nonFloatFinitePrimitiveFloatArrays.asLazy().collect(VectorTestUtils::promote)).with(null).asLazy();
        LazyIterable nonFloatFiniteBoxedDoubleArrays = nonFloatFinitePrimitiveDoubleArrays.collect(ArrayUtils::toObject);
        LazyIterable nonFloatFiniteDoubleArrays = Lists.mutable.withAll((Iterable)nonFloatFinitePrimitiveDoubleArrays.asLazy().collect(Values::of)).withAll((Iterable)nonFloatFiniteBoxedDoubleArrays.asLazy().collect(Values::of)).with((Object)Values.NO_VALUE).with(null).asLazy();
        LazyIterable nonFloatFiniteSquareL2NormPrimitiveFloatArrays = Lists.mutable.of((Object[])new float[][]{VectorTestUtils.toPrimitive(0.0f, 0.0f), VectorTestUtils.toPrimitive(squareRootHalfLargestFloat, Math.nextUp(squareRootHalfLargestFloat)), VectorTestUtils.toPrimitive(Float.MAX_VALUE, Float.MAX_VALUE)}).asLazy().flatCollect(VectorTestUtils::signPermutations);
        LazyIterable nonFloatFiniteSquareL2NormBoxedFloatArrays = nonFloatFiniteSquareL2NormPrimitiveFloatArrays.collect(ArrayUtils::toObject);
        LazyIterable nonFloatFiniteSquareL2NormFloatArrays = Lists.mutable.withAll((Iterable)nonFloatFiniteSquareL2NormPrimitiveFloatArrays.asLazy().collect(Values::of)).withAll((Iterable)nonFloatFiniteSquareL2NormBoxedFloatArrays.asLazy().collect(Values::of)).asLazy();
        LazyIterable nonFloatFiniteSquareL2NormPrimitiveDoubleArrays = Lists.mutable.withAll(VectorTestUtils.signPermutations(largerThanSquareRootLargestDouble, largerThanSquareRootLargestDouble)).withAll((Iterable)nonFloatFiniteSquareL2NormPrimitiveFloatArrays.asLazy().collect(VectorTestUtils::promote)).asLazy();
        LazyIterable nonFloatFiniteSquareL2NormBoxedDoubleArrays = nonFloatFiniteSquareL2NormPrimitiveDoubleArrays.collect(ArrayUtils::toObject);
        LazyIterable nonFloatFiniteSquareL2NormDoubleArrays = Lists.mutable.withAll((Iterable)nonFloatFiniteSquareL2NormPrimitiveDoubleArrays.asLazy().collect(Values::of)).withAll((Iterable)nonFloatFiniteSquareL2NormBoxedDoubleArrays.asLazy().collect(Values::of)).asLazy();
        Comparator<Value> valueComparator = Comparator.nullsFirst(Comparator.comparing(Value::valueRepresentation).thenComparing((lhs, rhs) -> {
            FloatingPointArray flhs;
            block7: {
                block6: {
                    if (!(lhs instanceof FloatingPointArray)) break block6;
                    flhs = (FloatingPointArray)lhs;
                    if (rhs instanceof FloatingPointArray) break block7;
                }
                if (Objects.equals(lhs, rhs)) {
                    return 0;
                }
                return Comparator.comparing(o -> o.getClass().descriptorString()).compare(lhs, rhs);
            }
            FloatingPointArray frhs = (FloatingPointArray)rhs;
            int comparison = Integer.compare(flhs.length(), frhs.length());
            if (comparison != 0) {
                return comparison;
            }
            for (int i = 0; i < flhs.length(); ++i) {
                comparison = Double.compare(flhs.doubleValue(i), frhs.doubleValue(i));
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }));
        Comparator<List> listComparator = Comparator.nullsFirst(Comparator.comparingInt(List::size).thenComparing((lhs, rhs) -> {
            for (int i = 0; i < lhs.size(); ++i) {
                int comparison = Double.compare((Double)lhs.get(i), (Double)rhs.get(i));
                if (comparison == 0) continue;
                return comparison;
            }
            return 0;
        }));
        COSINE_VALID_VECTORS_FROM_VALUE = Lists.mutable.withAll((Iterable)floatFiniteSquareL2NormFloatArrays).withAll((Iterable)floatFiniteSquareL2NormDoubleArrays).toImmutableSortedSet(valueComparator);
        COSINE_VALID_VECTORS_FROM_DOUBLE_LIST = Lists.mutable.withAll((Iterable)floatFiniteSquareL2NormBoxedDoubleArrays).asLazy().collect(arg_0 -> ((ImmutableListFactory)Lists.immutable).of(arg_0)).collect(ImmutableList::castToList).toImmutableSortedSet(listComparator);
        EUCLIDEAN_VALID_VECTORS_FROM_VALUE = Lists.mutable.withAll((Iterable)floatFiniteZeroFloatArrays).withAll((Iterable)floatFiniteZeroDoubleArrays).withAll((Iterable)floatFiniteNonZeroExtremeFloatArrays).withAll((Iterable)floatFiniteNonZeroExtremeDoubleArrays).withAll(COSINE_VALID_VECTORS_FROM_VALUE).toImmutableSortedSet(valueComparator);
        EUCLIDEAN_VALID_VECTORS_FROM_DOUBLE_LIST = Lists.mutable.withAll((Iterable)floatFiniteZeroBoxedDoubleArrays).collect(arg_0 -> ((ImmutableListFactory)Lists.immutable).of(arg_0)).collect(ImmutableList::castToList).withAll(COSINE_VALID_VECTORS_FROM_DOUBLE_LIST).toImmutableSortedSet(listComparator);
        EUCLIDEAN_INVALID_VECTORS_FROM_VALUE = Lists.mutable.withAll((Iterable)nonFloatFiniteFloatArrays).withAll((Iterable)nonFloatFiniteDoubleArrays).with(null).toSortedSet(valueComparator).asUnmodifiable();
        EUCLIDEAN_INVALID_VECTORS_FROM_DOUBLE_LIST = Lists.mutable.withAll((Iterable)nonFloatFiniteBoxedDoubleArrays.asLazy().collect(arg_0 -> ((ImmutableListFactory)Lists.immutable).of(arg_0)).collect(ImmutableList::castToList)).with(null).toSortedSet(listComparator).asUnmodifiable();
        COSINE_INVALID_VECTORS_FROM_VALUE = Lists.mutable.withAll((Iterable)nonFloatFiniteSquareL2NormFloatArrays).withAll((Iterable)nonFloatFiniteSquareL2NormDoubleArrays).withAll(EUCLIDEAN_INVALID_VECTORS_FROM_VALUE).toSortedSet(valueComparator).asUnmodifiable();
        COSINE_INVALID_VECTORS_FROM_DOUBLE_LIST = Lists.mutable.withAll((Iterable)nonFloatFiniteSquareL2NormBoxedDoubleArrays.asLazy().collect(arg_0 -> ((ImmutableListFactory)Lists.immutable).of(arg_0)).collect(ImmutableList::castToList)).withAll(EUCLIDEAN_INVALID_VECTORS_FROM_DOUBLE_LIST).toSortedSet(listComparator).asUnmodifiable();
    }
}

