/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.test;

import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.dbms.database.DbmsRuntimeVersion;
import org.neo4j.graphdb.config.Configuration;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.kernel.BinarySupportedKernelVersions;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.KernelVersionProvider;
import org.neo4j.kernel.KernelVersionProviders;
import org.neo4j.kernel.impl.transaction.log.LogFormatVersionProvider;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;

public final class LatestVersions {
    public static final KernelVersion LATEST_KERNEL_VERSION = KernelVersion.getLatestVersion((Configuration)Config.defaults());
    public static final KernelVersionProvider LATEST_KERNEL_VERSION_PROVIDER = KernelVersionProviders.fixed((KernelVersion)LATEST_KERNEL_VERSION);
    public static final DbmsRuntimeVersion LATEST_RUNTIME_VERSION = DbmsRuntimeVersion.getLatestVersion((Config)Config.defaults());
    public static final BinarySupportedKernelVersions BINARY_VERSIONS = new BinarySupportedKernelVersions(Config.defaults());
    public static final LogFormat LATEST_LOG_FORMAT = LogFormat.fromConfigAndKernelVersion((Config)Config.defaults(), (KernelVersion)LATEST_KERNEL_VERSION);
    public static final LogFormatVersionProvider LATEST_LOG_FORMAT_PROVIDER = () -> LATEST_LOG_FORMAT;
    public static final KernelVersion LATEST_KERNEL_VERSION_WITHOUT_ENVELOPES = LogFormat.getLastVersionPreEnvelopeFormat();
    public static final DbmsRuntimeVersion LATEST_RUNTIME_VERSION_WITHOUT_ENVELOPES = LatestVersions.findDbmsVersionMatchingKernelVersion(LATEST_KERNEL_VERSION_WITHOUT_ENVELOPES);
    public static final BinarySupportedKernelVersions FUTURE_BINARY_VERSIONS = new BinarySupportedKernelVersions(Config.defaults((Setting)GraphDatabaseInternalSettings.latest_kernel_version, (Object)KernelVersion.GLORIOUS_FUTURE.version()));

    private static DbmsRuntimeVersion findDbmsVersionMatchingKernelVersion(KernelVersion version) {
        for (DbmsRuntimeVersion dbmsRuntimeVersion : DbmsRuntimeVersion.VERSIONS) {
            if (dbmsRuntimeVersion.kernelVersion() != version) continue;
            return dbmsRuntimeVersion;
        }
        throw new IllegalArgumentException("No matching Dbms version found for " + version.toString());
    }

    private LatestVersions() {
    }
}

