/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.procedure.impl;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.function.Function;
import java.util.jar.JarOutputStream;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.asm.MemberAttributeExtension;
import net.bytebuddy.description.annotation.AnnotationDescription;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.method.MethodList;
import net.bytebuddy.description.modifier.ModifierContributor;
import net.bytebuddy.description.modifier.Visibility;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.dynamic.DynamicType;
import net.bytebuddy.dynamic.scaffold.subclass.ConstructorStrategy;
import net.bytebuddy.implementation.FieldAccessor;
import net.bytebuddy.implementation.Implementation;
import net.bytebuddy.implementation.MethodCall;
import net.bytebuddy.implementation.MethodDelegation;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.neo4j.kernel.api.procedure.GlobalProcedures;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.kernel.extension.ExtensionType;
import org.neo4j.kernel.extension.context.ExtensionContext;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.internal.LogService;
import org.neo4j.procedure.Context;

public final class CustomExtensionUtils {
    public static final String PACKAGE_NAME = "my.awesome";
    public static final String PROCEDURE_NAME = "customProcedure";
    public static final String EXTENSION_PROCEDURE_NAME = "extensionCustomProcedure";
    public static final String CANONICAL_PROCEDURE_NAME = CustomExtensionUtils.packageName("customProcedure");
    public static final String CANONICAL_EXTENSION_PROCEDURE_NAME = CustomExtensionUtils.packageName("extensionCustomProcedure");
    public static final String LOG_MARKER = "HELLO WORLD";
    public static final String DEFAULT_OUTPUT_STRING = "HELLO WORLD";

    private CustomExtensionUtils() {
    }

    public static Extension createExtension() {
        DynamicType.Unloaded<?> dependenciesInterfaceType = CustomExtensionUtils.makeDependenciesInterfaceType();
        DynamicType.Unloaded<?> dependenciesImplementationType = CustomExtensionUtils.makeDependenciesImplementationType(dependenciesInterfaceType);
        DynamicType.Unloaded<?> extensionType = CustomExtensionUtils.makeExtensionType(dependenciesInterfaceType);
        DynamicType.Unloaded<?> extensionFactoryType = CustomExtensionUtils.makeExtensionFactoryType(dependenciesInterfaceType, extensionType);
        return new Extension(dependenciesInterfaceType, dependenciesImplementationType, extensionType, extensionFactoryType);
    }

    public static Procedure createProcedure(String procedureName, String outputValue) {
        OutputDefinition outputDefinition = CustomExtensionUtils.makeOutputDefinition();
        DynamicType.Unloaded<?> procedureType = CustomExtensionUtils.makeProcedureType(outputDefinition, procedureName, outputValue);
        return new Procedure(outputDefinition.type(), procedureType);
    }

    public static Procedure createProcedure() {
        return CustomExtensionUtils.createProcedure(PROCEDURE_NAME, "HELLO WORLD");
    }

    public static ProcedureWithExtension createProcedureWithExtension() {
        Extension extensionTypes = CustomExtensionUtils.createExtension();
        OutputDefinition outputDefinition = CustomExtensionUtils.makeOutputDefinition();
        DynamicType.Unloaded<?> procedureType = CustomExtensionUtils.makeExtensionProcedureType(outputDefinition, EXTENSION_PROCEDURE_NAME, extensionTypes.extensionType);
        return new ProcedureWithExtension(extensionTypes, outputDefinition.type(), procedureType);
    }

    public static void createProcedureJar(Path path, String procedureName, String outputValue) {
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            CustomExtensionUtils.createProcedure(procedureName, outputValue).toJar(path);
        }
        catch (IOException exc) {
            throw new UncheckedIOException(exc);
        }
    }

    public static void createProcedureJar(Path path) {
        CustomExtensionUtils.createProcedureJar(path, PROCEDURE_NAME, "HELLO WORLD");
    }

    public static void createProcedureWithExtensionJar(Path path) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        CustomExtensionUtils.createProcedureWithExtension().toJar(path);
    }

    private static OutputDefinition makeOutputDefinition() {
        DynamicType.Unloaded type = CustomExtensionUtils.constructorWithFieldsWithGetter(new ByteBuddy().subclass(Object.class).name(CustomExtensionUtils.packageName("CustomOutput")), CustomExtensionUtils.getConstructor(Object.class), "output", String.class).make();
        Function<String, MethodCall> make = value -> MethodCall.construct((MethodDescription)((MethodDescription)((MethodList)type.getTypeDescription().getDeclaredMethods().filter((ElementMatcher)ElementMatchers.isConstructor().and((ElementMatcher)ElementMatchers.takesArguments((Class[])new Class[]{String.class})))).getOnly())).with(new Object[]{value});
        return new OutputDefinition(type, make);
    }

    private static DynamicType.Builder<?> procedureBuilder(TypeDescription outputType, MethodCall makeOutputType, String procedureName) {
        AnnotationDescription annotation = AnnotationDescription.Builder.ofType(org.neo4j.procedure.Procedure.class).define("name", CustomExtensionUtils.packageName(procedureName)).build();
        TypeDescription streamType = TypeDescription.ForLoadedType.of(Stream.class);
        TypeDescription.Generic genericStreamType = TypeDescription.Generic.Builder.parameterizedType((TypeDescription)streamType, (TypeDefinition[])new TypeDefinition[]{outputType}).build();
        MethodDescription.InDefinedShape streamOf = (MethodDescription.InDefinedShape)((MethodList)streamType.getDeclaredMethods().filter((ElementMatcher)ElementMatchers.named((String)"of").and((ElementMatcher)ElementMatchers.takesArguments((Class[])new Class[]{Object.class})))).getOnly();
        return new ByteBuddy().subclass(Object.class).defineMethod(procedureName, (TypeDefinition)genericStreamType, 1).intercept((Implementation)MethodCall.invoke((MethodDescription)streamOf).withMethodCall(makeOutputType)).visit(new MemberAttributeExtension.ForMethod().annotateMethod(new AnnotationDescription[]{annotation}).on((ElementMatcher)ElementMatchers.nameEndsWith((String)"Procedure")));
    }

    private static DynamicType.Unloaded<?> makeProcedureType(OutputDefinition outputDefinition, String procedureName, String stringOutput) {
        DynamicType.Unloaded<?> outputType = outputDefinition.type();
        return CustomExtensionUtils.procedureBuilder(outputType.getTypeDescription(), outputDefinition.make().apply(stringOutput), procedureName).make().include(new DynamicType[]{outputType});
    }

    private static DynamicType.Unloaded<?> makeExtensionProcedureType(OutputDefinition outputDefinition, String procedureName, DynamicType.Unloaded<?> extensionType) {
        AnnotationDescription annotation = AnnotationDescription.Builder.ofType(Context.class).build();
        DynamicType.Unloaded<?> outputType = outputDefinition.type();
        return CustomExtensionUtils.procedureBuilder(outputType.getTypeDescription(), outputDefinition.make().apply("I can't be reloaded"), procedureName).defineField("extension", (TypeDefinition)extensionType.getTypeDescription(), 1).visit(new MemberAttributeExtension.ForField().annotate(new AnnotationDescription[]{annotation}).on((ElementMatcher)ElementMatchers.named((String)"extension"))).make().include(new DynamicType[]{outputType, extensionType});
    }

    private static DynamicType.Unloaded<?> makeDependenciesInterfaceType() {
        return new ByteBuddy().makeInterface().name(CustomExtensionUtils.packageName("Dependencies")).defineMethod("log", LogService.class, 1).withoutCode().defineMethod("globalProcedures", GlobalProcedures.class, 1).withoutCode().make();
    }

    private static DynamicType.Unloaded<?> makeDependenciesImplementationType(DynamicType.Unloaded<?> dependencyProxyInterface) {
        return CustomExtensionUtils.constructorWithFieldsWithGetter(new ByteBuddy().subclass(Object.class).implement(new TypeDefinition[]{dependencyProxyInterface.getTypeDescription()}).name(CustomExtensionUtils.packageName("DependenciesProxy")), CustomExtensionUtils.getConstructor(Object.class), "log", LogService.class, "globalProcedures", GlobalProcedures.class).make().include(new DynamicType[]{dependencyProxyInterface});
    }

    private static DynamicType.Unloaded<?> makeExtensionType(DynamicType.Unloaded<?> dependencyInterfaceType) {
        MethodCall logMessage = MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)"info").and((ElementMatcher)ElementMatchers.takesArguments((Class[])new Class[]{String.class}))).onMethodCall(MethodCall.invoke((Method)CustomExtensionUtils.getDeclaredMethod(LogService.class, "getInternalLog", Class.class)).onField("log").withOwnType()).with(new Object[]{"HELLO WORLD"});
        return CustomExtensionUtils.constructorWithFieldsWithGetter(new ByteBuddy().subclass(LifecycleAdapter.class).name(CustomExtensionUtils.packageName("CustomExtension")), CustomExtensionUtils.getConstructor(LifecycleAdapter.class), "log", LogService.class, "globalProcedures", GlobalProcedures.class).defineConstructor(1).withParameters(new TypeDefinition[]{dependencyInterfaceType.getTypeDescription()}).intercept((Implementation)MethodCall.invoke((ElementMatcher)ElementMatchers.isConstructor().and((ElementMatcher)ElementMatchers.takesArguments((Class[])new Class[]{LogService.class, GlobalProcedures.class}))).withMethodCall(MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)"log")).onArgument(0)).withMethodCall(MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)"globalProcedures")).onArgument(0))).defineMethod("init", Void.TYPE, 1).intercept(MethodCall.invoke((Method)CustomExtensionUtils.getDeclaredMethod(CustomExtensionUtils.class, "registrationHelper", GlobalProcedures.class, Class.class, Object.class)).withField(new String[]{"globalProcedures"}).withOwnType().withThis().andThen((Implementation)logMessage)).make().include(new DynamicType[]{dependencyInterfaceType});
    }

    private static DynamicType.Unloaded<?> makeExtensionFactoryType(DynamicType.Unloaded<?> dependenciesInterfaceType, DynamicType.Unloaded<?> extensionType) {
        TypeDescription extensionContextType = TypeDescription.ForLoadedType.of(ExtensionContext.class);
        TypeDescription.Generic genericExtensionFactoryType = TypeDescription.Generic.Builder.parameterizedType((TypeDescription)TypeDescription.ForLoadedType.of(ExtensionFactory.class), (TypeDefinition[])new TypeDefinition[]{dependenciesInterfaceType.getTypeDescription()}).build();
        return new ByteBuddy().subclass((TypeDefinition)genericExtensionFactoryType.asGenericType(), (ConstructorStrategy)ConstructorStrategy.Default.NO_CONSTRUCTORS).name(CustomExtensionUtils.packageName("CustomExtensionFactory")).defineConstructor(new ModifierContributor.ForMethod[]{Visibility.PUBLIC}).intercept((Implementation)MethodCall.invoke((ElementMatcher)ElementMatchers.isConstructor().and((ElementMatcher)ElementMatchers.takesArguments((Class[])new Class[]{ExtensionType.class, String.class}))).with(new Object[]{ExtensionType.DATABASE, "CUSTOM_EXTENSION_FACTORY"})).defineMethod("newInstance", Lifecycle.class, new ModifierContributor.ForMethod[0]).withParameters(new Type[]{LogService.class, GlobalProcedures.class}).intercept((Implementation)MethodDelegation.toConstructor((TypeDescription)extensionType.getTypeDescription())).defineMethod("newInstance", Lifecycle.class, new ModifierContributor.ForMethod[0]).withParameters(new TypeDefinition[]{extensionContextType, dependenciesInterfaceType.getTypeDescription()}).intercept((Implementation)MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)"newInstance").and((ElementMatcher)ElementMatchers.takesArguments((Class[])new Class[]{LogService.class, GlobalProcedures.class}))).withMethodCall(MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)"log")).onArgument(1)).withMethodCall(MethodCall.invoke((ElementMatcher)ElementMatchers.named((String)"globalProcedures")).onArgument(1))).make().include(new DynamicType[]{dependenciesInterfaceType, extensionType});
    }

    public static <T> void registrationHelper(GlobalProcedures registry, Class<T> cls, Object self) {
        registry.registerComponent(cls, ctx -> cls.cast(self), true);
    }

    private static DynamicType.Builder<?> constructorWithFieldsWithGetter(DynamicType.Builder<?> builder, Constructor<?> superConstructor, String f1, Class<?> t1) {
        return builder.defineField(f1, t1, 1).defineConstructor(1).withParameters(new Type[]{t1}).intercept((Implementation)MethodCall.invoke(superConstructor).andThen(FieldAccessor.ofField((String)f1).setsArgumentAt(0))).defineMethod(f1, t1, new ModifierContributor.ForMethod[0]).intercept((Implementation)FieldAccessor.ofField((String)f1));
    }

    private static DynamicType.Builder<?> constructorWithFieldsWithGetter(DynamicType.Builder<?> builder, Constructor<?> superConstructor, String f1, Class<?> t1, String f2, Class<?> t2) {
        return builder.defineField(f1, t1, 1).defineField(f2, t2, 1).defineConstructor(1).withParameters(new Type[]{t1, t2}).intercept((Implementation)MethodCall.invoke(superConstructor).andThen(FieldAccessor.ofField((String)f1).setsArgumentAt(0)).andThen(FieldAccessor.ofField((String)f2).setsArgumentAt(1))).defineMethod(f1, t1, new ModifierContributor.ForMethod[0]).intercept((Implementation)FieldAccessor.ofField((String)f1)).defineMethod(f2, t2, new ModifierContributor.ForMethod[0]).intercept((Implementation)FieldAccessor.ofField((String)f2));
    }

    private static Constructor<?> getConstructor(Class<?> cls) {
        try {
            return cls.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException exc) {
            throw new RuntimeException(exc);
        }
    }

    private static Method getDeclaredMethod(Class<?> cls, String name, Class<?> ... arguments) {
        try {
            return cls.getDeclaredMethod(name, arguments);
        }
        catch (NoSuchMethodException exc) {
            throw new RuntimeException(exc);
        }
    }

    private static void addService(JarOutputStream stream, String iface, String cls) throws IOException {
        stream.putNextEntry(new ZipEntry("META-INF/services/" + iface));
        stream.write(cls.getBytes(StandardCharsets.UTF_8));
    }

    public static String packageName(String name) {
        return "my.awesome." + name;
    }

    public static class Extension {
        DynamicType.Unloaded<?> dependenciesInterfaceType;
        DynamicType.Unloaded<?> dependenciesImplementationType;
        DynamicType.Unloaded<?> extensionType;
        DynamicType.Unloaded<?> extensionFactoryType;

        private Extension(DynamicType.Unloaded<?> dependenciesInterfaceType, DynamicType.Unloaded<?> dependenciesImplementationType, DynamicType.Unloaded<?> extensionType, DynamicType.Unloaded<?> extensionFactoryType) {
            this.dependenciesInterfaceType = dependenciesInterfaceType;
            this.dependenciesImplementationType = dependenciesImplementationType;
            this.extensionType = extensionType;
            this.extensionFactoryType = extensionFactoryType;
        }

        public void toJar(Path pth) throws IOException {
            try (JarOutputStream jarOut = new JarOutputStream(Files.newOutputStream(pth, new OpenOption[0]));){
                CustomExtensionUtils.addService(jarOut, ExtensionFactory.class.getCanonicalName(), this.extensionFactoryType.getTypeDescription().getCanonicalName());
            }
            File file = pth.toFile();
            this.dependenciesInterfaceType.inject(file);
            this.extensionType.inject(file);
            this.extensionFactoryType.inject(file);
        }
    }

    record OutputDefinition(DynamicType.Unloaded<?> type, Function<String, MethodCall> make) {
    }

    public static class Procedure {
        DynamicType.Unloaded<?> outputType;
        DynamicType.Unloaded<?> procedureType;

        private Procedure(DynamicType.Unloaded<?> outputType, DynamicType.Unloaded<?> procedureType) {
            this.outputType = outputType;
            this.procedureType = procedureType;
        }

        public void toJar(Path pth) throws IOException {
            File file = pth.toFile();
            this.outputType.toJar(file);
            this.procedureType.inject(file);
        }
    }

    public static class ProcedureWithExtension {
        Extension extensionTypes;
        DynamicType.Unloaded<?> outputType;
        DynamicType.Unloaded<?> procedureType;

        private ProcedureWithExtension(Extension extensionTypes, DynamicType.Unloaded<?> outputType, DynamicType.Unloaded<?> procedureType) {
            this.extensionTypes = extensionTypes;
            this.outputType = outputType;
            this.procedureType = procedureType;
        }

        public void toJar(Path pth) throws IOException {
            this.extensionTypes.toJar(pth);
            File file = pth.toFile();
            this.outputType.inject(file);
            this.procedureType.inject(file);
        }
    }
}

