/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.schema;

import java.util.Arrays;
import java.util.SplittableRandom;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.neo4j.common.EntityType;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.EndpointType;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexPrototype;
import org.neo4j.internal.schema.IndexProviderDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.LabelSchemaDescriptor;
import org.neo4j.internal.schema.RelationTypeSchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaDescriptors;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.ConstraintDescriptorFactory;
import org.neo4j.internal.schema.constraints.IndexBackedConstraintDescriptor;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.SchemaValueType;
import org.neo4j.values.storable.RandomValues;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.ValueType;

public abstract class RandomSchemaBase
implements Supplier<SchemaRule> {
    private final SplittableRandom rng;
    private final int maxPropKeyId;
    private final int maxRelTypeId;
    private final int maxLabelId;
    private final int defaultLabelIdsArrayMaxLength;
    private final int defaultRelationshipTypeIdsArrayMaxLength;
    private final int defaultPropertyKeyIdsArrayMaxLength;
    private final RandomValues values;
    private final ValueType[] textTypes;

    public RandomSchemaBase() {
        this(new SplittableRandom());
    }

    public RandomSchemaBase(SplittableRandom rng) {
        this.rng = rng;
        this.maxPropKeyId = this.maxPropertyKeyId();
        this.maxRelTypeId = this.maxRelationshipTypeId();
        this.maxLabelId = this.maxLabelId();
        this.defaultLabelIdsArrayMaxLength = this.defaultLabelIdsArrayMaxLength();
        this.defaultRelationshipTypeIdsArrayMaxLength = this.defaultRelationshipTypeIdsArrayMaxLength();
        this.defaultPropertyKeyIdsArrayMaxLength = this.defaultPropertyKeyIdsArrayMaxLength();
        this.values = RandomValues.create((SplittableRandom)rng, (RandomValues.Configuration)this.valuesConfiguration());
        this.textTypes = RandomValues.typesOfGroup((ValueGroup)ValueGroup.TEXT);
    }

    protected abstract int maxPropertyKeyId();

    protected abstract int maxRelationshipTypeId();

    protected abstract int maxLabelId();

    protected int defaultLabelIdsArrayMaxLength() {
        return 200;
    }

    protected int defaultRelationshipTypeIdsArrayMaxLength() {
        return 200;
    }

    protected int defaultPropertyKeyIdsArrayMaxLength() {
        return 300;
    }

    protected RandomValues.Default valuesConfiguration() {
        return new RandomValues.Default(this){

            public int stringMaxLength() {
                return 200;
            }

            public int minCodePoint() {
                return super.minCodePoint() + 1;
            }
        };
    }

    public Stream<SchemaRule> schemaRules() {
        return Stream.generate(this);
    }

    @Override
    public SchemaRule get() {
        return this.nextSchemaRule();
    }

    public SchemaRule nextSchemaRule() {
        if (this.rng.nextBoolean()) {
            return this.nextIndex();
        }
        return this.nextConstraint();
    }

    public IndexDescriptor nextIndex() {
        int choice = this.rng.nextInt(4);
        LabelSchemaDescriptor schema = switch (choice) {
            case 0 -> this.nextNodeSchema();
            case 1 -> this.nextNodeFulltextSchema();
            case 2 -> this.nextRelationshipSchema();
            case 3 -> this.nextRelationshipFulltextSchema();
            default -> throw new RuntimeException("Bad index choice: " + choice);
        };
        boolean isUnique = this.rng.nextBoolean() && !schema.isFulltextSchemaDescriptor();
        IndexPrototype prototype = isUnique ? IndexPrototype.uniqueForSchema((SchemaDescriptor)schema) : IndexPrototype.forSchema((SchemaDescriptor)schema);
        IndexProviderDescriptor providerDescriptor = new IndexProviderDescriptor(this.nextName(), this.nextName());
        prototype = prototype.withIndexProvider(providerDescriptor);
        prototype = prototype.withName(this.nextName());
        if (schema.isFulltextSchemaDescriptor()) {
            prototype = prototype.withIndexType(IndexType.FULLTEXT);
        }
        long ruleId = this.nextRuleIdForIndex();
        IndexDescriptor index = prototype.materialise(ruleId);
        if (isUnique && this.rng.nextBoolean()) {
            index = index.withOwningConstraintId(this.existingConstraintId());
        }
        return index;
    }

    public long nextRuleIdForIndex() {
        return this.nextRuleId();
    }

    public long existingConstraintId() {
        return this.nextRuleId();
    }

    public ConstraintDescriptor nextConstraint() {
        long ruleId = this.nextRuleIdForConstraint();
        int choice = this.rng.nextInt(12);
        return switch (choice) {
            case 0 -> ConstraintDescriptorFactory.existsForSchema((SchemaDescriptor)this.nextRelationshipSchema(), (boolean)this.rng.nextBoolean()).withId(ruleId).withName(this.nextName());
            case 1 -> ConstraintDescriptorFactory.existsForSchema((SchemaDescriptor)this.nextNodeSchema(), (boolean)this.rng.nextBoolean()).withId(ruleId).withName(this.nextName());
            case 2 -> ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.nextNodeSchema()).withId(ruleId).withName(this.nextName());
            case 3 -> ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.nextNodeSchema()).withId(ruleId).withOwnedIndexId(this.existingIndexId()).withName(this.nextName());
            case 4 -> ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)this.nextNodeSchema()).withId(ruleId).withName(this.nextName());
            case 5 -> ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)this.nextNodeSchema()).withId(ruleId).withOwnedIndexId(this.existingIndexId()).withName(this.nextName());
            case 6 -> ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)this.nextRelationshipSchema()).withId(ruleId).withName(this.nextName());
            case 7 -> ConstraintDescriptorFactory.keyForSchema((SchemaDescriptor)this.nextRelationshipSchema()).withId(ruleId).withOwnedIndexId(this.existingIndexId()).withName(this.nextName());
            case 8 -> ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.nextRelationshipSchema()).withId(ruleId).withName(this.nextName());
            case 9 -> ConstraintDescriptorFactory.uniqueForSchema((SchemaDescriptor)this.nextRelationshipSchema()).withId(ruleId).withOwnedIndexId(this.existingIndexId()).withName(this.nextName());
            case 10 -> ConstraintDescriptorFactory.typeForSchema((SchemaDescriptor)this.nextRelationshipSchema(), (PropertyTypeSet)this.randomAllowedTypes(), (boolean)this.rng.nextBoolean()).withId(ruleId).withName(this.nextName());
            case 11 -> ConstraintDescriptorFactory.typeForSchema((SchemaDescriptor)this.nextNodeSchema(), (PropertyTypeSet)this.randomAllowedTypes(), (boolean)this.rng.nextBoolean()).withId(ruleId).withName(this.nextName());
            case 12 -> ConstraintDescriptorFactory.relationshipEndpointLabelForRelType((int)this.nextRelationshipTypeId(), (int)this.nextLabelId(), (EndpointType)(this.rng.nextBoolean() ? EndpointType.START : EndpointType.END)).withId(ruleId).withName(this.nextName());
            case 13 -> ConstraintDescriptorFactory.nodeLabelExistenceForLabel((int)this.nextLabelId(), (int)this.nextLabelId()).withId(ruleId).withName(this.nextName());
            default -> throw new RuntimeException("Bad constraint choice: " + choice);
        };
    }

    private PropertyTypeSet randomAllowedTypes() {
        return PropertyTypeSet.of((SchemaValueType[])((SchemaValueType[])RandomValues.create((SplittableRandom)this.rng).selection((Object[])SchemaValueType.values(), 1, 5, false)));
    }

    public long nextRuleIdForConstraint() {
        return this.nextRuleId();
    }

    public long existingIndexId() {
        return this.nextRuleId();
    }

    public LabelSchemaDescriptor nextNodeSchema() {
        return SchemaDescriptors.forLabel((int)this.nextLabelId(), (int[])this.nextPropertyKeyIdsArray());
    }

    public RelationTypeSchemaDescriptor nextRelationshipSchema() {
        return SchemaDescriptors.forRelType((int)this.nextRelationshipTypeId(), (int[])this.nextPropertyKeyIdsArray());
    }

    public SchemaDescriptor nextNodeFulltextSchema() {
        return SchemaDescriptors.fulltext((EntityType)EntityType.NODE, (int[])this.nextLabelIdsArray(), (int[])this.nextPropertyKeyIdsArray());
    }

    public SchemaDescriptor nextRelationshipFulltextSchema() {
        return SchemaDescriptors.fulltext((EntityType)EntityType.RELATIONSHIP, (int[])this.nextRelationTypeIdsArray(), (int[])this.nextPropertyKeyIdsArray());
    }

    public int nextRuleId() {
        return this.rng.nextInt(Integer.MAX_VALUE);
    }

    public String nextName() {
        String name;
        while ((name = ((TextValue)this.values.nextValueOfTypes(this.textTypes)).stringValue().trim()).isEmpty() || name.isBlank() || name.contains("\u0000") || name.contains("`")) {
        }
        return name;
    }

    public int nextLabelId() {
        return this.rng.nextInt(this.maxLabelId);
    }

    public int nextRelationshipTypeId() {
        return this.rng.nextInt(this.maxRelTypeId);
    }

    public int[] nextLabelIdsArray() {
        return this.nextLabelIdsArray(this.defaultLabelIdsArrayMaxLength);
    }

    public int[] nextLabelIdsArray(int maxLength) {
        return this.rng.ints(this.rng.nextInt(1, maxLength), 1, this.maxLabelId).toArray();
    }

    public int[] nextRelationTypeIdsArray() {
        return this.nextRelationTypeIdsArray(this.defaultRelationshipTypeIdsArrayMaxLength);
    }

    public int[] nextRelationTypeIdsArray(int maxLength) {
        return this.rng.ints(this.rng.nextInt(1, maxLength), 1, this.maxRelTypeId).toArray();
    }

    public int[] nextPropertyKeyIdsArray() {
        return this.nextPropertyKeyIdsArray(this.defaultPropertyKeyIdsArrayMaxLength);
    }

    public int[] nextPropertyKeyIdsArray(int maxLength) {
        int propCount = this.rng.nextInt(1, maxLength + 1);
        return this.rng.ints(propCount, 1, this.maxPropKeyId).toArray();
    }

    public static boolean schemaDeepEquals(SchemaRule a, SchemaRule b) {
        if (!a.equals((Object)b)) {
            return false;
        }
        if (a.getId() != b.getId()) {
            return false;
        }
        if (!a.getName().equals(b.getName())) {
            return false;
        }
        if (a.getClass() != b.getClass()) {
            return false;
        }
        if (a instanceof IndexDescriptor) {
            IndexDescriptor indexA = (IndexDescriptor)a;
            if (b instanceof IndexDescriptor) {
                IndexDescriptor indexB = (IndexDescriptor)b;
                return indexA.getCapability().equals((Object)indexB.getCapability()) && indexA.isUnique() == indexB.isUnique() && indexA.getIndexProvider().equals((Object)indexB.getIndexProvider()) && indexA.getIndexType() == indexB.getIndexType() && indexA.getOwningConstraintId().equals(indexB.getOwningConstraintId()) && RandomSchemaBase.schemaDeepEquals(indexA.schema(), indexB.schema());
            }
        }
        if (a instanceof ConstraintDescriptor) {
            ConstraintDescriptor constraintA = (ConstraintDescriptor)a;
            if (b instanceof ConstraintDescriptor) {
                ConstraintDescriptor constraintB = (ConstraintDescriptor)b;
                if (constraintA.isIndexBackedConstraint() && constraintB.isIndexBackedConstraint()) {
                    IndexBackedConstraintDescriptor ibcA = constraintA.asIndexBackedConstraint();
                    IndexBackedConstraintDescriptor ibcB = constraintB.asIndexBackedConstraint();
                    return ibcA.hasOwnedIndexId() == ibcB.hasOwnedIndexId() && (!ibcA.hasOwnedIndexId() || ibcA.ownedIndexId() == ibcB.ownedIndexId()) && ibcA.equals((Object)ibcB) && RandomSchemaBase.schemaDeepEquals(ibcA.schema(), ibcB.schema());
                }
                return constraintA.isIndexBackedConstraint() == constraintB.isIndexBackedConstraint() && constraintA.equals((Object)constraintB) && RandomSchemaBase.schemaDeepEquals(constraintA.schema(), constraintB.schema());
            }
        }
        throw new IllegalArgumentException("Unsupported type of a:" + String.valueOf(a) + " and b:" + String.valueOf(b));
    }

    public static boolean schemaDeepEquals(SchemaDescriptor a, SchemaDescriptor b) {
        return a.entityType() == b.entityType() && a.schemaPatternMatchingType() == b.schemaPatternMatchingType() && Arrays.equals(a.getEntityTokenIds(), b.getEntityTokenIds()) && Arrays.equals(a.getPropertyIds(), b.getPropertyIds());
    }
}

