/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Objects;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.storageengine.api.StoreFileMetadata;
import org.neo4j.util.VisibleForTesting;

public final class StoreResource {
    private final Path path;
    private final String relativePath;
    private final FileSystemAbstraction fs;

    public StoreResource(StoreFileMetadata storeFileMetadata, DatabaseLayout dbLayout, FileSystemAbstraction fs) {
        this(storeFileMetadata.path(), StoreResource.relativeFilePath(storeFileMetadata, dbLayout), fs);
    }

    @VisibleForTesting
    public StoreResource(Path path, String relativePath, FileSystemAbstraction fs) {
        this.path = path;
        this.relativePath = relativePath;
        this.fs = fs;
    }

    private static String relativeFilePath(StoreFileMetadata storeFileMetadata, DatabaseLayout dbLayout) {
        return dbLayout.databaseDirectory().relativize(storeFileMetadata.path()).toString();
    }

    public StoreChannel open() throws IOException {
        return this.fs.read(this.path);
    }

    public String relativePath() {
        return this.relativePath;
    }

    public Path path() {
        return this.path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StoreResource that = (StoreResource)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.relativePath, that.relativePath);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.relativePath);
    }

    public String toString() {
        return "StoreResource{path='" + this.relativePath + "'}";
    }
}

