/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.procs;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.kernel.api.procs.DefaultParameterValue;
import org.neo4j.internal.kernel.api.procs.DescribedSignature;
import org.neo4j.internal.kernel.api.procs.FieldSignature;
import org.neo4j.internal.kernel.api.procs.Neo4jTypes;
import org.neo4j.internal.kernel.api.procs.QualifiedName;
import org.neo4j.kernel.api.QueryLanguage;

public final class UserFunctionSignature
implements DescribedSignature {
    private final QualifiedName name;
    private final List<FieldSignature> inputSignature;
    private final Neo4jTypes.AnyType type;
    private final boolean isDeprecated;
    private final String deprecated;
    private final String description;
    private final String category;
    private final boolean caseInsensitive;
    private final boolean isBuiltIn;
    private final boolean internal;
    private final boolean threadSafe;
    private final Set<QueryLanguage> supportedQueryLanguages;

    @Deprecated(forRemoval=true)
    public UserFunctionSignature(QualifiedName name, List<FieldSignature> inputSignature, Neo4jTypes.AnyType type, String deprecated, String description, String category, boolean caseInsensitive, boolean isBuiltIn, boolean internal, boolean threadSafe) {
        this(name, inputSignature, type, deprecated != null && !deprecated.isEmpty(), deprecated, description, category, caseInsensitive, isBuiltIn, internal, threadSafe, QueryLanguage.ALL);
    }

    @Deprecated(forRemoval=true)
    public UserFunctionSignature(QualifiedName name, List<FieldSignature> inputSignature, Neo4jTypes.AnyType type, boolean isDeprecated, String deprecatedBy, String description, String category, boolean caseInsensitive, boolean isBuiltIn, boolean internal, boolean threadSafe) {
        this(name, inputSignature, type, isDeprecated, deprecatedBy, description, category, caseInsensitive, isBuiltIn, internal, threadSafe, QueryLanguage.ALL);
    }

    public UserFunctionSignature(QualifiedName name, List<FieldSignature> inputSignature, Neo4jTypes.AnyType type, boolean isDeprecated, String deprecatedBy, String description, String category, boolean caseInsensitive, boolean isBuiltIn, boolean internal, boolean threadSafe, Set<QueryLanguage> supportedQueryLanguages) {
        this.name = name;
        this.inputSignature = Collections.unmodifiableList(inputSignature);
        this.type = type;
        this.isDeprecated = isDeprecated || deprecatedBy != null && !deprecatedBy.isEmpty();
        this.deprecated = deprecatedBy;
        this.description = description;
        this.category = category;
        this.caseInsensitive = caseInsensitive;
        this.isBuiltIn = isBuiltIn;
        this.internal = internal;
        this.threadSafe = threadSafe;
        this.supportedQueryLanguages = supportedQueryLanguages;
    }

    @Override
    public QualifiedName name() {
        return this.name;
    }

    public boolean isDeprecated() {
        return this.isDeprecated;
    }

    public Optional<String> deprecated() {
        return Optional.ofNullable(this.deprecated);
    }

    public List<FieldSignature> inputSignature() {
        return this.inputSignature;
    }

    public Neo4jTypes.AnyType outputType() {
        return this.type;
    }

    @Override
    public Optional<String> description() {
        return Optional.ofNullable(this.description);
    }

    public Optional<String> category() {
        return Optional.ofNullable(this.category);
    }

    public boolean caseInsensitive() {
        return this.caseInsensitive;
    }

    public boolean isBuiltIn() {
        return this.isBuiltIn;
    }

    public boolean internal() {
        return this.internal;
    }

    public boolean threadSafe() {
        return this.threadSafe;
    }

    public Set<QueryLanguage> supportedQueryLanguages() {
        return this.supportedQueryLanguages;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserFunctionSignature that = (UserFunctionSignature)o;
        return this.name.equals(that.name) && this.inputSignature.equals(that.inputSignature) && this.type.equals(that.type);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String toString() {
        String strInSig = this.inputSignature == null ? "..." : Iterables.toString(this.inputSignature, (String)", ");
        String strOutSig = this.type == null ? "..." : this.type.toString();
        return String.format("%s(%s) :: %s", this.name, strInSig, strOutSig);
    }

    public static Builder functionSignature(QualifiedName name) {
        return new Builder(name);
    }

    public static class Builder {
        private final QualifiedName name;
        private final List<FieldSignature> inputSignature = new LinkedList<FieldSignature>();
        private Neo4jTypes.AnyType outputType;
        private boolean isDeprecated = false;
        private String deprecated;
        private String description;
        private String category;
        private boolean threadSafe;
        private Set<QueryLanguage> supportedQueryLanguages = QueryLanguage.ALL;

        public Builder(QualifiedName name) {
            this.name = name;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder category(boolean isDeprecated) {
            this.isDeprecated = isDeprecated;
            return this;
        }

        public Builder deprecated(String deprecated) {
            this.isDeprecated = deprecated != null && !deprecated.isEmpty();
            this.deprecated = deprecated;
            return this;
        }

        public Builder deprecatedBy(String deprecated) {
            this.deprecated = deprecated;
            return this;
        }

        public Builder in(String name, Neo4jTypes.AnyType type) {
            this.inputSignature.add(FieldSignature.inputField(name, type));
            return this;
        }

        public Builder in(String name, Neo4jTypes.AnyType type, DefaultParameterValue defaultValue) {
            this.inputSignature.add(FieldSignature.inputField(name, type, defaultValue));
            return this;
        }

        public Builder out(Neo4jTypes.AnyType type) {
            this.outputType = type;
            return this;
        }

        public Builder threadSafe() {
            this.threadSafe = true;
            return this;
        }

        public Builder supportedQueryLanguages(QueryLanguage ... versions) {
            this.supportedQueryLanguages = EnumSet.copyOf(Arrays.asList(versions));
            return this;
        }

        public UserFunctionSignature build() {
            if (this.outputType == null) {
                throw new IllegalStateException("output type must be set");
            }
            return new UserFunctionSignature(this.name, this.inputSignature, this.outputType, this.isDeprecated || this.deprecated != null && !this.deprecated.isEmpty(), this.deprecated, this.description, this.category, false, false, false, this.threadSafe, this.supportedQueryLanguages);
        }
    }
}

