/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import org.neo4j.io.pagecache.context.TransactionIdSnapshot;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.AppendBatchInfo;
import org.neo4j.kernel.impl.transaction.log.LogPosition;
import org.neo4j.storageengine.api.ClosedTransactionMetadata;
import org.neo4j.storageengine.api.TransactionId;

public interface TransactionIdStore {
    public static final long BASE_TX_ID = 1L;
    public static final int BASE_TX_CHECKSUM = -559063315;
    public static final long BASE_TX_COMMIT_TIMESTAMP = 0L;
    public static final int BASE_CHUNK_NUMBER = 1;
    public static final int UNKNOWN_TX_CHECKSUM = 1;
    public static final long UNKNOWN_TX_COMMIT_TIMESTAMP = 1L;
    public static final long UNKNOWN_CONSENSUS_INDEX = -1L;
    public static final long UNKNOWN_TX_ID = 0L;
    public static final TransactionId UNKNOWN_TRANSACTION_ID = new TransactionId(0L, 0L, KernelVersion.EARLIEST, 1, 1L, -1L);
    public static final TransactionId BASE_TRANSACTION_ID = TransactionIdStore.emptyVersionedTransaction(KernelVersion.EARLIEST);

    public static TransactionId emptyVersionedTransaction(KernelVersion version) {
        return new TransactionId(1L, 1L, version, -559063315, 0L, -1L);
    }

    public long nextCommittingTransactionId();

    public long committingTransactionId();

    public void transactionCommitted(long var1, long var3, KernelVersion var5, int var6, long var7, long var9);

    public long getLastCommittedTransactionId();

    public TransactionId getLastCommittedTransaction();

    public long getLastClosedTransactionId();

    public TransactionIdSnapshot getClosedTransactionSnapshot();

    public ClosedTransactionMetadata getLastClosedTransaction();

    public void setLastCommittedAndClosedTransactionId(long var1, long var3, KernelVersion var5, int var6, long var7, long var9, long var11, long var13, long var15);

    public void transactionClosed(long var1, long var3, KernelVersion var5, long var6, long var8, int var10, long var11, long var13);

    public void resetLastClosedTransaction(long var1, long var3, KernelVersion var5, long var6, long var8, int var10, long var11, long var13);

    public void appendBatch(long var1, LogPosition var3);

    public AppendBatchInfo lastBatch();
}

