/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.enrichment;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import org.neo4j.internal.kernel.api.connectioninfo.ClientConnectionInfo;
import org.neo4j.internal.kernel.api.security.AuthSubject;
import org.neo4j.internal.kernel.api.security.AuthenticationResult;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.storageengine.api.enrichment.CaptureMode;
import org.neo4j.string.Mask;

public record TxMetadata(CaptureMode captureMode, String serverId, AuthSubject subject, ClientConnectionInfo connectionInfo, long lastCommittedTx) implements Mask.Maskable
{
    public TxMetadata(CaptureMode captureMode, String serverId, AuthSubject subject, ClientConnectionInfo connectionInfo, long lastCommittedTx) {
        this.captureMode = Objects.requireNonNull(captureMode, "captureMode must not be null");
        this.serverId = Objects.requireNonNull(serverId, "serverId must not be null");
        this.subject = Objects.requireNonNull(subject, "subject must not be null");
        this.connectionInfo = Objects.requireNonNull(connectionInfo, "connectionInfo must not be null");
        this.lastCommittedTx = lastCommittedTx;
    }

    public static TxMetadata create(CaptureMode captureMode, String serverId, SecurityContext securityContext, long lastCommittedTx) {
        return new TxMetadata(captureMode, serverId, securityContext.subject(), securityContext.connectionInfo(), lastCommittedTx);
    }

    public static TxMetadata deserialize(ReadableChannel channel) throws IOException {
        long lastCommittedTx = channel.getLong();
        CaptureMode captureMode = TxMetadata.readEnum(channel.get());
        String serverId = TxMetadata.readString(channel);
        AuthSubject subject = TxMetadata.readSubject(channel);
        ClientConnectionInfo connectionInfo = TxMetadata.readConnectionInfo(channel);
        return new TxMetadata(captureMode, serverId, subject, connectionInfo, lastCommittedTx);
    }

    public void serialize(WritableChannel channel) throws IOException {
        channel.putLong(this.lastCommittedTx);
        channel.put(this.captureMode.id());
        TxMetadata.serialize(channel, this.serverId);
        TxMetadata.serialize(channel, this.subject.authenticatedUser());
        TxMetadata.serialize(channel, this.subject.executingUser());
        TxMetadata.serialize(channel, this.connectionInfo.asConnectionDetails());
        TxMetadata.serialize(channel, this.connectionInfo.protocol());
        TxMetadata.serialize(channel, this.connectionInfo.connectionId());
        TxMetadata.serialize(channel, this.connectionInfo.clientAddress());
        TxMetadata.serialize(channel, this.connectionInfo.requestURI());
    }

    private static CaptureMode readEnum(byte flag) {
        return (CaptureMode)((Object)CaptureMode.BY_ID.get(flag));
    }

    private static AuthSubject readSubject(ReadableChannel channel) throws IOException {
        final String authenticatedUser = TxMetadata.readString(channel);
        final String executingUser = Objects.requireNonNull(TxMetadata.readString(channel));
        return new AuthSubject(){

            @Override
            public AuthenticationResult getAuthenticationResult() {
                return AuthenticationResult.SUCCESS;
            }

            @Override
            public boolean hasUsername(String username) {
                return executingUser.equals(username);
            }

            @Override
            public String executingUser() {
                return executingUser;
            }

            @Override
            public String authenticatedUser() {
                return authenticatedUser == null ? executingUser : authenticatedUser;
            }
        };
    }

    private static ClientConnectionInfo readConnectionInfo(ReadableChannel channel) throws IOException {
        final String details = TxMetadata.readString(channel);
        final String protocol = TxMetadata.readString(channel);
        final String connectionId = TxMetadata.readString(channel);
        final String clientAddress = TxMetadata.readString(channel);
        final String requestUri = TxMetadata.readString(channel);
        return new ClientConnectionInfo(){

            @Override
            public String asConnectionDetails() {
                return details;
            }

            @Override
            public String protocol() {
                return protocol;
            }

            @Override
            public String connectionId() {
                return connectionId;
            }

            @Override
            public String clientAddress() {
                return clientAddress;
            }

            @Override
            public String requestURI() {
                return requestUri;
            }
        };
    }

    private static String readString(ReadableChannel channel) throws IOException {
        int length = channel.getInt();
        if (length < 0) {
            return null;
        }
        byte[] bytes = new byte[length];
        channel.get(bytes, bytes.length);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static void serialize(WritableChannel channel, String data) throws IOException {
        if (data == null) {
            channel.putInt(-1);
        } else {
            byte[] bytes = data.getBytes(StandardCharsets.UTF_8);
            channel.putInt(bytes.length).put(bytes, bytes.length);
        }
    }

    public String toString(Mask mask) {
        return "TxMetadata(%s, %s, %s, %s, %d)".formatted(mask.filter((Object)this.captureMode), mask.filter((Object)this.serverId), mask.filter((Object)this.subject), mask.filter((Object)this.connectionInfo), this.lastCommittedTx);
    }
}

