/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.enrichment;

import java.io.IOException;
import java.util.function.Supplier;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.BaseCommandReader;
import org.neo4j.storageengine.api.CommandReader;
import org.neo4j.storageengine.api.CommandReaderFactory;
import org.neo4j.storageengine.api.StorageCommand;
import org.neo4j.storageengine.api.enrichment.Enrichment;
import org.neo4j.storageengine.api.enrichment.EnrichmentCommandFactory;

public class EnrichmentCommandReaderFactory
implements CommandReaderFactory {
    private final CommandReaderFactory commandReaderFactory;
    private final EnrichmentCommandFactory enrichmentCommandFactory;
    private final Supplier<MemoryTracker> memoryTracker;

    public EnrichmentCommandReaderFactory(CommandReaderFactory commandReaderFactory, EnrichmentCommandFactory enrichmentCommandFactory, Supplier<MemoryTracker> memoryTracker) {
        this.commandReaderFactory = commandReaderFactory;
        this.enrichmentCommandFactory = enrichmentCommandFactory;
        this.memoryTracker = memoryTracker;
    }

    @Override
    public final CommandReader get(final KernelVersion version) {
        CommandReader reader = this.commandReaderFactory.get(version);
        if (reader instanceof BaseCommandReader) {
            final BaseCommandReader baseReader = (BaseCommandReader)reader;
            return new BaseCommandReader(){

                @Override
                public StorageCommand read(byte commandType, ReadableChannel channel) throws IOException {
                    if (30 == commandType) {
                        Enrichment.Read enrichment = Enrichment.Read.deserialize(channel, EnrichmentCommandReaderFactory.this.memoryTracker.get());
                        return EnrichmentCommandReaderFactory.this.enrichmentCommandFactory.create(version, enrichment);
                    }
                    return baseReader.read(commandType, channel);
                }

                @Override
                public KernelVersion kernelVersion() {
                    return baseReader.kernelVersion();
                }
            };
        }
        return reader;
    }
}

