/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import org.neo4j.internal.helpers.NameUtil;
import org.neo4j.internal.kernel.api.security.Segment;

public class LabelSegment
implements Segment {
    private final String label;
    public static final LabelSegment ALL = new LabelSegment(null);

    public LabelSegment(String label) {
        this.label = label;
    }

    public String getLabel() {
        return this.label;
    }

    public int hashCode() {
        return this.label.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LabelSegment) {
            LabelSegment other = (LabelSegment)obj;
            if (this.label == null) {
                return other.label == null;
            }
            return this.label.equals(other.getLabel());
        }
        return false;
    }

    @Override
    public String toCypherSnippet() {
        if (this.label == null) {
            return "NODE *";
        }
        return String.format("NODE %s", NameUtil.escapeName((String)this.label));
    }

    public String toString() {
        return String.format("NODE %s", this.label == null ? "*" : this.label);
    }

    @Override
    public boolean satisfies(Segment segment) {
        if (segment instanceof LabelSegment) {
            LabelSegment other = (LabelSegment)segment;
            return this.label == null || this.label.equals(other.label);
        }
        return false;
    }
}

