/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.Closeable;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntriesReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.api.index.TokenIndexReader;
import org.neo4j.kernel.api.index.ValueIndexReader;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.SwallowingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.index.schema.EntityTokenRange;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;

public interface IndexAccessor
extends Closeable,
ConsistencyCheckable,
MinimalIndexAccessor {
    public static final long UNKNOWN_NUMBER_OF_ENTRIES = -1L;
    public static final IndexAccessor EMPTY = new Adapter();

    public IndexUpdater newUpdater(IndexUpdateMode var1, CursorContext var2);

    public void force(CursorContext var1);

    public void refresh();

    @Override
    public void close();

    public ValueIndexReader newValueReader();

    default public TokenIndexReader newTokenReader() {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    default public BoundedIterable<Long> newAllEntriesValueReader(CursorContext cursorContext) {
        return this.newAllEntriesValueReader(0L, Long.MAX_VALUE, cursorContext);
    }

    public BoundedIterable<Long> newAllEntriesValueReader(long var1, long var3, CursorContext var5);

    default public BoundedIterable<EntityTokenRange> newAllEntriesTokenReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
        throw new UnsupportedOperationException("Not supported for " + this.getClass().getSimpleName());
    }

    default public IndexEntriesReader[] newAllEntriesValueReader(int partitions, CursorContext cursorContext) {
        final BoundedIterable<Long> entriesReader = this.newAllEntriesValueReader(cursorContext);
        final Iterator ids = entriesReader.iterator();
        IndexEntriesReader reader = new IndexEntriesReader(){

            @Override
            public Value[] values() {
                return null;
            }

            public long next() {
                return (Long)ids.next();
            }

            public boolean hasNext() {
                return ids.hasNext();
            }

            @Override
            public void close() {
                IOUtils.closeAllUnchecked((AutoCloseable[])new BoundedIterable[]{entriesReader});
            }
        };
        return new IndexEntriesReader[]{reader};
    }

    public ResourceIterator<Path> snapshotFiles();

    public void verifyDeferredConstraints(NodePropertyAccessor var1) throws IndexEntryConflictException;

    default public void validateBeforeCommit(long entityId, Value[] tuple) {
    }

    public long estimateNumberOfEntries(CursorContext var1);

    public static class Delegating
    implements IndexAccessor {
        private final IndexAccessor delegate;

        public Delegating(IndexAccessor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void drop() {
            this.delegate.drop();
        }

        @Override
        public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext) {
            return this.delegate.newUpdater(mode, cursorContext);
        }

        @Override
        public void force(CursorContext cursorContext) {
            this.delegate.force(cursorContext);
        }

        @Override
        public void refresh() {
            this.delegate.refresh();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public ValueIndexReader newValueReader() {
            return this.delegate.newValueReader();
        }

        @Override
        public BoundedIterable<Long> newAllEntriesValueReader(CursorContext cursorContext) {
            return this.delegate.newAllEntriesValueReader(cursorContext);
        }

        @Override
        public BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
            return this.delegate.newAllEntriesValueReader(fromIdInclusive, toIdExclusive, cursorContext);
        }

        @Override
        public ResourceIterator<Path> snapshotFiles() {
            return this.delegate.snapshotFiles();
        }

        @Override
        public Map<String, Value> indexConfig() {
            return this.delegate.indexConfig();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
            this.delegate.verifyDeferredConstraints(nodePropertyAccessor);
        }

        @Override
        public void validateBeforeCommit(long entityId, Value[] tuple) {
            this.delegate.validateBeforeCommit(entityId, tuple);
        }

        public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContext cursorContext) {
            return this.delegate.consistencyCheck(reporterFactory, cursorContext);
        }

        @Override
        public long estimateNumberOfEntries(CursorContext cursorContext) {
            return this.delegate.estimateNumberOfEntries(cursorContext);
        }
    }

    public static class Adapter
    implements IndexAccessor {
        @Override
        public void drop() {
        }

        @Override
        public IndexUpdater newUpdater(IndexUpdateMode mode, CursorContext cursorContext) {
            return SwallowingIndexUpdater.INSTANCE;
        }

        @Override
        public void force(CursorContext cursorContext) {
        }

        @Override
        public void refresh() {
        }

        @Override
        public void close() {
        }

        @Override
        public ValueIndexReader newValueReader() {
            return ValueIndexReader.EMPTY;
        }

        @Override
        public BoundedIterable<Long> newAllEntriesValueReader(long fromIdInclusive, long toIdExclusive, CursorContext cursorContext) {
            return new BoundedIterable<Long>(){

                public long maxCount() {
                    return 0L;
                }

                public void close() {
                }

                public Iterator<Long> iterator() {
                    return Collections.emptyIterator();
                }
            };
        }

        @Override
        public ResourceIterator<Path> snapshotFiles() {
            return Iterators.emptyResourceIterator();
        }

        @Override
        public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) {
        }

        public boolean consistencyCheck(ReporterFactory reporterFactory, CursorContext cursorContext) {
            return true;
        }

        @Override
        public long estimateNumberOfEntries(CursorContext cursorContext) {
            return -1L;
        }
    }
}

