/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.neo4j.graphdb.security.AuthorizationViolationException;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.AccessMode;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.SecurityContext;
import org.neo4j.kernel.api.exceptions.Status;

public class SecurityAuthorizationHandler {
    AbstractSecurityLog securityLog;

    public SecurityAuthorizationHandler(AbstractSecurityLog securityLog) {
        this.securityLog = securityLog;
    }

    public void assertAllowsCreateNode(SecurityContext securityContext, Function<Integer, String> resolver, int[] labelIds) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsCreateNode(labelIds)) {
            String labels = null == labelIds ? "" : Arrays.stream(labelIds).mapToObj(resolver::apply).collect(Collectors.joining(","));
            throw this.logAndGetAuthorizationException(securityContext, String.format("Create node with labels '%s' on database '%s' is not allowed for %s.", labels, securityContext.database(), securityContext.description()));
        }
    }

    public void assertAllowsDeleteNode(SecurityContext securityContext, Function<Integer, String> resolver, Supplier<TokenSet> labelSupplier) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsDeleteNode(labelSupplier)) {
            String labels = Arrays.stream(labelSupplier.get().all()).mapToObj(id -> (String)resolver.apply((int)id)).collect(Collectors.joining(","));
            throw this.logAndGetAuthorizationException(securityContext, String.format("Delete node with labels '%s' on database '%s' is not allowed for %s.", labels, securityContext.database(), securityContext.description()));
        }
    }

    public void assertAllowsCreateRelationship(SecurityContext securityContext, Function<Integer, String> resolver, int relType) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsCreateRelationship(relType)) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Create relationship with type '%s' on database '%s' is not allowed for %s.", resolver.apply(relType), securityContext.database(), securityContext.description()));
        }
    }

    public void assertAllowsDeleteRelationship(SecurityContext securityContext, Function<Integer, String> resolver, int relType) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsDeleteRelationship(relType)) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Delete relationship with type '%s' on database '%s' is not allowed for %s.", resolver.apply(relType), securityContext.database(), securityContext.description()));
        }
    }

    public void assertAllowsSetLabel(SecurityContext securityContext, Function<Integer, String> resolver, long labelId) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsSetLabel(labelId)) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Set label for label '%s' on database '%s' is not allowed for %s.", resolver.apply((int)labelId), securityContext.database(), securityContext.description()));
        }
    }

    public void assertAllowsRemoveLabel(SecurityContext securityContext, Function<Integer, String> resolver, long labelId) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsRemoveLabel(labelId)) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Remove label for label '%s' on database '%s' is not allowed for %s.", resolver.apply((int)labelId), securityContext.database(), securityContext.description()));
        }
    }

    public void assertAllowsSetProperty(SecurityContext securityContext, Function<Long, String> resolver, TokenSet labelIds, long propertyKey) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsSetProperty(() -> labelIds, (int)propertyKey)) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Set property for property '%s' on database '%s' is not allowed for %s.", resolver.apply(propertyKey), securityContext.database(), securityContext.description()));
        }
    }

    public void assertAllowsSetProperty(SecurityContext securityContext, Function<Long, String> resolver, long relType, long propertyKey) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsSetProperty(() -> (int)relType, (int)propertyKey)) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Set property for property '%s' on database '%s' is not allowed for %s.", resolver.apply(propertyKey), securityContext.database(), securityContext.description()));
        }
    }

    public void assertAllowsSchemaWrites(SecurityContext securityContext) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsSchemaWrites()) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Schema operations on database '%s' are not allowed for %s.", securityContext.database(), securityContext.description()));
        }
    }

    public void assertSchemaWrites(SecurityContext securityContext, PrivilegeAction action) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsSchemaWrites(action)) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Schema operation '%s' on database '%s' is not allowed for %s.", new Object[]{action, securityContext.database(), securityContext.description()}));
        }
    }

    public void assertShowIndexAllowed(SecurityContext securityContext) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsShowIndex()) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Show indexes on database '%s' is not allowed for %s.", securityContext.database(), securityContext.description()));
        }
    }

    public void assertShowConstraintAllowed(SecurityContext securityContext) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsShowConstraint()) {
            throw this.logAndGetAuthorizationException(securityContext, String.format("Show constraints on database '%s' is not allowed for %s.", securityContext.database(), securityContext.description()));
        }
    }

    public final void assertAllowsTokenCreates(SecurityContext securityContext, PrivilegeAction action) {
        AccessMode accessMode = securityContext.mode();
        if (!accessMode.allowsTokenCreates(action)) {
            switch (action) {
                case CREATE_LABEL: {
                    throw this.logAndGetAuthorizationException(securityContext, String.format("Creating new node label on database '%s' is not allowed for %s. See GRANT CREATE NEW NODE LABEL ON DATABASE `%s`...", securityContext.database(), securityContext.description(), securityContext.database()));
                }
                case CREATE_PROPERTYKEY: {
                    throw this.logAndGetAuthorizationException(securityContext, String.format("Creating new property name on database '%s' is not allowed for %s. See GRANT CREATE NEW PROPERTY NAME ON DATABASE `%s`...", securityContext.database(), securityContext.description(), securityContext.database()));
                }
                case CREATE_RELTYPE: {
                    throw this.logAndGetAuthorizationException(securityContext, String.format("Creating new relationship type on database '%s' is not allowed for %s. See GRANT CREATE NEW RELATIONSHIP TYPE ON DATABASE `%s`...", securityContext.database(), securityContext.description(), securityContext.database()));
                }
            }
            throw this.logAndGetAuthorizationException(securityContext, String.format("'%s' operations on database '%s' are not allowed for %s.", new Object[]{action, securityContext.database(), securityContext.description()}));
        }
    }

    public AuthorizationViolationException logAndGetAuthorizationException(SecurityContext securityContext, String message) {
        this.securityLog.error(securityContext, message);
        return new AuthorizationViolationException(message);
    }

    public AuthorizationViolationException logAndGetAuthorizationException(SecurityContext securityContext, String message, Status status) {
        this.securityLog.error(securityContext, message);
        return new AuthorizationViolationException(message, status);
    }

    public static String generateCredentialsExpiredMessage(String message) {
        return String.format("%s%n%nThe credentials you provided were valid, but must be changed before you can use this instance. If this is the first time you are using Neo4j, this is to ensure you are not using the default credentials in production. If you are not using default credentials, you are getting this message because an administrator requires a password change.%nChanging your password is easy to do via the Neo4j Browser.%nIf you are connecting via a shell or programmatically via a driver, just issue a `ALTER CURRENT USER SET PASSWORD FROM 'current password' TO 'new password'` statement against the system database in the current session, and then restart your driver with the new password configured.", message);
    }
}

