/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.api.index;

import java.io.Closeable;
import java.io.File;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.io.IOUtils;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.kernel.api.exceptions.index.IndexEntryConflictException;
import org.neo4j.kernel.api.index.IndexEntriesReader;
import org.neo4j.kernel.api.index.IndexReader;
import org.neo4j.kernel.api.index.IndexUpdater;
import org.neo4j.kernel.api.index.MinimalIndexAccessor;
import org.neo4j.kernel.impl.api.index.IndexUpdateMode;
import org.neo4j.kernel.impl.api.index.SwallowingIndexUpdater;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.storageengine.api.NodePropertyAccessor;
import org.neo4j.values.storable.Value;

public interface IndexAccessor
extends Closeable,
ConsistencyCheckable,
MinimalIndexAccessor {
    public static final long UNKNOWN_NUMBER_OF_ENTRIES = -1L;
    public static final IndexAccessor EMPTY = new Adapter();

    public IndexUpdater newUpdater(IndexUpdateMode var1, PageCursorTracer var2);

    public void force(IOLimiter var1, PageCursorTracer var2);

    public void refresh();

    @Override
    public void close();

    public IndexReader newReader();

    default public BoundedIterable<Long> newAllEntriesReader(PageCursorTracer cursorTracer) {
        return this.newAllEntriesReader(0L, Long.MAX_VALUE, cursorTracer);
    }

    public BoundedIterable<Long> newAllEntriesReader(long var1, long var3, PageCursorTracer var5);

    default public IndexEntriesReader[] newAllIndexEntriesReader(int partitions, PageCursorTracer cursorTracer) {
        final BoundedIterable<Long> entriesReader = this.newAllEntriesReader(cursorTracer);
        final Iterator ids = entriesReader.iterator();
        IndexEntriesReader reader = new IndexEntriesReader(){

            @Override
            public Value[] values() {
                return null;
            }

            public long next() {
                return (Long)ids.next();
            }

            public boolean hasNext() {
                return ids.hasNext();
            }

            @Override
            public void close() {
                IOUtils.closeAllUnchecked((AutoCloseable[])new BoundedIterable[]{entriesReader});
            }
        };
        return new IndexEntriesReader[]{reader};
    }

    public ResourceIterator<File> snapshotFiles();

    public void verifyDeferredConstraints(NodePropertyAccessor var1) throws IndexEntryConflictException;

    default public void validateBeforeCommit(Value[] tuple) {
    }

    public long estimateNumberOfEntries(PageCursorTracer var1);

    public static class Delegating
    implements IndexAccessor {
        private final IndexAccessor delegate;

        public Delegating(IndexAccessor delegate) {
            this.delegate = delegate;
        }

        @Override
        public void drop() {
            this.delegate.drop();
        }

        @Override
        public IndexUpdater newUpdater(IndexUpdateMode mode, PageCursorTracer cursorTracer) {
            return this.delegate.newUpdater(mode, cursorTracer);
        }

        @Override
        public void force(IOLimiter ioLimiter, PageCursorTracer cursorTracer) {
            this.delegate.force(ioLimiter, cursorTracer);
        }

        @Override
        public void refresh() {
            this.delegate.refresh();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public IndexReader newReader() {
            return this.delegate.newReader();
        }

        @Override
        public BoundedIterable<Long> newAllEntriesReader(PageCursorTracer cursorTracer) {
            return this.delegate.newAllEntriesReader(cursorTracer);
        }

        @Override
        public BoundedIterable<Long> newAllEntriesReader(long fromIdInclusive, long toIdExclusive, PageCursorTracer cursorTracer) {
            return this.delegate.newAllEntriesReader(fromIdInclusive, toIdExclusive, cursorTracer);
        }

        @Override
        public ResourceIterator<File> snapshotFiles() {
            return this.delegate.snapshotFiles();
        }

        @Override
        public Map<String, Value> indexConfig() {
            return this.delegate.indexConfig();
        }

        public String toString() {
            return this.delegate.toString();
        }

        @Override
        public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) throws IndexEntryConflictException {
            this.delegate.verifyDeferredConstraints(nodePropertyAccessor);
        }

        @Override
        public void validateBeforeCommit(Value[] tuple) {
            this.delegate.validateBeforeCommit(tuple);
        }

        public boolean consistencyCheck(ReporterFactory reporterFactory, PageCursorTracer cursorTracer) {
            return this.delegate.consistencyCheck(reporterFactory, cursorTracer);
        }

        @Override
        public long estimateNumberOfEntries(PageCursorTracer cursorTracer) {
            return this.delegate.estimateNumberOfEntries(cursorTracer);
        }
    }

    public static class Adapter
    implements IndexAccessor {
        @Override
        public void drop() {
        }

        @Override
        public IndexUpdater newUpdater(IndexUpdateMode mode, PageCursorTracer cursorTracer) {
            return SwallowingIndexUpdater.INSTANCE;
        }

        @Override
        public void force(IOLimiter ioLimiter, PageCursorTracer cursorTracer) {
        }

        @Override
        public void refresh() {
        }

        @Override
        public void close() {
        }

        @Override
        public IndexReader newReader() {
            return IndexReader.EMPTY;
        }

        @Override
        public BoundedIterable<Long> newAllEntriesReader(long fromIdInclusive, long toIdExclusive, PageCursorTracer cursorTracer) {
            return new BoundedIterable<Long>(){

                public long maxCount() {
                    return 0L;
                }

                public void close() {
                }

                public Iterator<Long> iterator() {
                    return Collections.emptyIterator();
                }
            };
        }

        @Override
        public ResourceIterator<File> snapshotFiles() {
            return Iterators.emptyResourceIterator();
        }

        @Override
        public void verifyDeferredConstraints(NodePropertyAccessor nodePropertyAccessor) {
        }

        public boolean consistencyCheck(ReporterFactory reporterFactory, PageCursorTracer cursorTracer) {
            return true;
        }

        @Override
        public long estimateNumberOfEntries(PageCursorTracer cursorTracer) {
            return -1L;
        }
    }
}

