/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.util.Locale;

public enum PrivilegeAction {
    ACCESS,
    TRAVERSE,
    READ,
    SET_LABEL,
    REMOVE_LABEL,
    CREATE_ELEMENT,
    DELETE_ELEMENT,
    SET_PROPERTY,
    EXECUTE,
    CREATE_LABEL,
    CREATE_RELTYPE,
    CREATE_PROPERTYKEY,
    CREATE_INDEX,
    DROP_INDEX,
    CREATE_CONSTRAINT,
    DROP_CONSTRAINT,
    START_DATABASE,
    STOP_DATABASE,
    SHOW_TRANSACTION,
    TERMINATE_TRANSACTION,
    SHOW_CONNECTION,
    TERMINATE_CONNECTION,
    CREATE_DATABASE,
    DROP_DATABASE,
    SHOW_USER,
    CREATE_USER,
    SET_USER_STATUS,
    SET_PASSWORDS,
    DROP_USER,
    SHOW_ROLE,
    CREATE_ROLE,
    DROP_ROLE,
    ASSIGN_ROLE,
    REMOVE_ROLE,
    SHOW_PRIVILEGE,
    ASSIGN_PRIVILEGE,
    REMOVE_PRIVILEGE,
    ADMIN{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return DBMS_ACTIONS.satisfies(action) || TRANSACTION_MANAGEMENT.satisfies(action) || START_DATABASE.satisfies(action) || STOP_DATABASE.satisfies(action) || this == action;
        }
    }
    ,
    TOKEN{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case CREATE_LABEL: 
                case CREATE_RELTYPE: 
                case CREATE_PROPERTYKEY: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    CONSTRAINT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case CREATE_CONSTRAINT: 
                case DROP_CONSTRAINT: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    INDEX{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case CREATE_INDEX: 
                case DROP_INDEX: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    DATABASE_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case CREATE_DATABASE: 
                case DROP_DATABASE: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    TRANSACTION_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case SHOW_TRANSACTION: 
                case TERMINATE_TRANSACTION: 
                case SHOW_CONNECTION: 
                case TERMINATE_CONNECTION: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    USER_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case SHOW_USER: 
                case CREATE_USER: 
                case DROP_USER: {
                    return true;
                }
            }
            return ALTER_USER.satisfies(action) || this == action;
        }
    }
    ,
    ALTER_USER{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case SET_USER_STATUS: 
                case SET_PASSWORDS: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    ROLE_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case SHOW_ROLE: 
                case CREATE_ROLE: 
                case DROP_ROLE: 
                case ASSIGN_ROLE: 
                case REMOVE_ROLE: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    PRIVILEGE_MANAGEMENT{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case SHOW_PRIVILEGE: 
                case ASSIGN_PRIVILEGE: 
                case REMOVE_PRIVILEGE: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    MATCH{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case READ: 
                case TRAVERSE: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    WRITE{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case SET_LABEL: 
                case REMOVE_LABEL: 
                case CREATE_ELEMENT: 
                case DELETE_ELEMENT: 
                case SET_PROPERTY: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    MERGE{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case READ: 
                case TRAVERSE: 
                case CREATE_ELEMENT: 
                case SET_PROPERTY: 
                case MATCH: {
                    return true;
                }
            }
            return this == action;
        }
    }
    ,
    GRAPH_ACTIONS{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            switch (action) {
                case READ: 
                case TRAVERSE: 
                case MATCH: {
                    return true;
                }
            }
            return WRITE.satisfies(action) || this == action;
        }
    }
    ,
    DATABASE_ACTIONS{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return action == ACCESS || INDEX.satisfies(action) || CONSTRAINT.satisfies(action) || TOKEN.satisfies(action) || this == action;
        }
    }
    ,
    DBMS_ACTIONS{

        @Override
        public boolean satisfies(PrivilegeAction action) {
            return ROLE_MANAGEMENT.satisfies(action) || USER_MANAGEMENT.satisfies(action) || DATABASE_MANAGEMENT.satisfies(action) || PRIVILEGE_MANAGEMENT.satisfies(action) || this == action;
        }
    };


    public boolean satisfies(PrivilegeAction action) {
        return this == action;
    }

    public String toString() {
        return super.toString().toLowerCase(Locale.ROOT);
    }

    public static PrivilegeAction from(String name) {
        try {
            return PrivilegeAction.valueOf(name.toUpperCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }
}

