/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.helpers;

import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.internal.kernel.api.RelationshipGroupCursor;
import org.neo4j.internal.kernel.api.RelationshipTraversalCursor;

abstract class RelationshipDenseSelection {
    private RelationshipGroupCursor groupCursor;
    protected RelationshipTraversalCursor relationshipCursor;
    private int[] types;
    private Dir[] directions = new Dir[3];
    private int currentDirection;
    private int nDirections;
    private boolean onRelationship;
    private boolean onGroup;
    private int foundTypes;

    RelationshipDenseSelection() {
    }

    public void outgoing(RelationshipGroupCursor groupCursor, RelationshipTraversalCursor relationshipCursor) {
        this.outgoing(groupCursor, relationshipCursor, null);
    }

    public void outgoing(RelationshipGroupCursor groupCursor, RelationshipTraversalCursor relationshipCursor, int[] types) {
        this.groupCursor = groupCursor;
        this.relationshipCursor = relationshipCursor;
        this.types = types;
        this.directions[0] = Dir.OUT;
        this.directions[1] = Dir.LOOP;
        this.nDirections = 2;
        this.currentDirection = this.directions.length;
        this.onRelationship = false;
        this.onGroup = false;
        this.foundTypes = 0;
    }

    public void incoming(RelationshipGroupCursor groupCursor, RelationshipTraversalCursor relationshipCursor) {
        this.incoming(groupCursor, relationshipCursor, null);
    }

    public void incoming(RelationshipGroupCursor groupCursor, RelationshipTraversalCursor relationshipCursor, int[] types) {
        this.groupCursor = groupCursor;
        this.relationshipCursor = relationshipCursor;
        this.types = types;
        this.directions[0] = Dir.IN;
        this.directions[1] = Dir.LOOP;
        this.nDirections = 2;
        this.currentDirection = this.directions.length;
        this.onRelationship = false;
        this.onGroup = false;
        this.foundTypes = 0;
    }

    public void all(RelationshipGroupCursor groupCursor, RelationshipTraversalCursor relationshipCursor) {
        this.all(groupCursor, relationshipCursor, null);
    }

    public void all(RelationshipGroupCursor groupCursor, RelationshipTraversalCursor relationshipCursor, int[] types) {
        this.groupCursor = groupCursor;
        this.relationshipCursor = relationshipCursor;
        this.types = types;
        this.directions[0] = Dir.OUT;
        this.directions[1] = Dir.IN;
        this.directions[2] = Dir.LOOP;
        this.nDirections = 3;
        this.currentDirection = this.directions.length;
        this.onRelationship = false;
        this.onGroup = false;
        this.foundTypes = 0;
    }

    protected boolean fetchNext() {
        if (this.onRelationship) {
            this.onRelationship = this.relationshipCursor.next();
        }
        block5: while (!this.onRelationship) {
            ++this.currentDirection;
            if (this.currentDirection >= this.nDirections) {
                if (this.types != null && this.foundTypes >= this.types.length) {
                    this.onGroup = false;
                    return false;
                }
                do {
                    this.onGroup = this.groupCursor.next();
                } while (this.onGroup && !this.correctRelationshipType());
                if (this.onGroup) {
                    ++this.foundTypes;
                    this.currentDirection = 0;
                }
            }
            if (!this.onGroup) {
                return false;
            }
            Dir d = this.directions[this.currentDirection];
            switch (d) {
                case OUT: {
                    this.groupCursor.outgoing(this.relationshipCursor);
                    this.onRelationship = this.relationshipCursor.next();
                    continue block5;
                }
                case IN: {
                    this.groupCursor.incoming(this.relationshipCursor);
                    this.onRelationship = this.relationshipCursor.next();
                    continue block5;
                }
                case LOOP: {
                    this.groupCursor.loops(this.relationshipCursor);
                    this.onRelationship = this.relationshipCursor.next();
                    continue block5;
                }
            }
            throw new IllegalStateException("Lorem ipsus, Brutus");
        }
        this.setRelationship(this.relationshipCursor.relationshipReference(), this.relationshipCursor.sourceNodeReference(), this.relationshipCursor.label(), this.relationshipCursor.targetNodeReference());
        return true;
    }

    protected abstract void setRelationship(long var1, long var3, int var5, long var6);

    private boolean correctRelationshipType() {
        return this.types == null || ArrayUtils.contains((int[])this.types, (int)this.groupCursor.relationshipLabel());
    }

    public void close() {
        Throwable closeGroupError = null;
        try {
            if (this.groupCursor != null) {
                this.groupCursor.close();
            }
        }
        catch (Throwable t) {
            closeGroupError = t;
        }
        try {
            if (this.relationshipCursor != null) {
                this.relationshipCursor.close();
            }
        }
        catch (Throwable t) {
            if (closeGroupError != null) {
                t.addSuppressed(closeGroupError);
            }
            throw t;
        }
        finally {
            this.relationshipCursor = null;
            this.groupCursor = null;
        }
    }

    private static enum Dir {
        OUT,
        IN,
        LOOP;

    }
}

