/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api.txstate;

import java.util.function.Function;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.exceptions.KernelException;
import org.neo4j.graphdb.Vector;
import org.neo4j.internal.kernel.api.Upgrade;
import org.neo4j.internal.kernel.api.exceptions.schema.ConstraintValidationException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.storageengine.api.StorageProperty;
import org.neo4j.storageengine.api.txstate.EntityChange;
import org.neo4j.storageengine.api.txstate.RelationshipModifications;
import org.neo4j.values.storable.ValueTuple;

public interface TxStateVisitor
extends AutoCloseable {
    public static final TxStateVisitor EMPTY = new Adapter();
    public static final Decorator NO_DECORATION = txStateVisitor -> txStateVisitor;

    public void visitCreatedNode(long var1);

    public void visitDeletedNode(long var1);

    public void visitRelationshipModifications(RelationshipModifications var1) throws ConstraintValidationException;

    public void visitNodePropertyChanges(long var1, Iterable<StorageProperty> var3, IntIterable var4) throws ConstraintValidationException;

    public void visitNodeLabelChanges(long var1, IntSet var3, IntSet var4) throws ConstraintValidationException;

    public void visitAddedIndex(IndexDescriptor var1) throws KernelException;

    public void visitRemovedIndex(IndexDescriptor var1);

    public void visitAddedConstraint(ConstraintDescriptor var1) throws KernelException;

    public void visitRemovedConstraint(ConstraintDescriptor var1);

    public void visitCreatedLabelToken(long var1, String var3, boolean var4);

    public void visitCreatedPropertyKeyToken(long var1, String var3, boolean var4);

    public void visitCreatedRelationshipTypeToken(long var1, String var3, boolean var4);

    public void visitValueIndexUpdate(IndexDescriptor var1, long var2, ValueTuple var4, EntityChange var5);

    public void visitKernelUpgrade(Upgrade.KernelUpgrade var1);

    public void visitCreateVectorStore(VectorStoreIdType var1);

    @Override
    public void close() throws KernelException;

    public static class Adapter
    implements TxStateVisitor {
        @Override
        public void visitCreatedNode(long id) {
        }

        @Override
        public void visitDeletedNode(long id) {
        }

        @Override
        public void visitRelationshipModifications(RelationshipModifications modifications) throws ConstraintValidationException {
        }

        @Override
        public void visitNodePropertyChanges(long id, Iterable<StorageProperty> added, IntIterable removed) throws ConstraintValidationException {
        }

        @Override
        public void visitNodeLabelChanges(long id, IntSet added, IntSet removed) throws ConstraintValidationException {
        }

        @Override
        public void visitAddedIndex(IndexDescriptor index) throws KernelException {
        }

        @Override
        public void visitRemovedIndex(IndexDescriptor index) {
        }

        @Override
        public void visitAddedConstraint(ConstraintDescriptor element) throws KernelException {
        }

        @Override
        public void visitRemovedConstraint(ConstraintDescriptor element) {
        }

        @Override
        public void visitCreatedLabelToken(long id, String name, boolean internal) {
        }

        @Override
        public void visitCreatedPropertyKeyToken(long id, String name, boolean internal) {
        }

        @Override
        public void visitCreatedRelationshipTypeToken(long id, String name, boolean internal) {
        }

        @Override
        public void visitValueIndexUpdate(IndexDescriptor descriptor, long entityIdId, ValueTuple values, EntityChange entityChange) {
        }

        @Override
        public void visitKernelUpgrade(Upgrade.KernelUpgrade kernelUpgrade) {
        }

        @Override
        public void visitCreateVectorStore(VectorStoreIdType vectorStoreToCreate) {
        }

        @Override
        public void close() {
        }
    }

    public static interface Decorator
    extends Function<TxStateVisitor, TxStateVisitor> {
    }

    public static class Delegator
    implements TxStateVisitor {
        private final TxStateVisitor actual;

        public Delegator(TxStateVisitor actual) {
            assert (actual != null);
            this.actual = actual;
        }

        @Override
        public void visitCreatedNode(long id) {
            this.actual.visitCreatedNode(id);
        }

        @Override
        public void visitDeletedNode(long id) {
            this.actual.visitDeletedNode(id);
        }

        @Override
        public void visitRelationshipModifications(RelationshipModifications modifications) throws ConstraintValidationException {
            this.actual.visitRelationshipModifications(modifications);
        }

        @Override
        public void visitValueIndexUpdate(IndexDescriptor descriptor, long entityId, ValueTuple values, EntityChange entityChange) {
            this.actual.visitValueIndexUpdate(descriptor, entityId, values, entityChange);
        }

        @Override
        public void visitNodePropertyChanges(long id, Iterable<StorageProperty> added, IntIterable removed) throws ConstraintValidationException {
            this.actual.visitNodePropertyChanges(id, added, removed);
        }

        @Override
        public void visitNodeLabelChanges(long id, IntSet added, IntSet removed) throws ConstraintValidationException {
            this.actual.visitNodeLabelChanges(id, added, removed);
        }

        @Override
        public void visitAddedIndex(IndexDescriptor index) throws KernelException {
            this.actual.visitAddedIndex(index);
        }

        @Override
        public void visitRemovedIndex(IndexDescriptor index) {
            this.actual.visitRemovedIndex(index);
        }

        @Override
        public void visitAddedConstraint(ConstraintDescriptor constraint) throws KernelException {
            this.actual.visitAddedConstraint(constraint);
        }

        @Override
        public void visitRemovedConstraint(ConstraintDescriptor constraint) {
            this.actual.visitRemovedConstraint(constraint);
        }

        @Override
        public void visitCreatedLabelToken(long id, String name, boolean internal) {
            this.actual.visitCreatedLabelToken(id, name, internal);
        }

        @Override
        public void visitCreatedPropertyKeyToken(long id, String name, boolean internal) {
            this.actual.visitCreatedPropertyKeyToken(id, name, internal);
        }

        @Override
        public void visitCreatedRelationshipTypeToken(long id, String name, boolean internal) {
            this.actual.visitCreatedRelationshipTypeToken(id, name, internal);
        }

        @Override
        public void visitKernelUpgrade(Upgrade.KernelUpgrade kernelUpgrade) {
            this.actual.visitKernelUpgrade(kernelUpgrade);
        }

        @Override
        public void visitCreateVectorStore(VectorStoreIdType vectorStoreToCreate) {
            this.actual.visitCreateVectorStore(vectorStoreToCreate);
        }

        @Override
        public void close() throws KernelException {
            this.actual.close();
        }
    }

    public record VectorStoreIdType(Vector.CoordinateType coordinate, int dimensions) {
    }
}

