/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.storageengine.api.StoreId;
import org.neo4j.util.Preconditions;

public class StoreIdSerialization {
    public static final int MAX_STORE_ID_LENGTH = 64;
    private static final byte VERSION = 1;

    static void serialize(StoreId storeId, final WritableChannel channel) throws IOException {
        StoreIdSerialization.serialize(storeId, new Writer(){

            @Override
            public void writeByte(byte value) throws IOException {
                channel.put(value);
            }

            @Override
            public void writeLong(long value) throws IOException {
                channel.putLong(value);
            }

            @Override
            public void writeByteArray(byte[] value, int length) throws IOException {
                channel.put(value, length);
            }
        });
    }

    static StoreId deserialize(final ReadableChannel channel) throws IOException {
        return StoreIdSerialization.deserialize(new Reader(){

            @Override
            public byte readByte() throws IOException {
                return channel.get();
            }

            @Override
            public long readLong() throws IOException {
                return channel.getLong();
            }

            @Override
            public void readByteArray(byte[] value, int length) throws IOException {
                channel.get(value, length);
            }
        });
    }

    public static void serializeWithFixedSize(StoreId storeId, final ByteBuffer buffer) throws IOException {
        if (buffer.remaining() < 64) {
            throw new IllegalArgumentException("The submitted buffer is too small");
        }
        int originalLimit = buffer.limit();
        buffer.limit(buffer.position() + 64);
        StoreIdSerialization.serialize(storeId, new Writer(){

            @Override
            public void writeByte(byte value) {
                buffer.put(value);
            }

            @Override
            public void writeLong(long value) {
                buffer.putLong(value);
            }

            @Override
            public void writeByteArray(byte[] value, int length) {
                buffer.put(value, 0, length);
            }
        });
        while (buffer.hasRemaining()) {
            buffer.put((byte)0);
        }
        buffer.limit(originalLimit);
    }

    public static StoreId deserializeWithFixedSize(final ByteBuffer buffer) throws IOException {
        if (buffer.remaining() < 64) {
            throw new IllegalArgumentException("The submitted buffer is too small");
        }
        int originalLimit = buffer.limit();
        buffer.limit(buffer.position() + 64);
        StoreId storeId = StoreIdSerialization.deserialize(new Reader(){

            @Override
            public byte readByte() {
                return buffer.get();
            }

            @Override
            public long readLong() {
                return buffer.getLong();
            }

            @Override
            public void readByteArray(byte[] value, int length) {
                buffer.get(value, 0, length);
            }
        });
        buffer.position(buffer.limit());
        buffer.limit(originalLimit);
        return storeId;
    }

    private static void serialize(StoreId storeId, Writer writer) throws IOException {
        byte[] storageEngine = storeId.getStorageEngineName().getBytes(StandardCharsets.UTF_8);
        byte[] formatName = storeId.getFormatName().getBytes(StandardCharsets.UTF_8);
        Preconditions.requireBetween((int)storageEngine.length, (int)0, (int)256);
        Preconditions.requireBetween((int)formatName.length, (int)0, (int)256);
        Preconditions.requireBetween((int)storeId.getMajorVersion(), (int)-128, (int)128);
        Preconditions.requireBetween((int)storeId.getMinorVersion(), (int)-1, (int)128);
        writer.writeByte((byte)1);
        writer.writeLong(storeId.getCreationTime());
        writer.writeLong(storeId.getRandom());
        writer.writeByte((byte)storageEngine.length);
        writer.writeByteArray(storageEngine, storageEngine.length);
        writer.writeByte((byte)formatName.length);
        writer.writeByteArray(formatName, formatName.length);
        writer.writeByte((byte)storeId.getMajorVersion());
        writer.writeByte((byte)storeId.getMinorVersion());
    }

    private static StoreId deserialize(Reader reader) throws IOException {
        byte version = reader.readByte();
        if (version != 1) {
            throw new IllegalArgumentException("Unknown serialization format version: " + version);
        }
        long creationTime = reader.readLong();
        long randomId = reader.readLong();
        String storageEngine = StoreIdSerialization.deserializeString(reader);
        String formatName = StoreIdSerialization.deserializeString(reader);
        byte majorVersion = reader.readByte();
        byte minorVersion = reader.readByte();
        return new StoreId(creationTime, randomId, storageEngine, formatName, majorVersion, minorVersion);
    }

    private static String deserializeString(Reader reader) throws IOException {
        int length = reader.readByte() & 0xFF;
        byte[] bytes = new byte[length];
        reader.readByteArray(bytes, length);
        return new String(bytes, StandardCharsets.UTF_8);
    }

    private static interface Writer {
        public void writeByte(byte var1) throws IOException;

        public void writeLong(long var1) throws IOException;

        public void writeByteArray(byte[] var1, int var2) throws IOException;
    }

    private static interface Reader {
        public byte readByte() throws IOException;

        public long readLong() throws IOException;

        public void readByteArray(byte[] var1, int var2) throws IOException;
    }
}

