/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.eclipse.collections.api.block.function.Function0;
import org.eclipse.collections.api.block.procedure.primitive.IntObjectProcedure;
import org.eclipse.collections.api.iterator.MutableIntIterator;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.neo4j.collection.PrimitiveArrays;
import org.neo4j.common.EntityType;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaPatternMatchingType;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.AllNodeScan;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.PropertySelection;
import org.neo4j.storageengine.api.StorageEntityCursor;
import org.neo4j.storageengine.api.StorageEntityScanCursor;
import org.neo4j.storageengine.api.StoragePropertyCursor;
import org.neo4j.storageengine.api.StorageReader;
import org.neo4j.storageengine.api.TokenIndexEntryUpdate;
import org.neo4j.storageengine.api.ValueIndexEntryUpdate;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.values.storable.Value;

public class EntityUpdates {
    public static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(EntityUpdates.class);
    private final long entityId;
    private int[] entityTokensBefore;
    private int[] entityTokensAfter;
    private final boolean propertyListComplete;
    private final MutableIntObjectMap<PropertyValue> knownProperties;
    private int[] propertyKeyIds;
    private int propertyKeyIdsCursor;
    private boolean hasLoadedAdditionalProperties;
    private static final PropertyValue NO_VALUE = new PropertyValue(null, null, PropertyValueType.NoValue);

    private void put(int propertyKeyId, PropertyValue propertyValue) {
        PropertyValue existing = (PropertyValue)this.knownProperties.put(propertyKeyId, (Object)propertyValue);
        if (existing == null) {
            if (this.propertyKeyIdsCursor >= this.propertyKeyIds.length) {
                this.propertyKeyIds = Arrays.copyOf(this.propertyKeyIds, this.propertyKeyIdsCursor * 2);
            }
            this.propertyKeyIds[this.propertyKeyIdsCursor++] = propertyKeyId;
        }
    }

    public static Builder forEntity(long entityId, boolean propertyListIsComplete) {
        return new Builder(new EntityUpdates(entityId, ArrayUtils.EMPTY_INT_ARRAY, ArrayUtils.EMPTY_INT_ARRAY, propertyListIsComplete));
    }

    private EntityUpdates(long entityId, int[] entityTokensBefore, int[] entityTokensAfter, boolean propertyListComplete) {
        this.entityId = entityId;
        this.entityTokensBefore = entityTokensBefore;
        this.entityTokensAfter = entityTokensAfter;
        this.propertyListComplete = propertyListComplete;
        this.knownProperties = new IntObjectHashMap();
        this.propertyKeyIds = new int[8];
    }

    public final long getEntityId() {
        return this.entityId;
    }

    public int[] entityTokensChanged() {
        return PrimitiveArrays.symmetricDifference((int[])this.entityTokensBefore, (int[])this.entityTokensAfter);
    }

    public int[] entityTokensUnchanged() {
        return PrimitiveArrays.intersect((int[])this.entityTokensBefore, (int[])this.entityTokensAfter);
    }

    public int[] propertiesChanged() {
        assert (!this.hasLoadedAdditionalProperties) : "Calling propertiesChanged() is not valid after non-changed properties have already been loaded.";
        Arrays.sort(this.propertyKeyIds, 0, this.propertyKeyIdsCursor);
        return this.propertyKeyIdsCursor == this.propertyKeyIds.length ? this.propertyKeyIds : Arrays.copyOf(this.propertyKeyIds, this.propertyKeyIdsCursor);
    }

    public boolean isPropertyListComplete() {
        return this.propertyListComplete;
    }

    public Iterable<IndexEntryUpdate> valueUpdatesForIndexKeys(Iterable<IndexDescriptor> indexKeys) {
        Iterable potentiallyRelevant = Iterables.filter(indexKeys, indexKey -> this.atLeastOneRelevantChange(indexKey.schema()));
        return this.gatherUpdatesForPotentials(potentiallyRelevant, true);
    }

    public Iterable<IndexEntryUpdate> valueUpdatesForIndexKeys(Iterable<IndexDescriptor> indexKeys, StorageReader reader, EntityType type, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        ArrayList<IndexDescriptor> potentiallyRelevant = new ArrayList<IndexDescriptor>();
        IntHashSet additionalPropertiesToLoad = new IntHashSet();
        for (IndexDescriptor indexKey : indexKeys) {
            if (!this.atLeastOneRelevantChange(indexKey.schema())) continue;
            potentiallyRelevant.add(indexKey);
            this.gatherPropsToLoad(indexKey.schema(), (MutableIntSet)additionalPropertiesToLoad);
        }
        if (!additionalPropertiesToLoad.isEmpty()) {
            this.loadProperties(reader, (MutableIntSet)additionalPropertiesToLoad, type, cursorContext, storeCursors, memoryTracker);
        }
        return this.gatherUpdatesForPotentials(potentiallyRelevant, false);
    }

    private Iterable<IndexEntryUpdate> gatherUpdatesForPotentials(Iterable<IndexDescriptor> potentiallyRelevant, boolean defaultToNoValue) {
        ArrayList<IndexEntryUpdate> indexUpdates = new ArrayList<IndexEntryUpdate>();
        for (IndexDescriptor indexKey : potentiallyRelevant) {
            SchemaDescriptor schema = indexKey.schema();
            boolean relevantBefore = this.relevantBefore(schema);
            boolean relevantAfter = this.relevantAfter(schema);
            int[] propertyIds = schema.getPropertyIds();
            if (relevantBefore && !relevantAfter) {
                indexUpdates.add(ValueIndexEntryUpdate.remove(this.entityId, indexKey, this.valuesBefore(propertyIds, defaultToNoValue)));
                continue;
            }
            if (!relevantBefore && relevantAfter) {
                indexUpdates.add(ValueIndexEntryUpdate.add(this.entityId, indexKey, this.valuesAfter(propertyIds)));
                continue;
            }
            if (!relevantBefore || !relevantAfter || !this.valuesChanged(propertyIds, schema.schemaPatternMatchingType(), defaultToNoValue)) continue;
            indexUpdates.add(ValueIndexEntryUpdate.change(this.entityId, indexKey, this.valuesBefore(propertyIds, defaultToNoValue), this.valuesAfter(propertyIds)));
        }
        return indexUpdates;
    }

    public Optional<IndexEntryUpdate> tokenUpdateForIndexKey(IndexDescriptor indexKey) {
        if (indexKey == null || Arrays.equals(this.entityTokensBefore, this.entityTokensAfter)) {
            return Optional.empty();
        }
        PrimitiveArrays.RemovalsAndAdditions additionsAndRemovals = PrimitiveArrays.toRemovalsAndAdditions((int[])this.entityTokensBefore, (int[])this.entityTokensAfter);
        return Optional.of(TokenIndexEntryUpdate.tokenChange(this.entityId, indexKey, additionsAndRemovals.removals(), additionsAndRemovals.additions()));
    }

    private boolean relevantBefore(SchemaDescriptor schema) {
        return schema.isAffected(this.entityTokensBefore) && this.hasPropsBefore(schema.getPropertyIds(), schema.schemaPatternMatchingType());
    }

    private boolean relevantAfter(SchemaDescriptor schema) {
        return schema.isAffected(this.entityTokensAfter) && this.hasPropsAfter(schema.getPropertyIds(), schema.schemaPatternMatchingType());
    }

    private void loadProperties(StorageReader reader, MutableIntSet additionalPropertiesToLoad, EntityType type, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        StorageEntityScanCursor<AllNodeScan> cursor;
        this.hasLoadedAdditionalProperties = true;
        if (type == EntityType.NODE) {
            cursor = reader.allocateNodeCursor(cursorContext, storeCursors, memoryTracker);
            try {
                cursor.single(this.entityId);
                this.loadProperties(reader, cursor, additionalPropertiesToLoad, cursorContext, storeCursors, memoryTracker);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        if (type == EntityType.RELATIONSHIP) {
            cursor = reader.allocateRelationshipScanCursor(cursorContext, storeCursors, memoryTracker);
            try {
                cursor.single(this.entityId);
                this.loadProperties(reader, cursor, additionalPropertiesToLoad, cursorContext, storeCursors, memoryTracker);
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        MutableIntIterator propertiesWithNoValue = additionalPropertiesToLoad.intIterator();
        while (propertiesWithNoValue.hasNext()) {
            this.put(propertiesWithNoValue.next(), NO_VALUE);
        }
    }

    private void loadProperties(StorageReader reader, StorageEntityCursor cursor, MutableIntSet additionalPropertiesToLoad, CursorContext cursorContext, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        if (cursor.next() && cursor.hasProperties()) {
            try (StoragePropertyCursor propertyCursor = reader.allocatePropertyCursor(cursorContext, storeCursors, memoryTracker);){
                cursor.properties(propertyCursor, PropertySelection.selection(additionalPropertiesToLoad.toArray()));
                while (propertyCursor.next()) {
                    additionalPropertiesToLoad.remove(propertyCursor.propertyKey());
                    this.knownProperties.put(propertyCursor.propertyKey(), (Object)EntityUpdates.unchanged(propertyCursor.propertyValue()));
                }
            }
        }
    }

    private void gatherPropsToLoad(SchemaDescriptor schema, MutableIntSet target) {
        for (int propertyId : schema.getPropertyIds()) {
            if (this.knownProperties.get(propertyId) != null) continue;
            target.add(propertyId);
        }
    }

    private boolean atLeastOneRelevantChange(SchemaDescriptor schema) {
        boolean affectedBefore = schema.isAffected(this.entityTokensBefore);
        boolean affectedAfter = schema.isAffected(this.entityTokensAfter);
        if (affectedBefore && affectedAfter) {
            for (int propertyId : schema.getPropertyIds()) {
                if (!this.knownProperties.containsKey(propertyId)) continue;
                return true;
            }
            return false;
        }
        return affectedBefore || affectedAfter;
    }

    private boolean hasPropsBefore(int[] propertyIds, SchemaPatternMatchingType schemaPatternMatchingType) {
        boolean found = false;
        for (int propertyId : propertyIds) {
            PropertyValue propertyValue = (PropertyValue)this.knownProperties.getIfAbsent(propertyId, (Function0 & Serializable)() -> NO_VALUE);
            if (!propertyValue.hasBefore()) {
                if (schemaPatternMatchingType != SchemaPatternMatchingType.COMPLETE_ALL_TOKENS) continue;
                return false;
            }
            found = true;
        }
        return found;
    }

    private boolean hasPropsAfter(int[] propertyIds, SchemaPatternMatchingType schemaPatternMatchingType) {
        boolean found = false;
        for (int propertyId : propertyIds) {
            PropertyValue propertyValue = (PropertyValue)this.knownProperties.getIfAbsent(propertyId, (Function0 & Serializable)() -> NO_VALUE);
            if (!propertyValue.hasAfter()) {
                if (schemaPatternMatchingType != SchemaPatternMatchingType.COMPLETE_ALL_TOKENS) continue;
                return false;
            }
            found = true;
        }
        return found;
    }

    private Value[] valuesBefore(int[] propertyIds, boolean defaultToNoValue) {
        Value[] values = new Value[propertyIds.length];
        for (int i = 0; i < propertyIds.length; ++i) {
            values[i] = this.knownProperty((int)propertyIds[i], (boolean)defaultToNoValue).before;
        }
        return values;
    }

    private Value[] valuesAfter(int[] propertyIds) {
        Value[] values = new Value[propertyIds.length];
        for (int i = 0; i < propertyIds.length; ++i) {
            PropertyValue propertyValue = (PropertyValue)this.knownProperties.get(propertyIds[i]);
            values[i] = propertyValue == null ? null : propertyValue.after;
        }
        return values;
    }

    private boolean valuesChanged(int[] propertyIds, SchemaPatternMatchingType schemaPatternMatchingType, boolean defaultToNoValue) {
        if (schemaPatternMatchingType == SchemaPatternMatchingType.COMPLETE_ALL_TOKENS) {
            for (int propertyId : propertyIds) {
                if (((PropertyValue)this.knownProperties.get((int)propertyId)).type != PropertyValueType.Changed) continue;
                return true;
            }
            return false;
        }
        for (int propertyId : propertyIds) {
            PropertyValueType type = this.knownProperty((int)propertyId, (boolean)defaultToNoValue).type;
            if (type == PropertyValueType.UnChanged || type == PropertyValueType.NoValue) continue;
            return true;
        }
        return false;
    }

    private PropertyValue knownProperty(int propertyId, boolean defaultToNoValue) {
        PropertyValue value = (PropertyValue)this.knownProperties.get(propertyId);
        if (value == null && defaultToNoValue) {
            value = NO_VALUE;
        }
        return value;
    }

    public String toString() {
        StringBuilder result = new StringBuilder(this.getClass().getSimpleName()).append('[').append(this.entityId);
        result.append(", entityTokensBefore:").append(Arrays.toString(this.entityTokensBefore));
        result.append(", entityTokensAfter:").append(Arrays.toString(this.entityTokensAfter));
        this.knownProperties.forEachKeyValue((IntObjectProcedure & Serializable)(key, propertyValue) -> {
            result.append(", ");
            result.append(key);
            result.append(" -> ");
            result.append(propertyValue);
        });
        return result.append(']').toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EntityUpdates that = (EntityUpdates)o;
        return this.entityId == that.entityId && Arrays.equals(this.entityTokensBefore, that.entityTokensBefore) && Arrays.equals(this.entityTokensAfter, that.entityTokensAfter);
    }

    public int hashCode() {
        int result = Objects.hash(this.entityId);
        result = 31 * result + Arrays.hashCode(this.entityTokensBefore);
        result = 31 * result + Arrays.hashCode(this.entityTokensAfter);
        return result;
    }

    private static PropertyValue before(Value value) {
        return new PropertyValue(value, null, PropertyValueType.Before);
    }

    private static PropertyValue after(Value value) {
        return new PropertyValue(null, value, PropertyValueType.After);
    }

    private static PropertyValue unchanged(Value value) {
        return new PropertyValue(value, value, PropertyValueType.UnChanged);
    }

    private static PropertyValue changed(Value before, Value after) {
        return new PropertyValue(before, after, PropertyValueType.Changed);
    }

    private static class PropertyValue {
        private final Value before;
        private final Value after;
        private final PropertyValueType type;

        private PropertyValue(Value before, Value after, PropertyValueType type) {
            this.before = before;
            this.after = after;
            this.type = type;
        }

        boolean hasBefore() {
            return this.before != null;
        }

        boolean hasAfter() {
            return this.after != null;
        }

        public String toString() {
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "NoValue";
                case 1 -> String.format("Before(%s)", this.before);
                case 2 -> String.format("After(%s)", this.after);
                case 3 -> String.format("UnChanged(%s)", this.after);
                case 4 -> String.format("Changed(from=%s, to=%s)", this.before, this.after);
            };
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PropertyValue that = (PropertyValue)o;
            if (this.type != that.type) {
                return false;
            }
            return switch (this.type.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> this.before.equals(that.before);
                case 2 -> this.after.equals(that.after);
                case 3 -> this.after.equals(that.after);
                case 4 -> this.before.equals(that.before) && this.after.equals(that.after);
            };
        }

        public int hashCode() {
            int result = this.before != null ? this.before.hashCode() : 0;
            result = 31 * result + (this.after != null ? this.after.hashCode() : 0);
            result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
            return result;
        }
    }

    public static class Builder {
        private final EntityUpdates updates;

        private Builder(EntityUpdates updates) {
            this.updates = updates;
        }

        public Builder added(int propertyKeyId, Value value) {
            this.updates.put(propertyKeyId, EntityUpdates.after(value));
            return this;
        }

        public Builder removed(int propertyKeyId, Value value) {
            this.updates.put(propertyKeyId, EntityUpdates.before(value));
            return this;
        }

        public Builder changed(int propertyKeyId, Value before, Value after) {
            this.updates.put(propertyKeyId, EntityUpdates.changed(before, after));
            return this;
        }

        public Builder existing(int propertyKeyId, Value value) {
            this.updates.put(propertyKeyId, EntityUpdates.unchanged(value));
            return this;
        }

        public Builder withTokens(int ... entityTokens) {
            this.updates.entityTokensBefore = entityTokens;
            this.updates.entityTokensAfter = entityTokens;
            return this;
        }

        public Builder withTokensBefore(int ... entityTokensBefore) {
            this.updates.entityTokensBefore = entityTokensBefore;
            return this;
        }

        public Builder withTokensAfter(int ... entityTokensAfter) {
            this.updates.entityTokensAfter = entityTokensAfter;
            return this;
        }

        public EntityUpdates build() {
            return this.updates;
        }
    }

    static enum PropertyValueType {
        NoValue,
        Before,
        After,
        UnChanged,
        Changed;

    }
}

