/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.storageengine.api;

import java.util.concurrent.atomic.LongAdder;
import org.neo4j.graphdb.TransientFailureException;
import org.neo4j.internal.kernel.api.exceptions.ConstraintViolationTransactionFailureException;
import org.neo4j.internal.kernel.api.exceptions.schema.TokenLengthLimitExceededException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.api.LeaseException;
import org.neo4j.kernel.impl.locking.LockClientStoppedException;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

public interface InternalErrorTracer {
    public static final InternalErrorTracer NO_TRACER = new InternalErrorTracer(){

        @Override
        public void traceReadError(Throwable throwable) {
        }

        @Override
        public void traceWriteError(Throwable throwable) {
        }

        @Override
        public long internalReadErrors() {
            return 0L;
        }

        @Override
        public long internalWriteErrors() {
            return 0L;
        }
    };

    public long internalReadErrors();

    public long internalWriteErrors();

    public void traceReadError(Throwable var1);

    public void traceWriteError(Throwable var1);

    public static class Impl
    implements InternalErrorTracer {
        private final LongAdder internalReadErrors = new LongAdder();
        private final LongAdder internalWriteErrors = new LongAdder();
        private final InternalLog log;

        public Impl(InternalLogProvider logProvider) {
            this.log = logProvider.getLog(InternalErrorTracer.class);
        }

        @Override
        public long internalReadErrors() {
            return this.internalReadErrors.sum();
        }

        @Override
        public long internalWriteErrors() {
            return this.internalWriteErrors.sum();
        }

        @Override
        public void traceReadError(Throwable throwable) {
            if (Impl.isUnexpected(throwable)) {
                this.log.info("Internal read error observed", throwable);
                this.internalReadErrors.increment();
            }
        }

        @Override
        public void traceWriteError(Throwable throwable) {
            if (Impl.isUnexpected(throwable)) {
                this.log.info("Internal write error observed", throwable);
                this.internalWriteErrors.increment();
            }
        }

        private static boolean isUnexpected(Throwable throwable) {
            return !Impl.isTransient(throwable) && !Impl.isConstraintViolation(throwable) && !Impl.isLockClientTermination(throwable) && !Impl.isLeaseException(throwable) && !Impl.isTokenLengthLimit(throwable);
        }

        private static boolean isLeaseException(Throwable throwable) {
            return throwable instanceof LeaseException;
        }

        private static boolean isLockClientTermination(Throwable throwable) {
            return throwable instanceof LockClientStoppedException;
        }

        private static boolean isConstraintViolation(Throwable throwable) {
            return throwable instanceof ConstraintViolationTransactionFailureException;
        }

        private static boolean isTokenLengthLimit(Throwable throwable) {
            return throwable instanceof TokenLengthLimitExceededException;
        }

        private static boolean isTransient(Throwable throwable) {
            Status.HasStatus hasStatus;
            return throwable instanceof TransientFailureException || throwable instanceof Status.HasStatus && (hasStatus = (Status.HasStatus)throwable).status().code().classification() == Status.Classification.TransientError;
        }
    }
}

