/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.kernel.api.security;

import java.net.InetAddress;
import java.net.URI;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.factory.primitive.IntSets;
import org.neo4j.internal.kernel.api.RelTypeSupplier;
import org.neo4j.internal.kernel.api.TokenSet;
import org.neo4j.internal.kernel.api.security.PermissionState;
import org.neo4j.internal.kernel.api.security.PrivilegeAction;
import org.neo4j.internal.kernel.api.security.ReadSecurityPropertyProvider;
import org.neo4j.internal.kernel.api.security.SelectedPropertiesProvider;
import org.neo4j.storageengine.api.PropertySelection;

public interface AccessMode {
    public boolean allowsWrites();

    public PermissionState allowsTokenCreates(PrivilegeAction var1);

    public boolean allowsSchemaWrites();

    public PermissionState allowsSchemaWrites(PrivilegeAction var1);

    public boolean allowsShowIndex();

    public boolean allowsShowConstraint();

    public boolean allowsTraverseAllLabels();

    public boolean allowsTraverseAllNodesWithLabel(int var1);

    public boolean disallowsTraverseLabel(int var1);

    public boolean allowsTraverseNode(int ... var1);

    public IntSet getTraverseNodeSecurityProperties(int[] var1);

    public boolean hasApplicableTraverseNodeAllowPropertyRules(int var1);

    public boolean allowsTraverseNodeWithPropertyRules(ReadSecurityPropertyProvider var1, int ... var2);

    public boolean hasTraverseNodePropertyRules();

    public boolean allowsTraverseAllRelTypes();

    public boolean allowsTraverseRelType(int var1);

    public boolean disallowsTraverseRelType(int var1);

    public IntSet getTraverseRelSecurityProperties(int var1);

    public boolean hasApplicableTraverseRelAllowPropertyRules(int var1);

    public boolean allowsTraverseRelationship(int var1, SelectedPropertiesProvider var2);

    public boolean hasTraverseRelPropertyRules();

    public boolean allowsReadPropertyAllLabels(int var1);

    public boolean disallowsReadPropertyForSomeLabel(int var1);

    public boolean allowsReadNodePropertiesWithPropertyRules(Supplier<TokenSet> var1, int[] var2, ReadSecurityPropertyProvider var3);

    public boolean allowsReadNodeProperties(Supplier<TokenSet> var1, int[] var2);

    public boolean allowsReadNodePropertyWithPropertyRules(Supplier<TokenSet> var1, int var2, ReadSecurityPropertyProvider var3);

    public boolean allowsReadNodeProperty(Supplier<TokenSet> var1, int var2);

    public boolean allowsReadPropertyAllRelTypes(int var1);

    public boolean allowsReadRelProperty(RelTypeSupplier var1, int var2);

    public boolean allowsReadRelPropertiesWithPropertyRules(RelTypeSupplier var1, int[] var2, ReadSecurityPropertyProvider var3);

    public boolean allowsReadRelProperties(RelTypeSupplier var1, int[] var2);

    public boolean allowsReadRelPropertyWithPropertyRules(RelTypeSupplier var1, int var2, ReadSecurityPropertyProvider var3);

    public boolean allowsSeePropertyKeyToken(int var1);

    public boolean hasNodePropertyReadRules();

    public boolean hasNodePropertyReadRules(int ... var1);

    public IntSet getNodeReadSecurityProperties(int var1);

    public IntSet getAllNodeReadSecurityProperties();

    public PropertySelection getNodeSecurityPropertySelection(PropertySelection var1);

    public boolean hasRelPropertyReadRules();

    public boolean hasRelPropertyReadRules(int ... var1);

    public IntSet getRelReadSecurityProperties(int var1);

    public IntSet getAllRelReadSecurityProperties();

    public PropertySelection getRelSecurityPropertySelection(PropertySelection var1);

    public PermissionState allowsExecuteProcedure(int var1);

    public PermissionState allowExecuteAdminProcedures();

    public PermissionState shouldBoostProcedure(int var1);

    public PermissionState allowsExecuteFunction(int var1);

    public PermissionState shouldBoostFunction(int var1);

    public PermissionState allowsExecuteAggregatingFunction(int var1);

    public PermissionState shouldBoostAggregatingFunction(int var1);

    public PermissionState allowsShowSetting(String var1);

    public boolean allowsSetLabel(int var1);

    public boolean allowsRemoveLabel(int var1);

    public boolean allowsCreateNode(int[] var1);

    public boolean allowsDeleteNode(Supplier<TokenSet> var1);

    public boolean allowsCreateRelationship(int var1);

    public boolean allowsDeleteRelationship(int var1);

    public boolean allowsSetProperty(Supplier<TokenSet> var1, int var2);

    public boolean allowsSetProperty(RelTypeSupplier var1, int var2);

    public PermissionState allowsLoadAllData();

    public PermissionState allowsLoadUri(URI var1, InetAddress var2);

    public String name();

    default public Set<String> roles() {
        return Collections.emptySet();
    }

    default public boolean isOverridden() {
        return false;
    }

    default public boolean isCacheable() {
        return false;
    }

    public static enum Static implements AccessMode
    {
        ACCESS(false, false, false, false, false),
        CREDENTIALS_EXPIRED(false, false, false, false, false),
        READ(true, false, false, false, false),
        WRITE_ONLY(false, true, false, false, false),
        WRITE(true, true, false, false, false),
        TOKEN_WRITE(true, true, true, false, false),
        SCHEMA(true, true, true, true, false),
        FULL(true, true, true, true, true);

        private final boolean read;
        private final boolean write;
        private final boolean token;
        private final boolean schema;
        private final boolean procedureBoost;

        private Static(boolean read, boolean write, boolean token, boolean schema, boolean procedureBoost) {
            this.read = read;
            this.write = write;
            this.token = token;
            this.schema = schema;
            this.procedureBoost = procedureBoost;
        }

        @Override
        public boolean allowsWrites() {
            return this.write;
        }

        @Override
        public PermissionState allowsTokenCreates(PrivilegeAction action) {
            return PermissionState.fromAllowList(this.token);
        }

        @Override
        public boolean allowsSchemaWrites() {
            return this.schema;
        }

        @Override
        public PermissionState allowsSchemaWrites(PrivilegeAction action) {
            return PermissionState.fromAllowList(this.schema);
        }

        @Override
        public boolean allowsShowIndex() {
            return this.schema;
        }

        @Override
        public boolean allowsShowConstraint() {
            return this.schema;
        }

        @Override
        public boolean allowsTraverseAllLabels() {
            return this.read;
        }

        @Override
        public boolean allowsTraverseAllNodesWithLabel(int label) {
            return this.read;
        }

        @Override
        public boolean disallowsTraverseLabel(int label) {
            return false;
        }

        @Override
        public boolean allowsTraverseNode(int ... labels) {
            return this.read;
        }

        @Override
        public IntSet getTraverseNodeSecurityProperties(int[] labels) {
            return IntSets.immutable.empty();
        }

        @Override
        public boolean hasApplicableTraverseNodeAllowPropertyRules(int label) {
            return this.read;
        }

        @Override
        public boolean allowsTraverseNodeWithPropertyRules(ReadSecurityPropertyProvider propertyProvider, int ... labels) {
            return this.read;
        }

        @Override
        public boolean hasTraverseNodePropertyRules() {
            return false;
        }

        @Override
        public boolean allowsTraverseAllRelTypes() {
            return this.read;
        }

        @Override
        public boolean allowsTraverseRelType(int relType) {
            return this.read;
        }

        @Override
        public boolean disallowsTraverseRelType(int relType) {
            return false;
        }

        @Override
        public IntSet getTraverseRelSecurityProperties(int type) {
            return IntSets.immutable.empty();
        }

        @Override
        public boolean hasApplicableTraverseRelAllowPropertyRules(int type) {
            return this.read;
        }

        @Override
        public boolean allowsTraverseRelationship(int type, SelectedPropertiesProvider propertyProviderSupplier) {
            return this.read;
        }

        @Override
        public boolean hasTraverseRelPropertyRules() {
            return false;
        }

        @Override
        public boolean allowsReadPropertyAllLabels(int propertyKey) {
            return this.read;
        }

        @Override
        public boolean disallowsReadPropertyForSomeLabel(int propertyKey) {
            return false;
        }

        @Override
        public boolean allowsReadNodePropertiesWithPropertyRules(Supplier<TokenSet> labels, int[] propertyKeys, ReadSecurityPropertyProvider propertyProvider) {
            return this.read;
        }

        @Override
        public boolean allowsReadNodeProperties(Supplier<TokenSet> labels, int[] propertyKeys) {
            return this.read;
        }

        @Override
        public boolean allowsReadNodePropertyWithPropertyRules(Supplier<TokenSet> labels, int propertyKey, ReadSecurityPropertyProvider propertyProvider) {
            return this.read;
        }

        @Override
        public boolean allowsReadNodeProperty(Supplier<TokenSet> labels, int propertyKey) {
            return this.read;
        }

        @Override
        public boolean allowsReadPropertyAllRelTypes(int propertyKey) {
            return this.read;
        }

        @Override
        public boolean allowsReadRelProperty(RelTypeSupplier relType, int propertyKey) {
            return this.read;
        }

        @Override
        public boolean allowsReadRelPropertiesWithPropertyRules(RelTypeSupplier relType, int[] propertyKeys, ReadSecurityPropertyProvider propertyProvider) {
            return this.read;
        }

        @Override
        public boolean allowsReadRelProperties(RelTypeSupplier relType, int[] propertyKeys) {
            return this.read;
        }

        @Override
        public boolean allowsReadRelPropertyWithPropertyRules(RelTypeSupplier relType, int propertyKey, ReadSecurityPropertyProvider propertyProvider) {
            return this.read;
        }

        @Override
        public IntSet getAllNodeReadSecurityProperties() {
            return IntSets.immutable.empty();
        }

        @Override
        public PropertySelection getNodeSecurityPropertySelection(PropertySelection selection) {
            return PropertySelection.NO_PROPERTIES;
        }

        @Override
        public boolean hasRelPropertyReadRules() {
            return false;
        }

        @Override
        public boolean hasRelPropertyReadRules(int ... propertyKeys) {
            return false;
        }

        @Override
        public IntSet getRelReadSecurityProperties(int propertyKey) {
            return IntSets.immutable.empty();
        }

        @Override
        public IntSet getAllRelReadSecurityProperties() {
            return IntSets.immutable.empty();
        }

        @Override
        public PropertySelection getRelSecurityPropertySelection(PropertySelection selection) {
            return PropertySelection.NO_PROPERTIES;
        }

        @Override
        public boolean allowsSeePropertyKeyToken(int propertyKey) {
            return this.read;
        }

        @Override
        public boolean hasNodePropertyReadRules() {
            return false;
        }

        @Override
        public boolean hasNodePropertyReadRules(int ... propertyKeys) {
            return false;
        }

        @Override
        public IntSet getNodeReadSecurityProperties(int propertyKey) {
            return IntSets.immutable.empty();
        }

        @Override
        public PermissionState allowsExecuteProcedure(int procedureId) {
            return PermissionState.EXPLICIT_GRANT;
        }

        @Override
        public PermissionState allowExecuteAdminProcedures() {
            return PermissionState.EXPLICIT_GRANT;
        }

        @Override
        public PermissionState shouldBoostProcedure(int procedureId) {
            return PermissionState.fromAllowList(this.procedureBoost);
        }

        @Override
        public PermissionState allowsExecuteFunction(int id) {
            return PermissionState.EXPLICIT_GRANT;
        }

        @Override
        public PermissionState shouldBoostFunction(int id) {
            return PermissionState.fromAllowList(this.procedureBoost);
        }

        @Override
        public PermissionState allowsExecuteAggregatingFunction(int id) {
            return PermissionState.EXPLICIT_GRANT;
        }

        @Override
        public PermissionState shouldBoostAggregatingFunction(int id) {
            return PermissionState.fromAllowList(this.procedureBoost);
        }

        @Override
        public PermissionState allowsShowSetting(String setting) {
            return PermissionState.EXPLICIT_GRANT;
        }

        @Override
        public boolean allowsSetLabel(int labelId) {
            return this.write;
        }

        @Override
        public boolean allowsRemoveLabel(int labelId) {
            return this.write;
        }

        @Override
        public boolean allowsCreateNode(int[] labelIds) {
            return this.write;
        }

        @Override
        public boolean allowsDeleteNode(Supplier<TokenSet> labelSupplier) {
            return this.write;
        }

        @Override
        public boolean allowsCreateRelationship(int relType) {
            return this.write;
        }

        @Override
        public boolean allowsDeleteRelationship(int relType) {
            return this.write;
        }

        @Override
        public boolean allowsSetProperty(Supplier<TokenSet> labels, int propertyKey) {
            return this.write;
        }

        @Override
        public boolean allowsSetProperty(RelTypeSupplier relType, int propertyKey) {
            return this.write;
        }

        @Override
        public PermissionState allowsLoadAllData() {
            return PermissionState.fromAllowList(this.read);
        }

        @Override
        public PermissionState allowsLoadUri(URI uri, InetAddress inetAddress) {
            return PermissionState.fromAllowList(this.read);
        }
    }
}

