/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.Flushable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.util.zip.Checksum;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FlushableChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.HeapScopedBuffer;
import org.neo4j.io.memory.ScopedBuffer;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class PhysicalFlushableChannel
implements FlushableChannel {
    public static final int DEFAULT_BUFFER_SIZE = Math.toIntExact(ByteUnit.kibiBytes(4L));
    protected StoreChannel channel;
    private final ByteBuffer checksumView;
    private final Checksum checksum;
    private ScopedBuffer scopedBuffer;
    private ByteBuffer buffer;
    private volatile boolean closed;

    @VisibleForTesting
    public PhysicalFlushableChannel(StoreChannel channel, MemoryTracker memoryTracker) {
        this(channel, new HeapScopedBuffer(DEFAULT_BUFFER_SIZE, ByteOrder.LITTLE_ENDIAN, memoryTracker));
    }

    public PhysicalFlushableChannel(StoreChannel channel, ScopedBuffer scopedBuffer) {
        this.channel = channel;
        this.scopedBuffer = scopedBuffer;
        this.buffer = scopedBuffer.getBuffer();
        this.checksumView = this.buffer.duplicate();
        this.checksum = (Checksum)CHECKSUM_FACTORY.get();
    }

    @Override
    public Flushable prepareForFlush() throws IOException {
        this.checksumView.limit(this.buffer.position());
        this.checksum.update(this.checksumView);
        this.checksumView.clear();
        this.buffer.flip();
        Flushable flushable = this.flushToChannel(this.channel, this.buffer);
        this.buffer.clear();
        return flushable;
    }

    @Override
    public FlushableChannel put(byte value) throws IOException {
        this.bufferWithGuaranteedSpace(1).put(value);
        return this;
    }

    @Override
    public FlushableChannel putShort(short value) throws IOException {
        this.bufferWithGuaranteedSpace(2).putShort(value);
        return this;
    }

    @Override
    public FlushableChannel putInt(int value) throws IOException {
        this.bufferWithGuaranteedSpace(4).putInt(value);
        return this;
    }

    @Override
    public FlushableChannel putLong(long value) throws IOException {
        this.bufferWithGuaranteedSpace(8).putLong(value);
        return this;
    }

    @Override
    public FlushableChannel putFloat(float value) throws IOException {
        this.bufferWithGuaranteedSpace(4).putFloat(value);
        return this;
    }

    @Override
    public FlushableChannel putDouble(double value) throws IOException {
        this.bufferWithGuaranteedSpace(8).putDouble(value);
        return this;
    }

    @Override
    public FlushableChannel put(byte[] value, int offset, int length) throws IOException {
        int chunkSize;
        assert (length >= 0);
        int capacity = this.buffer.capacity();
        for (int localOffset = 0; localOffset < length; localOffset += chunkSize) {
            int remaining = this.buffer.remaining();
            int bufferCapacity = remaining > 0 ? remaining : capacity;
            chunkSize = Math.min(length - localOffset, bufferCapacity);
            this.bufferWithGuaranteedSpace(chunkSize).put(value, offset + localOffset, chunkSize);
        }
        return this;
    }

    @Override
    public FlushableChannel putAll(ByteBuffer src) throws IOException {
        if (src.remaining() <= this.buffer.remaining()) {
            this.buffer.put(src);
            return this;
        }
        this.prepareForFlush();
        src.mark();
        this.flushToChannel(this.channel, src);
        src.reset();
        this.checksum.update(src);
        return this;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public void close() throws IOException {
        this.prepareForFlush().flush();
        this.closed = true;
        this.channel.close();
        this.scopedBuffer.close();
        this.scopedBuffer = HeapScopedBuffer.EMPTY_BUFFER;
        this.buffer = HeapScopedBuffer.EMPTY_BUFFER.getBuffer();
    }

    public long position() throws IOException {
        return this.channel.position() + (long)this.buffer.position();
    }

    public void position(long position) throws IOException {
        this.prepareForFlush();
        this.channel.position(position);
    }

    private ByteBuffer bufferWithGuaranteedSpace(int spaceInBytes) throws IOException {
        assert (spaceInBytes <= this.buffer.capacity());
        if (this.buffer.remaining() < spaceInBytes) {
            this.prepareForFlush();
        }
        return this.buffer;
    }

    private Flushable flushToChannel(StoreChannel destination, ByteBuffer src) throws IOException {
        try {
            destination.writeAll(src);
        }
        catch (ClosedChannelException e) {
            this.handleClosedChannelException(e);
        }
        return destination;
    }

    private void handleClosedChannelException(ClosedChannelException e) throws ClosedChannelException {
        if (this.closed) {
            throw new IllegalStateException("This log channel has been closed", e);
        }
        throw e;
    }

    @Override
    public int write(ByteBuffer src) throws IOException {
        int remaining = src.remaining();
        this.putAll(src);
        return remaining;
    }

    @Override
    public void beginChecksum() {
        this.checksum.reset();
        this.checksumView.limit(this.checksumView.capacity());
        this.checksumView.position(this.buffer.position());
    }

    @Override
    public int putChecksum() throws IOException {
        this.bufferWithGuaranteedSpace(4);
        this.checksumView.limit(this.buffer.position());
        this.checksum.update(this.checksumView);
        int calculatedChecksum = (int)this.checksum.getValue();
        this.buffer.putInt(calculatedChecksum);
        return calculatedChecksum;
    }
}

