/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl;

import com.sun.nio.file.ExtendedOpenOption;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileLock;
import java.nio.channels.OverlappingFileLockException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Set;
import org.apache.commons.lang3.SystemUtils;
import org.neo4j.internal.helpers.VarHandleUtils;
import org.neo4j.internal.nativeimpl.NativeAccess;
import org.neo4j.internal.nativeimpl.NativeAccessFactory;
import org.neo4j.internal.nativeimpl.NativeCallResult;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.fs.DefaultFileSystemAbstraction;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.OutOfDiskSpaceException;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.BlockSwapper;
import org.neo4j.io.pagecache.impl.FileLockException;
import org.neo4j.io.pagecache.impl.muninn.EvictionBouncer;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.tracing.PageFileSwapperTracer;

public class SingleFilePageSwapper
implements PageSwapper {
    private final FileSystemAbstraction fs;
    private final Path path;
    private final IOController ioController;
    private final int filePageSize;
    private final Set<OpenOption> openOptions;
    private volatile PageEvictionCallback onEviction;
    private StoreChannel channel;
    private FileLock fileLock;
    private final boolean canDoVectorizedIO;
    private final int swapperId;
    private final PageFileSwapperTracer fileSwapperTracer;
    private final BlockSwapper blockSwapper;
    private final NativeAccess nativeAccess;
    private final EvictionBouncer evictionBouncer;
    private boolean closed;
    private volatile long fileSize;
    private static final VarHandle FILE_SIZE = VarHandleUtils.getVarHandle((MethodHandles.Lookup)MethodHandles.lookup(), (String)"fileSize");

    SingleFilePageSwapper(Path path, FileSystemAbstraction fs, int filePageSize, PageEvictionCallback onEviction, boolean useDirectIO, IOController ioController, SwapperSet swapperSet, PageFileSwapperTracer fileSwapperTracer, BlockSwapper blockSwapper, NativeAccessFactory nativeAccessFactory, EvictionBouncer evictionBouncer) throws IOException {
        this.fs = fs;
        this.path = path;
        this.ioController = ioController;
        this.fileSwapperTracer = fileSwapperTracer;
        ArrayList<OpenOption> options = new ArrayList<OpenOption>(DefaultFileSystemAbstraction.WRITE_OPTIONS);
        if (useDirectIO) {
            this.validateDirectIOPossibility(path, filePageSize);
            options.add(ExtendedOpenOption.DIRECT);
        }
        this.openOptions = Set.copyOf(options);
        this.channel = this.createStoreChannel();
        this.filePageSize = filePageSize;
        this.onEviction = onEviction;
        this.increaseFileSizeTo(this.channel.size());
        try {
            this.acquireLock();
        }
        catch (IOException e) {
            try {
                this.channel.close();
            }
            catch (IOException ioe) {
                e.addSuppressed(ioe);
            }
            throw e;
        }
        this.canDoVectorizedIO = this.channel.hasPositionLock() && UnsafeUtil.unsafeByteBufferAccessAvailable();
        this.swapperId = swapperSet.allocate(this);
        this.blockSwapper = blockSwapper;
        this.nativeAccess = nativeAccessFactory.create(path);
        this.evictionBouncer = evictionBouncer;
    }

    private StoreChannel createStoreChannel() throws IOException {
        StoreChannel storeChannel = this.fs.open(this.path, this.openOptions);
        storeChannel.tryMakeUninterruptible();
        return storeChannel;
    }

    private void validateDirectIOPossibility(Path file, int filePageSize) throws IOException {
        if (!SystemUtils.IS_OS_LINUX) {
            throw new IllegalArgumentException("DirectIO support is available only on Linux.");
        }
        long blockSize = this.fs.getBlockSize(file);
        long value = (long)filePageSize / blockSize;
        if (value * blockSize != (long)filePageSize) {
            throw new IllegalArgumentException("Direct IO can be used only when page cache page size is a multiplier of a block size. File page size: " + filePageSize + ", block size: " + blockSize);
        }
    }

    private void increaseFileSizeTo(long newFileSize) {
        long currentFileSize;
        while ((currentFileSize = this.getCurrentFileSize()) < newFileSize && !FILE_SIZE.weakCompareAndSet(this, currentFileSize, newFileSize)) {
        }
    }

    private long getCurrentFileSize() {
        return FILE_SIZE.getVolatile(this);
    }

    private void setCurrentFileSize(long size) {
        FILE_SIZE.setVolatile(this, size);
    }

    private void acquireLock() throws IOException {
        if (SystemUtils.IS_OS_WINDOWS) {
            return;
        }
        try {
            this.fileLock = this.channel.tryLock();
            if (this.fileLock == null) {
                throw new FileLockException(this.path);
            }
        }
        catch (OverlappingFileLockException e) {
            throw new FileLockException(this.path, e);
        }
    }

    private int swapIn(long bufferAddress, long fileOffset, int bufferSize) throws IOException {
        int readTotal = this.blockSwapper.swapIn(this.channel, bufferAddress, fileOffset, bufferSize);
        this.ioController.reportIO(1);
        return readTotal;
    }

    private int swapOut(long bufferAddress, long fileOffset, int bufferSize, boolean countIo) throws IOException {
        this.blockSwapper.swapOut(this.channel, bufferAddress, fileOffset, bufferSize);
        if (countIo) {
            this.ioController.reportIO(1);
        }
        return bufferSize;
    }

    private static void clear(long bufferAddress, int bufferSize) {
        UnsafeUtil.setMemory((long)bufferAddress, (long)bufferSize, (byte)MuninnPageCache.ZERO_BYTE);
    }

    @Override
    public long read(long filePageId, long bufferAddress) throws IOException {
        return this.read(filePageId, bufferAddress, this.filePageSize);
    }

    @Override
    public long read(long filePageId, long bufferAddress, int bufferLength) throws IOException {
        block10: {
            Retry retry = new Retry();
            while (true) {
                try {
                    long fileOffset = this.pageIdToPosition(filePageId);
                    if (fileOffset < this.getCurrentFileSize()) {
                        long l = this.swapIn(bufferAddress, fileOffset, bufferLength);
                        return l;
                    }
                    SingleFilePageSwapper.clear(bufferAddress, bufferLength);
                    long l = 0L;
                    return l;
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                    if (retry.shouldRetry()) continue;
                    break block10;
                }
                break;
            }
            finally {
                retry.close();
            }
        }
        return -1L;
    }

    @Override
    public long read(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length) throws IOException {
        block11: {
            if (length == 0) {
                return 0L;
            }
            Retry retry = new Retry();
            while (true) {
                try {
                    if (this.canDoVectorizedIO) {
                        long l = this.readPositionedVectoredToFileChannel(startFilePageId, bufferAddresses, bufferLengths, length);
                        return l;
                    }
                    long l = this.readPositionedVectoredFallback(startFilePageId, bufferAddresses, bufferLengths, length);
                    return l;
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                    if (retry.shouldRetry()) continue;
                    break block11;
                }
                break;
            }
            finally {
                retry.close();
            }
        }
        return -1L;
    }

    private long readPositionedVectoredToFileChannel(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length) throws IOException {
        long fileOffset = this.pageIdToPosition(startFilePageId);
        long bytesToRead = SingleFilePageSwapper.countBuffersLengths(bufferLengths, length);
        ByteBuffer[] srcs = SingleFilePageSwapper.convertToByteBuffers(bufferAddresses, bufferLengths, length);
        long bytesRead = this.lockPositionReadVector(fileOffset, srcs, bytesToRead);
        if (bytesRead == -1L) {
            for (int i = 0; i < length; ++i) {
                UnsafeUtil.setMemory((long)bufferAddresses[i], (long)bufferLengths[i], (byte)MuninnPageCache.ZERO_BYTE);
            }
            return 0L;
        }
        if (bytesRead < bytesToRead) {
            long bytesToKeep = bytesRead;
            for (int bufferIndex = 0; bufferIndex < length; ++bufferIndex) {
                int bufferLength = bufferLengths[bufferIndex];
                if (bytesToKeep > (long)bufferLength) {
                    bytesToKeep = Math.subtractExact(bytesToKeep, (long)bufferLength);
                    continue;
                }
                UnsafeUtil.setMemory((long)(bufferAddresses[bufferIndex] + bytesToKeep), (long)((long)bufferLength - bytesToKeep), (byte)MuninnPageCache.ZERO_BYTE);
                bytesToKeep = 0L;
            }
        }
        return bytesRead;
    }

    private static long countBuffersLengths(int[] bufferLengths, int length) {
        long bytesToRead = 0L;
        for (int i = 0; i < length; ++i) {
            bytesToRead += (long)bufferLengths[i];
        }
        return bytesToRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lockPositionReadVector(long fileOffset, ByteBuffer[] srcs, long bytesToRead) throws IOException {
        long readTotal = 0L;
        Object object = this.channel.getPositionLock();
        synchronized (object) {
            long read;
            this.setPositionUnderLock(fileOffset);
            do {
                read = this.channel.read(srcs);
                this.ioController.reportIO(1);
            } while (read != -1L && (readTotal += read) < bytesToRead);
            return readTotal;
        }
    }

    private int readPositionedVectoredFallback(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length) throws IOException {
        int bytes = 0;
        long filePageId = startFilePageId;
        for (int i = 0; i < length; ++i) {
            long address = bufferAddresses[i];
            int bufferLength = bufferLengths[i];
            bytes = (int)((long)bytes + this.read(filePageId, address, bufferLength));
            filePageId += (long)(bufferLength / this.filePageSize);
        }
        return bytes;
    }

    @Override
    public long write(long filePageId, long bufferAddress) throws IOException {
        return this.write(filePageId, bufferAddress, this.filePageSize);
    }

    @Override
    public long write(long filePageId, long bufferAddress, int bufferLength) throws IOException {
        return this.write(filePageId, bufferAddress, bufferLength, true);
    }

    private int write(long filePageId, long bufferAddress, int bufferLength, boolean countIo) throws IOException {
        block8: {
            long fileOffset = this.pageIdToPosition(filePageId);
            this.increaseFileSizeTo(fileOffset + (long)bufferLength);
            Retry retry = new Retry();
            while (true) {
                try {
                    int n = this.swapOut(bufferAddress, fileOffset, bufferLength, countIo);
                    return n;
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                    if (retry.shouldRetry()) continue;
                    break block8;
                }
                break;
            }
            finally {
                retry.close();
            }
        }
        return -1;
    }

    @Override
    public long write(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length, int totalAffectedPages) throws IOException {
        block11: {
            if (totalAffectedPages == 0) {
                return 0L;
            }
            Retry retry = new Retry();
            while (true) {
                try {
                    if (this.canDoVectorizedIO) {
                        long l = this.writePositionedVectoredToFileChannel(startFilePageId, bufferAddresses, bufferLengths, length);
                        return l;
                    }
                    long l = this.writePositionVectoredFallback(startFilePageId, bufferAddresses, bufferLengths, length);
                    return l;
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                    if (retry.shouldRetry()) continue;
                    break block11;
                }
                break;
            }
            finally {
                retry.close();
            }
        }
        return -1L;
    }

    private long writePositionedVectoredToFileChannel(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length) throws IOException {
        long fileOffset = this.pageIdToPosition(startFilePageId);
        long bytesToWrite = SingleFilePageSwapper.countBuffersLengths(bufferLengths, length);
        this.increaseFileSizeTo(fileOffset + bytesToWrite);
        ByteBuffer[] srcs = SingleFilePageSwapper.convertToByteBuffers(bufferAddresses, bufferLengths, length);
        return this.lockPositionWriteVector(fileOffset, srcs, bytesToWrite);
    }

    private static ByteBuffer[] convertToByteBuffers(long[] bufferAddresses, int[] bufferLengths, int length) {
        ByteBuffer[] buffers = new ByteBuffer[length];
        for (int i = 0; i < length; ++i) {
            try {
                buffers[i] = UnsafeUtil.newDirectByteBuffer((long)bufferAddresses[i], (int)bufferLengths[i]);
                continue;
            }
            catch (Throwable e) {
                throw new RuntimeException("Failed to wrap pointer in ByteBuffer.", e);
            }
        }
        return buffers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long lockPositionWriteVector(long fileOffset, ByteBuffer[] srcs, long bytesToWrite) throws IOException {
        try {
            long bytesWritten = 0L;
            Object object = this.channel.getPositionLock();
            synchronized (object) {
                this.setPositionUnderLock(fileOffset);
                while ((bytesWritten += this.channel.write(srcs)) < bytesToWrite) {
                }
                return bytesWritten;
            }
        }
        catch (ClosedChannelException e) {
            this.tryReopen(e);
            throw new IOException("IO failed due to interruption", e);
        }
    }

    private void setPositionUnderLock(long fileOffset) throws IOException {
        try {
            this.channel.position(fileOffset);
        }
        catch (IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    private int writePositionVectoredFallback(long startFilePageId, long[] bufferAddresses, int[] bufferLengths, int length) throws IOException {
        int bytes = 0;
        long filePageId = startFilePageId;
        for (int i = 0; i < length; ++i) {
            long address = bufferAddresses[i];
            int bufferLength = bufferLengths[i];
            bytes += this.write(filePageId, address, bufferLength, false);
            filePageId += (long)(bufferLength / this.filePageSize);
        }
        return bytes;
    }

    @Override
    public void evicted(long pageRef, long filePageId) {
        PageEvictionCallback callback = this.onEviction;
        if (callback != null) {
            callback.onEvict(pageRef, filePageId);
        }
    }

    @Override
    public Path path() {
        return this.path;
    }

    private long pageIdToPosition(long pageId) {
        return (long)this.filePageSize * pageId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SingleFilePageSwapper that = (SingleFilePageSwapper)o;
        return this.path.equals(that.path);
    }

    public int hashCode() {
        return this.path.hashCode();
    }

    private synchronized void tryReopen(ClosedChannelException closedException) throws ClosedChannelException {
        if (this.channel.isOpen()) {
            return;
        }
        if (this.closed) {
            throw closedException;
        }
        try {
            this.channel = this.createStoreChannel();
            this.acquireLock();
        }
        catch (IOException e) {
            closedException.addSuppressed(e);
            throw closedException;
        }
    }

    @Override
    public synchronized void close() throws IOException {
        this.closed = true;
        try {
            this.channel.close();
        }
        finally {
            this.onEviction = null;
        }
    }

    @Override
    public synchronized void closeAndDelete() throws IOException {
        this.close();
        this.fs.deleteFile(this.path);
    }

    @Override
    public void force() throws IOException {
        try (Retry retry = new Retry();){
            do {
                try {
                    this.channel.force(false);
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                }
            } while (retry.shouldRetry());
        }
    }

    @Override
    public long getLastPageId() {
        long channelSize = this.getCurrentFileSize();
        if (channelSize == 0L) {
            return -1L;
        }
        long div = channelSize / (long)this.filePageSize;
        long mod = channelSize % (long)this.filePageSize;
        return mod == 0L ? div - 1L : div;
    }

    @Override
    public void truncate() throws IOException {
        this.truncate(0L);
    }

    @Override
    public void truncate(long size) throws IOException {
        this.setCurrentFileSize(size);
        try (Retry retry = new Retry();){
            do {
                try {
                    this.channel.truncate(size);
                }
                catch (ClosedChannelException e) {
                    retry.caught(e);
                }
            } while (retry.shouldRetry());
        }
    }

    @Override
    public boolean canAllocate() {
        return this.nativeAccess.isAvailable() && this.channel.getFileDescriptor() != -1;
    }

    @Override
    public void allocate(long newFileSize) throws IOException {
        NativeCallResult result;
        if (this.nativeAccess.isAvailable() && (result = this.nativeAccess.tryPreallocateSpace(this.channel.getFileDescriptor(), newFileSize)).isError()) {
            if (this.nativeAccess.errorTranslator().isOutOfDiskSpace(result)) {
                throw new OutOfDiskSpaceException("System is out of disk space for store file at: " + this.path + ". To be able to proceed please allocate more disk space for the database and restart. Requested file size: " + newFileSize + ". Call error: " + result);
            }
            throw new IOException("Fail to preallocate additional space for store file at: " + this.path + ". Requested file size: " + newFileSize + ". Call error: " + result);
        }
    }

    @Override
    public int swapperId() {
        return this.swapperId;
    }

    @Override
    public PageFileSwapperTracer fileSwapperTracer() {
        return this.fileSwapperTracer;
    }

    @Override
    public boolean isPageFlushable(long pageRef) {
        return this.evictionBouncer.allowPageFlush(pageRef);
    }

    public String toString() {
        return "SingleFilePageSwapper{filePageSize=" + this.filePageSize + ", file=" + this.path + "}";
    }

    private class Retry
    implements AutoCloseable {
        private static final int RETRIES_ON_INTERRUPTION = 10;
        private int retries = 10;
        private ClosedChannelException caughtException;
        private ClosedChannelException initialException;
        private boolean wasInterrupted;

        private Retry() {
        }

        boolean shouldRetry() throws ClosedChannelException {
            if (this.caughtException != null && --this.retries >= 0) {
                this.wasInterrupted |= Thread.interrupted();
                SingleFilePageSwapper.this.tryReopen(this.caughtException);
                this.caughtException = null;
                return true;
            }
            return false;
        }

        void caught(ClosedChannelException exception) {
            this.caughtException = exception;
            if (this.initialException == null) {
                this.initialException = this.caughtException;
            }
        }

        @Override
        public void close() throws ClosedChannelException {
            if (this.wasInterrupted) {
                Thread.currentThread().interrupt();
            }
            if (this.caughtException != null && this.caughtException != this.initialException) {
                this.initialException.addSuppressed(this.caughtException);
                throw this.initialException;
            }
        }
    }
}

