/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import org.neo4j.io.fs.FlushableChannel;
import org.neo4j.io.fs.PhysicalFlushableChannel;
import org.neo4j.io.fs.PhysicalLogChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.memory.ScopedBuffer;

public class PhysicalFlushableLogChannel
extends PhysicalFlushableChannel
implements PhysicalLogChannel {
    private long appendStartPosition;

    public PhysicalFlushableLogChannel(StoreChannel channel, ScopedBuffer scopedBuffer) {
        super(channel, scopedBuffer);
    }

    @Override
    public void setChannel(StoreChannel channel) {
        this.channel = channel;
    }

    @Override
    public void resetAppendedBytesCounter() {
        try {
            this.appendStartPosition = this.position();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public long getAppendedBytes() {
        try {
            return this.position() - this.appendStartPosition;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public FlushableChannel put(byte[] value, int length) throws IOException {
        return super.put(value, length);
    }

    @Override
    public PhysicalFlushableChannel putVersion(byte version) throws IOException {
        return super.putVersion(version);
    }

    @Override
    public PhysicalFlushableLogChannel putAll(ByteBuffer src) throws IOException {
        super.putAll(src);
        return this;
    }
}

