/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.impl.muninn.EvictionBouncer;
import org.neo4j.io.pagecache.impl.muninn.VersionStorage;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;

public interface PageCache
extends AutoCloseable {
    public static final int PAGE_SIZE = 8192;
    public static final int RESERVED_BYTES = 16;

    default public PagedFile map(Path path, int pageSize, String databaseName) throws IOException {
        return this.map(path, pageSize, databaseName, (ImmutableSet<OpenOption>)Sets.immutable.empty());
    }

    default public PagedFile map(Path path, int pageSize, String databaseName, ImmutableSet<OpenOption> openOptions) throws IOException {
        return this.map(path, pageSize, databaseName, openOptions, IOController.DISABLED, EvictionBouncer.ALWAYS_ALLOW, VersionStorage.EMPTY_STORAGE);
    }

    default public PagedFile map(Path path, int pageSize, String databaseName, ImmutableSet<OpenOption> openOptions, IOController ioController) throws IOException {
        return this.map(path, pageSize, databaseName, openOptions, ioController, EvictionBouncer.ALWAYS_ALLOW, VersionStorage.EMPTY_STORAGE);
    }

    public PagedFile map(Path var1, int var2, String var3, ImmutableSet<OpenOption> var4, IOController var5, EvictionBouncer var6, VersionStorage var7) throws IOException;

    public Optional<PagedFile> getExistingMapping(Path var1) throws IOException;

    public List<PagedFile> listExistingMappings() throws IOException;

    public void flushAndForce(DatabaseFlushEvent var1) throws IOException;

    @Override
    public void close();

    public int pageSize();

    public int pageReservedBytes(ImmutableSet<OpenOption> var1);

    public long maxCachedPages();

    public long freePages();

    public IOBufferFactory getBufferFactory();
}

