/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.StoreFileChannel;
import org.neo4j.io.fs.watcher.DefaultFileSystemWatcher;
import org.neo4j.io.fs.watcher.FileWatcher;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class DefaultFileSystemAbstraction
implements FileSystemAbstraction {
    static final String UNABLE_TO_CREATE_DIRECTORY_FORMAT = "Unable to write directory path [%s] for Neo4j store.";
    public static final Set<OpenOption> WRITE_OPTIONS = Set.of(StandardOpenOption.READ, StandardOpenOption.WRITE, StandardOpenOption.CREATE);
    private static final Set<OpenOption> READ_OPTIONS = Set.of(StandardOpenOption.READ);
    private static final Set<OpenOption> APPEND_OPTIONS = Set.of(StandardOpenOption.CREATE, StandardOpenOption.APPEND);

    @Override
    public FileWatcher fileWatcher() throws IOException {
        WatchService watchService = FileSystems.getDefault().newWatchService();
        return new DefaultFileSystemWatcher(watchService);
    }

    @Override
    public StoreFileChannel open(Path fileName, Set<OpenOption> options) throws IOException {
        FileChannel channel = FileChannel.open(fileName, options, new FileAttribute[0]);
        return this.getStoreFileChannel(channel);
    }

    @Override
    public OutputStream openAsOutputStream(Path fileName, boolean append) throws IOException {
        return new BufferedOutputStream(this.openFileOutputStream(fileName, append));
    }

    @Override
    public InputStream openAsInputStream(Path fileName) throws IOException {
        return new BufferedInputStream(this.openFileInputStream(fileName), (int)ByteUnit.kibiBytes(8L));
    }

    @Override
    public StoreFileChannel write(Path fileName) throws IOException {
        return this.open(fileName, (Set)WRITE_OPTIONS);
    }

    @Override
    public StoreFileChannel read(Path fileName) throws IOException {
        return this.open(fileName, (Set)READ_OPTIONS);
    }

    @Override
    public void mkdir(Path fileName) throws IOException {
        Files.createDirectories(fileName, new FileAttribute[0]);
    }

    @Override
    public void mkdirs(Path file) throws IOException {
        if (Files.exists(file, new LinkOption[0]) && Files.isDirectory(file, new LinkOption[0])) {
            return;
        }
        try {
            Files.createDirectories(file, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IOException(String.format(UNABLE_TO_CREATE_DIRECTORY_FORMAT, file), e);
        }
    }

    @Override
    public boolean fileExists(Path file) {
        return Files.exists(file, new LinkOption[0]);
    }

    @Override
    public long getFileSize(Path file) throws IOException {
        return Files.size(file);
    }

    @Override
    public long getBlockSize(Path file) throws IOException {
        return FileUtils.blockSize(file);
    }

    @Override
    public void deleteFile(Path fileName) throws IOException {
        FileUtils.deleteFile(fileName);
    }

    @Override
    public void deleteRecursively(Path directory) throws IOException {
        FileUtils.deleteDirectory(directory);
    }

    @Override
    public void deleteRecursively(Path directory, Predicate<Path> removeFilePredicate) throws IOException {
        FileUtils.deleteDirectory(directory, removeFilePredicate);
    }

    @Override
    public void renameFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        Files.move(from, to, copyOptions);
    }

    @Override
    public Path[] listFiles(Path directory) throws IOException {
        try (Stream<Path> list = Files.list(directory);){
            Path[] pathArray = (Path[])list.toArray(Path[]::new);
            return pathArray;
        }
    }

    @Override
    public Path[] listFiles(Path directory, DirectoryStream.Filter<Path> filter) throws IOException {
        try (DirectoryStream<Path> paths = Files.newDirectoryStream(directory, filter);){
            Path[] pathArray = (Path[])StreamSupport.stream(paths.spliterator(), false).toArray(Path[]::new);
            return pathArray;
        }
    }

    @Override
    public boolean isDirectory(Path file) {
        return Files.isDirectory(file, new LinkOption[0]);
    }

    @Override
    public void moveToDirectory(Path file, Path toDirectory) throws IOException {
        FileUtils.moveFileToDirectory(file, toDirectory);
    }

    @Override
    public void copyToDirectory(Path file, Path toDirectory) throws IOException {
        FileUtils.copyFileToDirectory(file, toDirectory);
    }

    @Override
    public void copyFile(Path from, Path to) throws IOException {
        FileUtils.copyFile(from, to);
    }

    @Override
    public void copyFile(Path from, Path to, CopyOption ... copyOptions) throws IOException {
        FileUtils.copyFile(from, to, copyOptions);
    }

    @Override
    public void copyRecursively(Path fromDirectory, Path toDirectory) throws IOException {
        FileUtils.copyDirectory(fromDirectory, toDirectory);
    }

    @Override
    public void truncate(Path path, long size) throws IOException {
        FileUtils.truncateFile(path, size);
    }

    @Override
    public long lastModifiedTime(Path file) throws IOException {
        return Files.getLastModifiedTime(file, new LinkOption[0]).toMillis();
    }

    @Override
    public void deleteFileOrThrow(Path file) throws IOException {
        Files.delete(file);
    }

    @Override
    public int getFileDescriptor(StoreChannel channel) {
        return channel.getFileDescriptor();
    }

    @Override
    public boolean isPersistent() {
        return true;
    }

    @Override
    public Path createTempFile(String prefix, String suffix) throws IOException {
        return Files.createTempFile(prefix, suffix, new FileAttribute[0]);
    }

    @Override
    public Path createTempFile(Path dir, String prefix, String suffix) throws IOException {
        return Files.createTempFile(dir, prefix, suffix, new FileAttribute[0]);
    }

    @Override
    public Path createTempDirectory(String prefix) throws IOException {
        return Files.createTempDirectory(prefix, new FileAttribute[0]);
    }

    @Override
    public Path createTempDirectory(Path dir, String prefix) throws IOException {
        return Files.createTempDirectory(dir, prefix, new FileAttribute[0]);
    }

    @Override
    public void close() {
    }

    protected StoreFileChannel getStoreFileChannel(FileChannel channel) {
        return new StoreFileChannel(channel);
    }

    private InputStream openFileInputStream(Path path) throws IOException {
        FileChannel channel = FileChannel.open(path, READ_OPTIONS, new FileAttribute[0]);
        StoreFileChannel fileChannel = this.getStoreFileChannel(channel);
        fileChannel.tryMakeUninterruptible();
        return new NativeByteBufferInputStream(fileChannel);
    }

    private OutputStream openFileOutputStream(Path path, boolean append) throws IOException {
        FileChannel channel = FileChannel.open(path, append ? APPEND_OPTIONS : WRITE_OPTIONS, new FileAttribute[0]);
        StoreFileChannel fileChannel = this.getStoreFileChannel(channel);
        fileChannel.tryMakeUninterruptible();
        return new NativeByteBufferOutputStream(fileChannel);
    }

    private static class NativeByteBufferInputStream
    extends InputStream {
        private final StoreFileChannel fileChannel;
        private final ByteBuffer buffer;
        private final NativeScopedBuffer scopedBuffer;

        public NativeByteBufferInputStream(StoreFileChannel fileChannel) {
            this.fileChannel = fileChannel;
            this.scopedBuffer = new NativeScopedBuffer((int)ByteUnit.kibiBytes(8L), ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.buffer = this.scopedBuffer.getBuffer();
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            int readData;
            this.buffer.clear();
            if (len < this.buffer.capacity()) {
                this.buffer.limit(len);
            }
            if ((readData = this.fileChannel.read(this.buffer)) == -1) {
                return -1;
            }
            this.buffer.flip();
            this.buffer.get(b, off, readData);
            return readData;
        }

        @Override
        public int read() throws IOException {
            throw new UnsupportedOperationException("All stream operations should be buffer based.");
        }

        @Override
        public void close() throws IOException {
            this.fileChannel.close();
            this.scopedBuffer.close();
            super.close();
        }
    }

    @VisibleForTesting
    static class NativeByteBufferOutputStream
    extends OutputStream {
        private final StoreFileChannel fileChannel;
        private final ByteBuffer buffer;
        private final NativeScopedBuffer scopedBuffer;

        public NativeByteBufferOutputStream(StoreFileChannel fileChannel) {
            this.fileChannel = fileChannel;
            this.scopedBuffer = new NativeScopedBuffer((int)ByteUnit.kibiBytes(8L), ByteOrder.LITTLE_ENDIAN, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
            this.buffer = this.scopedBuffer.getBuffer();
        }

        @Override
        public void write(int b) throws IOException {
            throw new UnsupportedOperationException("All stream operations should be buffer based.");
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            int length;
            for (int offset = off; offset < off + len; offset += length) {
                length = Math.min(len - offset, this.buffer.capacity());
                this.buffer.clear();
                this.buffer.put(b, offset, length);
                this.buffer.flip();
                this.fileChannel.writeAll(this.buffer);
            }
        }

        @Override
        public void close() throws IOException {
            this.fileChannel.close();
            this.scopedBuffer.close();
            super.close();
        }
    }
}

