/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.tracing;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.LongAdder;
import org.neo4j.internal.helpers.MathUtil;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.DatabaseFlushEvent;
import org.neo4j.io.pagecache.tracing.DefaultPageFileSwapperTracer;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FileFlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFileSwapperTracer;
import org.neo4j.io.pagecache.tracing.PageReferenceTranslator;
import org.neo4j.io.pagecache.tracing.cursor.DefaultPageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;

public class DefaultPageCacheTracer
implements PageCacheTracer {
    protected final LongAdder faults = new LongAdder();
    protected final LongAdder noFaults = new LongAdder();
    protected final LongAdder failedFaults = new LongAdder();
    protected final LongAdder vectoredFaults = new LongAdder();
    protected final LongAdder failedVectoredFaults = new LongAdder();
    protected final LongAdder noPinFaults = new LongAdder();
    protected final LongAdder evictions = new LongAdder();
    protected final LongAdder cooperativeEvictions = new LongAdder();
    protected final LongAdder pins = new LongAdder();
    protected final LongAdder unpins = new LongAdder();
    protected final LongAdder hits = new LongAdder();
    protected final LongAdder flushes = new LongAdder();
    protected final LongAdder merges = new LongAdder();
    protected final LongAdder bytesRead = new LongAdder();
    protected final LongAdder bytesWritten = new LongAdder();
    protected final LongAdder bytesTruncated = new LongAdder();
    protected final LongAdder filesMapped = new LongAdder();
    protected final LongAdder filesUnmapped = new LongAdder();
    protected final LongAdder fileTruncations = new LongAdder();
    protected final LongAdder evictionExceptions = new LongAdder();
    protected final LongAdder iopqPerformed = new LongAdder();
    protected final LongAdder globalLimitTimes = new LongAdder();
    protected final LongAdder globalLimitedMillis = new LongAdder();
    protected final LongAdder openedCursors = new LongAdder();
    protected final LongAdder closedCursors = new LongAdder();
    protected final LongAdder copiedPages = new LongAdder();
    protected final LongAdder snapshotsLoaded = new LongAdder();
    protected final AtomicLong maxPages = new AtomicLong();
    private final boolean tracePageFileIndividually;
    private final EvictionEvent evictionEvent = new PageCacheEvictionEvent();
    private final EvictionRunEvent evictionRunEvent = new DefaultEvictionRunEvent();
    private final DatabaseFlushEvent databaseFlushEvent = new DatabaseFlushEvent(new DefaultPageCacheFileFlushEvent());

    public DefaultPageCacheTracer() {
        this(false);
    }

    public DefaultPageCacheTracer(boolean tracePageFileIndividually) {
        this.tracePageFileIndividually = tracePageFileIndividually;
    }

    @Override
    public PageFileSwapperTracer createFileSwapperTracer() {
        return this.tracePageFileIndividually ? new DefaultPageFileSwapperTracer() : PageFileSwapperTracer.NULL;
    }

    @Override
    public PageCursorTracer createPageCursorTracer(String tag) {
        return new DefaultPageCursorTracer(this, tag);
    }

    @Override
    public void mappedFile(int swapperId, PagedFile mappedFile) {
        this.filesMapped.increment();
    }

    @Override
    public void unmappedFile(int swapperId, PagedFile mappedFile) {
        this.filesUnmapped.increment();
    }

    @Override
    public EvictionRunEvent beginPageEvictions(int pageCountToEvict) {
        return this.evictionRunEvent;
    }

    @Override
    public EvictionRunEvent beginEviction() {
        return this.evictionRunEvent;
    }

    @Override
    public FileFlushEvent beginFileFlush(PageSwapper swapper) {
        return new DefaultPageCacheFileFlushEvent();
    }

    @Override
    public FileFlushEvent beginFileFlush() {
        return new DefaultPageCacheFileFlushEvent();
    }

    @Override
    public DatabaseFlushEvent beginDatabaseFlush() {
        return this.databaseFlushEvent;
    }

    @Override
    public long faults() {
        return this.faults.sum();
    }

    @Override
    public long failedFaults() {
        return this.failedFaults.sum();
    }

    @Override
    public long noFaults() {
        return this.noFaults.sum();
    }

    @Override
    public long vectoredFaults() {
        return this.vectoredFaults.sum();
    }

    @Override
    public long failedVectoredFaults() {
        return this.failedVectoredFaults.sum();
    }

    @Override
    public long noPinFaults() {
        return this.noPinFaults.sum();
    }

    @Override
    public long evictions() {
        return this.evictions.sum();
    }

    @Override
    public long cooperativeEvictions() {
        return this.cooperativeEvictions.sum();
    }

    @Override
    public long pins() {
        return this.pins.sum();
    }

    @Override
    public long unpins() {
        return this.unpins.sum();
    }

    @Override
    public long hits() {
        return this.hits.sum();
    }

    @Override
    public long flushes() {
        return this.flushes.sum();
    }

    @Override
    public long merges() {
        return this.merges.sum();
    }

    @Override
    public long bytesRead() {
        return this.bytesRead.sum();
    }

    @Override
    public long bytesWritten() {
        return this.bytesWritten.sum();
    }

    @Override
    public long bytesTruncated() {
        return this.bytesTruncated.sum();
    }

    @Override
    public long filesMapped() {
        return this.filesMapped.sum();
    }

    @Override
    public long filesUnmapped() {
        return this.filesUnmapped.sum();
    }

    @Override
    public long filesTruncated() {
        return this.fileTruncations.sum();
    }

    @Override
    public long evictionExceptions() {
        return this.evictionExceptions.sum();
    }

    @Override
    public double hitRatio() {
        return MathUtil.portion((double[])new double[]{this.hits(), this.faults() - this.noPinFaults()});
    }

    @Override
    public double usageRatio() {
        long pages = this.maxPages();
        if (pages == 0L) {
            return 0.0;
        }
        return Math.max(0.0, (double)(this.faults.sum() - this.evictions.sum()) / (double)pages);
    }

    @Override
    public long maxPages() {
        return this.maxPages.get();
    }

    @Override
    public long iopqPerformed() {
        return this.iopqPerformed.sum();
    }

    @Override
    public long ioLimitedTimes() {
        return this.globalLimitTimes.sum();
    }

    @Override
    public long ioLimitedMillis() {
        return this.globalLimitedMillis.sum();
    }

    @Override
    public long openedCursors() {
        return this.openedCursors.sum();
    }

    @Override
    public long closedCursors() {
        return this.closedCursors.sum();
    }

    @Override
    public long copiedPages() {
        return this.copiedPages.sum();
    }

    @Override
    public long snapshotsLoaded() {
        return this.snapshotsLoaded.sum();
    }

    @Override
    public void iopq(long iopq) {
        this.iopqPerformed.add(iopq);
    }

    @Override
    public void limitIO(long millis) {
        this.globalLimitTimes.increment();
        this.globalLimitedMillis.add(millis);
    }

    @Override
    public void pagesCopied(long copiesCreated) {
        this.copiedPages.add(copiesCreated);
    }

    @Override
    public void filesTruncated(long truncatedFiles) {
        this.fileTruncations.add(truncatedFiles);
    }

    @Override
    public void bytesTruncated(long bytesTruncated) {
        this.bytesTruncated.add(bytesTruncated);
    }

    @Override
    public void openedCursors(long openedCursors) {
        this.openedCursors.add(openedCursors);
    }

    @Override
    public void closedCursors(long closedCursors) {
        this.closedCursors.add(closedCursors);
    }

    @Override
    public void pins(long pins) {
        this.pins.add(pins);
    }

    @Override
    public void unpins(long unpins) {
        this.unpins.add(unpins);
    }

    @Override
    public void hits(long hits) {
        this.hits.add(hits);
    }

    @Override
    public void faults(long faults) {
        this.faults.add(faults);
    }

    @Override
    public void snapshotsLoaded(long snapshotsLoaded) {
        this.snapshotsLoaded.add(snapshotsLoaded);
    }

    @Override
    public void noFaults(long noFaults) {
        this.noFaults.add(noFaults);
    }

    @Override
    public void failedFaults(long failedFaults) {
        this.failedFaults.add(failedFaults);
    }

    @Override
    public void vectoredFaults(long faults) {
        this.vectoredFaults.add(faults);
    }

    @Override
    public void failedVectoredFaults(long failedFaults) {
        this.failedVectoredFaults.add(failedFaults);
    }

    @Override
    public void noPinFaults(long faults) {
        this.noPinFaults.add(faults);
    }

    @Override
    public void bytesRead(long bytesRead) {
        this.bytesRead.add(bytesRead);
    }

    @Override
    public void evictions(long evictions) {
        this.evictions.add(evictions);
    }

    @Override
    public void cooperativeEvictions(long evictions) {
        this.cooperativeEvictions.add(evictions);
    }

    @Override
    public void evictionExceptions(long evictionExceptions) {
        this.evictionExceptions.add(evictionExceptions);
    }

    @Override
    public void bytesWritten(long bytesWritten) {
        this.bytesWritten.add(bytesWritten);
    }

    @Override
    public void flushes(long flushes) {
        this.flushes.add(flushes);
    }

    @Override
    public void merges(long merges) {
        this.merges.add(merges);
    }

    @Override
    public void maxPages(long maxPages, long pageSize) {
        this.maxPages.set(maxPages);
    }

    private class PageCacheEvictionEvent
    implements EvictionEvent {
        private PageFileSwapperTracer swapperTracer;
        private final PageCacheFlushEvent flushEvent;

        private PageCacheEvictionEvent() {
            this.flushEvent = new PageCacheFlushEvent();
        }

        @Override
        public void setFilePageId(long filePageId) {
        }

        @Override
        public void setSwapper(PageSwapper swapper) {
            this.swapperTracer = swapper.fileSwapperTracer();
        }

        @Override
        public FlushEvent beginFlush(long pageRef, PageSwapper swapper, PageReferenceTranslator pageReferenceTranslator) {
            this.flushEvent.swapperTracer = swapper.fileSwapperTracer();
            return this.flushEvent;
        }

        @Override
        public void setException(IOException exception) {
            DefaultPageCacheTracer.this.evictionExceptions.increment();
            this.swapperTracer.evictionExceptions(1L);
        }

        @Override
        public void close() {
            DefaultPageCacheTracer.this.evictions.increment();
            if (this.swapperTracer != null) {
                this.swapperTracer.evictions(1L);
            }
        }
    }

    private class DefaultEvictionRunEvent
    implements EvictionRunEvent {
        private DefaultEvictionRunEvent() {
        }

        @Override
        public void freeListSize(int size) {
        }

        @Override
        public EvictionEvent beginEviction(long cachePageId) {
            return DefaultPageCacheTracer.this.evictionEvent;
        }

        @Override
        public void close() {
        }
    }

    public class DefaultPageCacheFileFlushEvent
    implements FileFlushEvent {
        private final PageCacheFlushEvent flushEvent;
        private long ioPerformed;
        private long limitTimes;
        private long limitMillis;

        public DefaultPageCacheFileFlushEvent() {
            this.flushEvent = new PageCacheFlushEvent();
        }

        @Override
        public void reset() {
            this.ioPerformed = 0L;
            this.limitTimes = 0L;
            this.limitMillis = 0L;
            this.flushEvent.reset();
        }

        @Override
        public FlushEvent beginFlush(long[] pageRefs, PageSwapper swapper, PageReferenceTranslator pageReferenceTranslator, int pagesToFlush, int mergedPages) {
            this.flushEvent.swapperTracer = swapper.fileSwapperTracer();
            return this.flushEvent;
        }

        @Override
        public FlushEvent beginFlush(long pageRef, PageSwapper swapper, PageReferenceTranslator pageReferenceTranslator) {
            this.flushEvent.swapperTracer = swapper.fileSwapperTracer();
            return this.flushEvent;
        }

        @Override
        public void startFlush(int[][] translationTable) {
        }

        @Override
        public FileFlushEvent.ChunkEvent startChunk(int[] chunk) {
            return FileFlushEvent.ChunkEvent.NULL;
        }

        @Override
        public void throttle(long recentlyCompletedIOs, long millis) {
            ++this.limitTimes;
            this.limitMillis += millis;
            DefaultPageCacheTracer.this.globalLimitTimes.add(1L);
            DefaultPageCacheTracer.this.globalLimitedMillis.add(millis);
        }

        @Override
        public void reportIO(int completedIOs) {
            this.ioPerformed += (long)completedIOs;
            DefaultPageCacheTracer.this.iopqPerformed.add(completedIOs);
        }

        @Override
        public long localBytesWritten() {
            return this.flushEvent.getLocalBytesWritten();
        }

        @Override
        public long ioPerformed() {
            return this.ioPerformed;
        }

        @Override
        public long limitedNumberOfTimes() {
            return this.limitTimes;
        }

        @Override
        public long limitedMillis() {
            return this.limitMillis;
        }

        @Override
        public long pagesFlushed() {
            return this.flushEvent.getPagesFlushed();
        }

        @Override
        public void close() {
        }
    }

    private class PageCacheFlushEvent
    implements FlushEvent {
        private PageFileSwapperTracer swapperTracer;
        private long pagesFlushed;
        private final LongAdder localBytesWritten = new LongAdder();

        private PageCacheFlushEvent() {
        }

        @Override
        public void addBytesWritten(long bytes) {
            DefaultPageCacheTracer.this.bytesWritten.add(bytes);
            this.localBytesWritten.add(bytes);
            this.swapperTracer.bytesWritten(bytes);
        }

        public void reset() {
            this.pagesFlushed = 0L;
        }

        @Override
        public void close() {
        }

        @Override
        public void setException(IOException exception) {
        }

        @Override
        public void addPagesFlushed(int pageCount) {
            this.pagesFlushed += (long)pageCount;
            DefaultPageCacheTracer.this.flushes.add(pageCount);
            this.swapperTracer.flushes(pageCount);
        }

        @Override
        public void addPagesMerged(int pagesMerged) {
            DefaultPageCacheTracer.this.merges.add(pagesMerged);
            this.swapperTracer.merges(pagesMerged);
        }

        public long getLocalBytesWritten() {
            return this.localBytesWritten.longValue();
        }

        public long getPagesFlushed() {
            return this.pagesFlushed;
        }
    }
}

