/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.bufferpool.impl;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Deque;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.IntStream;
import org.neo4j.io.memory.ByteBuffers;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

class Bucket {
    private final int bufferCapacity;
    private final Slice[] slices;
    private final MemoryTracker memoryTracker;
    private final AtomicLong currentTick = new AtomicLong();

    Bucket(int bufferCapacity, int sliceCount, MemoryTracker memoryTracker) {
        this.bufferCapacity = bufferCapacity;
        this.memoryTracker = memoryTracker;
        this.slices = (Slice[])IntStream.range(0, sliceCount).mapToObj(i -> new Slice()).toArray(Slice[]::new);
    }

    ByteBuffer acquire() {
        Slice slice = this.getSlice();
        IdleBuffer idleBuffer = slice.stack.pollFirst();
        if (idleBuffer != null) {
            return idleBuffer.byteBuffer;
        }
        return ByteBuffers.allocateDirect(this.bufferCapacity, ByteOrder.BIG_ENDIAN, this.memoryTracker);
    }

    void release(ByteBuffer buffer) {
        IdleBuffer idleBuffer = new IdleBuffer(buffer, this.currentTick.get());
        Slice slice = this.getSlice();
        slice.stack.offerFirst(idleBuffer);
    }

    int getBufferCapacity() {
        return this.bufferCapacity;
    }

    void prunePooledBuffers() {
        long previousTick = this.currentTick.getAndIncrement();
        block0: for (Slice slice : this.slices) {
            IdleBuffer idleBuffer;
            while ((idleBuffer = slice.stack.pollLast()) != null) {
                if (idleBuffer.lastUsedTick >= previousTick) {
                    slice.stack.offerLast(idleBuffer);
                    continue block0;
                }
                ByteBuffers.releaseBuffer(idleBuffer.byteBuffer, this.memoryTracker);
            }
        }
    }

    void releasePooledBuffers() {
        for (Slice slice : this.slices) {
            IdleBuffer idleBuffer;
            while ((idleBuffer = slice.stack.pollFirst()) != null) {
                ByteBuffers.releaseBuffer(idleBuffer.byteBuffer, this.memoryTracker);
            }
        }
    }

    private Slice getSlice() {
        if (this.slices.length == 1) {
            return this.slices[0];
        }
        return this.slices[ThreadLocalRandom.current().nextInt(this.slices.length)];
    }

    @VisibleForTesting
    List<Slice> getSlices() {
        return Arrays.asList(this.slices);
    }

    private static class Slice {
        private final Deque<IdleBuffer> stack = new ConcurrentLinkedDeque<IdleBuffer>();

        private Slice() {
        }
    }

    private record IdleBuffer(ByteBuffer byteBuffer, long lastUsedTick) {
    }
}

