/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.Flushable;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.channels.ClosedChannelException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.pagecache.IOController;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.buffer.IOBufferFactory;
import org.neo4j.io.pagecache.buffer.NativeIOBuffer;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.FileIsNotMappedException;
import org.neo4j.io.pagecache.impl.muninn.CursorFactory;
import org.neo4j.io.pagecache.impl.muninn.LatchMap;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.monitoring.PageFileCounters;
import org.neo4j.io.pagecache.tracing.EvictionRunEvent;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.util.FeatureToggles;

final class MuninnPagedFile
extends PageList
implements PagedFile,
Flushable {
    static final int UNMAPPED_TTE = -1;
    private static final boolean mergePagesOnFlush = FeatureToggles.flag(MuninnPagedFile.class, (String)"mergePagesOnFlush", (boolean)true);
    private static final int maxChunkGrowth = FeatureToggles.getInteger(MuninnPagedFile.class, (String)"maxChunkGrowth", (int)16);
    private static final int translationTableChunkSizePower = FeatureToggles.getInteger(MuninnPagedFile.class, (String)"translationTableChunkSizePower", (int)12);
    private static final int translationTableChunkSize = 1 << translationTableChunkSizePower;
    private static final long translationTableChunkSizeMask = translationTableChunkSize - 1;
    private static final int headerStateRefCountShift = 48;
    private static final int headerStateRefCountMax = Short.MAX_VALUE;
    private static final long headerStateRefCountMask = 0x7FFF000000000000L;
    private static final long headerStateLastPageIdMask = -9223090561878065153L;
    private static final int PF_LOCK_MASK = 3;
    final MuninnPageCache pageCache;
    final int filePageSize;
    private final PageCacheTracer pageCacheTracer;
    private final IOBufferFactory bufferFactory;
    final LatchMap pageFaultLatches;
    static final VarHandle TRANSLATION_TABLE_ARRAY;
    volatile int[][] translationTable;
    final PageSwapper swapper;
    final int swapperId;
    private final CursorFactory cursorFactory;
    final String databaseName;
    private final IOController ioController;
    private volatile boolean deleteOnClose;
    private volatile Exception closeStackTrace;
    private volatile long highestEvictedTransactionId;
    private static final VarHandle HIGHEST_EVICTED_TRANSACTION_ID;
    private volatile long headerState;
    private static final VarHandle HEADER_STATE;

    MuninnPagedFile(Path path, MuninnPageCache pageCache, int filePageSize, PageSwapperFactory swapperFactory, PageCacheTracer pageCacheTracer, boolean createIfNotExists, boolean truncateExisting, boolean useDirectIo, boolean preallocateStoreFiles, String databaseName, int faultLockStriping, IOController ioController) throws IOException {
        super(pageCache.pages);
        this.pageCache = pageCache;
        this.filePageSize = filePageSize;
        this.cursorFactory = new CursorFactory(this);
        this.pageCacheTracer = pageCacheTracer;
        this.pageFaultLatches = new LatchMap(faultLockStriping);
        this.bufferFactory = pageCache.getBufferFactory();
        this.databaseName = Objects.requireNonNull(databaseName);
        this.ioController = Objects.requireNonNull(ioController);
        PageEvictionCallback onEviction = this::evictPage;
        this.swapper = swapperFactory.createPageSwapper(path, filePageSize, onEviction, createIfNotExists, useDirectIo, preallocateStoreFiles, ioController, this.getSwappers());
        if (truncateExisting) {
            this.swapper.truncate();
        }
        long lastPageId = this.swapper.getLastPageId();
        int initialChunks = Math.max(1 + MuninnPagedFile.computeChunkId(lastPageId), 1);
        int[][] tt = new int[initialChunks][];
        for (int i = 0; i < initialChunks; ++i) {
            tt[i] = MuninnPagedFile.newChunk();
        }
        this.translationTable = tt;
        this.initialiseLastPageId(lastPageId);
        this.swapperId = this.swapper.swapperId();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.swapper.path() + ", reference count = " + this.getRefCount() + "]";
    }

    @Override
    public PageCursor io(long pageId, int pf_flags, CursorContext context) {
        MuninnPageCursor cursor;
        int lockFlags = pf_flags & 3;
        if (lockFlags == 1) {
            cursor = this.cursorFactory.takeReadCursor(pageId, pf_flags, context);
        } else if (lockFlags == 2) {
            cursor = this.cursorFactory.takeWriteCursor(pageId, pf_flags, context);
        } else {
            throw MuninnPagedFile.wrongLocksArgument(lockFlags);
        }
        this.pageCacheTracer.openCursor();
        cursor.rewind();
        if ((pf_flags & 8) == 8 && (pf_flags & 0x10) != 16) {
            this.pageCache.startPreFetching(cursor, this.cursorFactory);
        }
        return cursor;
    }

    private static IllegalArgumentException wrongLocksArgument(int lockFlags) {
        if (lockFlags == 0) {
            return new IllegalArgumentException("Must specify either PF_SHARED_WRITE_LOCK or PF_SHARED_READ_LOCK");
        }
        return new IllegalArgumentException("Cannot specify both PF_SHARED_WRITE_LOCK and PF_SHARED_READ_LOCK");
    }

    @Override
    public int pageSize() {
        return this.filePageSize;
    }

    @Override
    public long fileSize() throws FileIsNotMappedException {
        long lastPageId = this.getLastPageId();
        if (lastPageId < 0L) {
            return 0L;
        }
        return (lastPageId + 1L) * (long)this.pageSize();
    }

    @Override
    public Path path() {
        return this.swapper.path();
    }

    @Override
    public void close() {
        this.pageCache.unmap(this);
    }

    void closeSwapper() throws IOException {
        this.closeStackTrace = new Exception("tracing paged file closing");
        this.evictPages();
        if (!this.deleteOnClose) {
            this.swapper.close();
        } else {
            this.swapper.closeAndDelete();
        }
        this.pageCache.sweep(this.getSwappers());
    }

    private void evictPages() throws IOException {
        long totalPages = 0L;
        long evictedPages = 0L;
        PageList pages = this.pageCache.pages;
        try (EvictionRunEvent evictionEvent = this.pageCacheTracer.beginEviction();){
            int[][] tt;
            long filePageId = -1L;
            for (int[] chunk : tt = this.translationTable) {
                for (int i = 0; i < chunk.length; ++i) {
                    int chunkIndex;
                    int pageId;
                    if ((pageId = TRANSLATION_TABLE_ARRAY.getVolatile(chunk, chunkIndex = MuninnPagedFile.computeChunkIndex(++filePageId))) == -1) continue;
                    long pageRef = this.deref(pageId);
                    if (PageList.isLoaded(pageRef)) {
                        if (PageList.decrementUsage(pageRef) && pages.tryEvict(pageRef, evictionEvent)) {
                            this.pageCache.addFreePageToFreelist(pageRef, evictionEvent);
                            ++evictedPages;
                        }
                        ++totalPages;
                    }
                    TRANSLATION_TABLE_ARRAY.setVolatile(chunk, chunkIndex, -1);
                }
            }
        }
        SwapperSet swappers = this.getSwappers();
        if (totalPages == evictedPages) {
            swappers.free(this.swapperId);
        } else {
            swappers.postponedFree(this.swapperId);
        }
    }

    @Override
    public void flushAndForce() throws IOException {
        try (MajorFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush(this.swapper);
             NativeIOBuffer buffer = this.bufferFactory.createBuffer();){
            this.flushAndForceInternal(flushEvent, false, this.ioController, buffer);
        }
        this.pageCache.clearEvictorException();
    }

    void flushAndForceForClose() throws IOException {
        if (this.deleteOnClose) {
            this.markAllDirtyPagesAsClean();
            return;
        }
        try (MajorFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush(this.swapper);
             NativeIOBuffer buffer = this.bufferFactory.createBuffer();){
            this.flushAndForceInternal(flushEvent, true, IOController.DISABLED, buffer);
        }
        this.pageCache.clearEvictorException();
    }

    private void markAllDirtyPagesAsClean() {
        int[][] tt;
        long filePageId = -1L;
        for (int[] chunk : tt = this.translationTable) {
            block1: for (int i = 0; i < chunk.length; ++i) {
                int pageId;
                int chunkIndex = MuninnPagedFile.computeChunkIndex(++filePageId);
                while ((pageId = TRANSLATION_TABLE_ARRAY.getVolatile(chunk, chunkIndex)) != -1) {
                    long pageRef = this.deref(pageId);
                    long stamp = MuninnPagedFile.tryOptimisticReadLock(pageRef);
                    if (!MuninnPagedFile.isModified(pageRef) && MuninnPagedFile.validateReadLock(pageRef, stamp)) continue block1;
                    if (!MuninnPagedFile.tryExclusiveLock(pageRef)) continue;
                    if (!MuninnPagedFile.isBoundTo(pageRef, this.swapperId, filePageId) || !MuninnPagedFile.isModified(pageRef)) continue block1;
                    MuninnPagedFile.explicitlyMarkPageUnmodifiedUnderExclusiveLock(pageRef);
                    MuninnPagedFile.unlockExclusive(pageRef);
                    continue block1;
                }
            }
        }
    }

    void flushAndForceInternal(MajorFlushEvent flushEvent, boolean forClosing, IOController limiter, NativeIOBuffer ioBuffer) throws IOException {
        block2: {
            try {
                this.doFlushAndForceInternal(flushEvent, forClosing, limiter, ioBuffer);
            }
            catch (ClosedChannelException e) {
                if (this.getRefCount() <= 0) break block2;
                e.addSuppressed(this.closeStackTrace);
                throw e;
            }
        }
    }

    private void doFlushAndForceInternal(MajorFlushEvent flushes, boolean forClosing, IOController limiter, NativeIOBuffer ioBuffer) throws IOException {
        long[] pages = new long[translationTableChunkSize];
        long[] flushStamps = forClosing ? null : new long[translationTableChunkSize];
        long[] bufferAddresses = new long[translationTableChunkSize];
        int[] bufferLengths = new int[translationTableChunkSize];
        long filePageId = -1L;
        int[][] tt = this.translationTable;
        boolean useTemporaryBuffer = ioBuffer.isEnabled();
        flushes.startFlush(tt);
        for (int[] chunk : tt) {
            MajorFlushEvent.ChunkEvent chunkEvent = flushes.startChunk(chunk);
            long notModifiedPages = 0L;
            long flushPerChunk = 0L;
            long buffersPerChunk = 0L;
            long mergesPerChunk = 0L;
            int pagesGrabbed = 0;
            long nextSequentialAddress = -1L;
            int numberOfBuffers = 0;
            int lastBufferIndex = -1;
            int mergedPages = 0;
            boolean fillingDirtyBuffer = false;
            if (useTemporaryBuffer) {
                bufferAddresses[0] = ioBuffer.getAddress();
                bufferLengths[0] = 0;
                buffersPerChunk = 1L;
            }
            block1: for (int i = 0; i < chunk.length; ++i) {
                int pageId;
                int chunkIndex = MuninnPagedFile.computeChunkIndex(++filePageId);
                while ((pageId = TRANSLATION_TABLE_ARRAY.getVolatile(chunk, chunkIndex)) != -1) {
                    long pageRef = this.deref(pageId);
                    long stamp = MuninnPagedFile.tryOptimisticReadLock(pageRef);
                    if (!MuninnPagedFile.isModified(pageRef) && !fillingDirtyBuffer && MuninnPagedFile.validateReadLock(pageRef, stamp)) {
                        ++notModifiedPages;
                        break;
                    }
                    long flushStamp = 0L;
                    if (!(forClosing ? MuninnPagedFile.tryExclusiveLock(pageRef) : (flushStamp = MuninnPagedFile.tryFlushLock(pageRef)) != 0L)) continue;
                    if (MuninnPagedFile.isBoundTo(pageRef, this.swapperId, filePageId) && (MuninnPagedFile.isModified(pageRef) || fillingDirtyBuffer)) {
                        fillingDirtyBuffer = useTemporaryBuffer;
                        pages[pagesGrabbed] = pageRef;
                        if (!forClosing) {
                            flushStamps[pagesGrabbed] = flushStamp;
                        }
                        ++pagesGrabbed;
                        long address = MuninnPagedFile.getAddress(pageRef);
                        if (useTemporaryBuffer) {
                            UnsafeUtil.copyMemory((long)address, (long)(bufferAddresses[0] + (long)bufferLengths[0]), (long)this.filePageSize);
                            bufferLengths[0] = bufferLengths[0] + this.filePageSize;
                            numberOfBuffers = 1;
                            if (ioBuffer.hasMoreCapacity(bufferLengths[0], this.filePageSize)) continue block1;
                            break;
                        }
                        if (mergePagesOnFlush && nextSequentialAddress == address) {
                            int n = lastBufferIndex;
                            bufferLengths[n] = bufferLengths[n] + this.filePageSize;
                            ++mergedPages;
                            ++mergesPerChunk;
                        } else {
                            bufferAddresses[numberOfBuffers] = address;
                            lastBufferIndex = numberOfBuffers;
                            bufferLengths[numberOfBuffers] = this.filePageSize;
                            ++numberOfBuffers;
                            ++buffersPerChunk;
                        }
                        nextSequentialAddress = address + (long)this.filePageSize;
                        continue block1;
                    }
                    if (forClosing) {
                        MuninnPagedFile.unlockExclusive(pageRef);
                    } else {
                        MuninnPagedFile.unlockFlush(pageRef, flushStamp, false);
                    }
                    if (useTemporaryBuffer && pagesGrabbed <= 0) break;
                }
                if (pagesGrabbed <= 0) continue;
                this.vectoredFlush(pages, bufferAddresses, flushStamps, bufferLengths, numberOfBuffers, pagesGrabbed, mergedPages, flushes, forClosing);
                limiter.maybeLimitIO(numberOfBuffers, this, flushes);
                pagesGrabbed = 0;
                nextSequentialAddress = -1L;
                numberOfBuffers = 0;
                lastBufferIndex = -1;
                mergedPages = 0;
                fillingDirtyBuffer = false;
                ++flushPerChunk;
                bufferLengths[0] = 0;
            }
            if (pagesGrabbed > 0) {
                this.vectoredFlush(pages, bufferAddresses, flushStamps, bufferLengths, numberOfBuffers, pagesGrabbed, mergedPages, flushes, forClosing);
                limiter.maybeLimitIO(numberOfBuffers, this, flushes);
                ++flushPerChunk;
            }
            chunkEvent.chunkFlushed(notModifiedPages, flushPerChunk, buffersPerChunk, mergesPerChunk);
        }
        this.swapper.force();
    }

    private void vectoredFlush(long[] pages, long[] bufferAddresses, long[] flushStamps, int[] bufferLengths, int numberOfBuffers, int pagesToFlush, int pagesMerged, MajorFlushEvent flushEvent, boolean forClosing) throws IOException {
        FlushEvent flush = null;
        boolean successful = false;
        try {
            long firstPageRef = pages[0];
            long startFilePageId = MuninnPagedFile.getFilePageId(firstPageRef);
            flush = flushEvent.beginFlush(pages, this.swapper, this, pagesToFlush, pagesMerged);
            long bytesWritten = this.swapper.write(startFilePageId, bufferAddresses, bufferLengths, numberOfBuffers, pagesToFlush);
            flush.addBytesWritten(bytesWritten);
            flush.addPagesFlushed(pagesToFlush);
            flush.addPagesMerged(pagesMerged);
            flush.done();
            successful = true;
        }
        catch (IOException ioe) {
            if (flush != null) {
                flush.done(ioe);
            }
            throw ioe;
        }
        finally {
            if (forClosing) {
                for (int i = 0; i < pagesToFlush; ++i) {
                    long pageRef = pages[i];
                    if (successful) {
                        MuninnPagedFile.explicitlyMarkPageUnmodifiedUnderExclusiveLock(pageRef);
                    }
                    MuninnPagedFile.unlockExclusive(pageRef);
                }
            } else {
                for (int i = 0; i < pagesToFlush; ++i) {
                    MuninnPagedFile.unlockFlush(pages[i], flushStamps[i], successful);
                }
            }
        }
    }

    boolean flushLockedPage(long pageRef, long filePageId) {
        boolean success = false;
        try (MajorFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush(this.swapper);){
            FlushEvent flush = flushEvent.beginFlush(pageRef, this.swapper, this);
            long address = MuninnPagedFile.getAddress(pageRef);
            try {
                long bytesWritten = this.swapper.write(filePageId, address);
                flush.addBytesWritten(bytesWritten);
                flush.addPagesFlushed(1);
                flush.done();
                success = true;
            }
            catch (IOException e) {
                flush.done(e);
            }
        }
        return success;
    }

    @Override
    public void flush() throws IOException {
        this.swapper.force();
    }

    @Override
    public long getLastPageId() throws FileIsNotMappedException {
        long state = this.getHeaderState();
        if (MuninnPagedFile.refCountOf(state) == 0L) {
            throw this.fileIsNotMappedException();
        }
        return state & 0x8000FFFFFFFFFFFFL;
    }

    private FileIsNotMappedException fileIsNotMappedException() {
        FileIsNotMappedException exception = new FileIsNotMappedException(this.path());
        Exception closedBy = this.closeStackTrace;
        if (closedBy != null) {
            exception.addSuppressed(closedBy);
        }
        return exception;
    }

    private long getHeaderState() {
        return HEADER_STATE.getVolatile(this);
    }

    private static long refCountOf(long state) {
        return (state & 0x7FFF000000000000L) >>> 48;
    }

    private void initialiseLastPageId(long lastPageIdFromFile) {
        if (lastPageIdFromFile < 0L) {
            HEADER_STATE.setVolatile(this, Long.MIN_VALUE);
        } else {
            HEADER_STATE.setVolatile(this, lastPageIdFromFile);
        }
    }

    void increaseLastPageIdTo(long newLastPageId) {
        long update;
        long current;
        long lastPageId;
        do {
            current = this.getHeaderState();
            update = newLastPageId + (current & 0x7FFF000000000000L);
        } while ((lastPageId = current & 0x8000FFFFFFFFFFFFL) < newLastPageId && !HEADER_STATE.weakCompareAndSet(this, current, update));
    }

    void incrementRefCount() {
        long count;
        long update;
        long current;
        do {
            if ((count = MuninnPagedFile.refCountOf(current = this.getHeaderState()) + 1L) <= 32767L) continue;
            throw new IllegalStateException("Cannot map file because reference counter would overflow. Maximum reference count is 32767. File is " + this.swapper.path().toAbsolutePath());
        } while (!HEADER_STATE.weakCompareAndSet(this, current, update = (current & 0x8000FFFFFFFFFFFFL) + (count << 48)));
    }

    boolean decrementRefCount() {
        long count;
        long update;
        long current;
        do {
            if ((count = MuninnPagedFile.refCountOf(current = this.getHeaderState()) - 1L) >= 0L) continue;
            throw new IllegalStateException("File has already been closed and unmapped. It cannot be closed any further.");
        } while (!HEADER_STATE.weakCompareAndSet(this, current, update = (current & 0x8000FFFFFFFFFFFFL) + (count << 48)));
        return count == 0L;
    }

    int getRefCount() {
        return (int)MuninnPagedFile.refCountOf(this.getHeaderState());
    }

    @Override
    public void setDeleteOnClose(boolean deleteOnClose) {
        this.deleteOnClose = deleteOnClose;
    }

    @Override
    public boolean isDeleteOnClose() {
        return this.deleteOnClose;
    }

    @Override
    public String getDatabaseName() {
        return this.databaseName;
    }

    @Override
    public PageFileCounters pageFileCounters() {
        return this.swapper.fileSwapperTracer();
    }

    long grabFreeAndExclusivelyLockedPage(PageFaultEvent faultEvent) throws IOException {
        return this.pageCache.grabFreeAndExclusivelyLockedPage(faultEvent);
    }

    private void evictPage(long filePageId) {
        int chunkId = MuninnPagedFile.computeChunkId(filePageId);
        int chunkIndex = MuninnPagedFile.computeChunkIndex(filePageId);
        int[] chunk = this.translationTable[chunkId];
        int mappedPageId = TRANSLATION_TABLE_ARRAY.getVolatile(chunk, chunkIndex);
        long pageRef = this.deref(mappedPageId);
        this.setHighestEvictedTransactionId(MuninnPagedFile.getAndResetLastModifiedTransactionId(pageRef));
        TRANSLATION_TABLE_ARRAY.setVolatile(chunk, chunkIndex, -1);
    }

    private void setHighestEvictedTransactionId(long modifiedTransactionId) {
        long current;
        do {
            if ((current = HIGHEST_EVICTED_TRANSACTION_ID.getVolatile(this)) < modifiedTransactionId) continue;
            return;
        } while (!HIGHEST_EVICTED_TRANSACTION_ID.weakCompareAndSet(this, current, modifiedTransactionId));
    }

    long getHighestEvictedTransactionId() {
        return HIGHEST_EVICTED_TRANSACTION_ID.getVolatile(this);
    }

    synchronized int[][] expandCapacity(int maxChunkId) throws IOException {
        Object tt = this.translationTable;
        if (((int[][])tt).length <= maxChunkId) {
            int newLength = MuninnPagedFile.computeNewRootTableLength(maxChunkId);
            int[][] ntt = new int[newLength][];
            System.arraycopy(tt, 0, ntt, 0, ((int[][])tt).length);
            for (int i = ((int[][])tt).length; i < ntt.length; ++i) {
                ntt[i] = MuninnPagedFile.newChunk();
            }
            tt = ntt;
            if (this.swapper.canAllocate()) {
                long newFileSize = ((int[][])tt).length;
                newFileSize *= (long)translationTableChunkSize;
                this.swapper.allocate(newFileSize *= (long)this.filePageSize);
            }
        }
        this.translationTable = tt;
        return tt;
    }

    private static int[] newChunk() {
        int[] chunk = new int[translationTableChunkSize];
        Arrays.fill(chunk, -1);
        return chunk;
    }

    private static int computeNewRootTableLength(int maxChunkId) {
        int next = 1 + (int)((double)maxChunkId * 1.1);
        return Math.min(next, maxChunkId + maxChunkGrowth);
    }

    static int computeChunkId(long filePageId) {
        return (int)(filePageId >>> translationTableChunkSizePower);
    }

    static int computeChunkIndex(long filePageId) {
        return (int)(filePageId & translationTableChunkSizeMask);
    }

    static {
        try {
            MethodHandles.Lookup l = MethodHandles.lookup();
            HEADER_STATE = l.findVarHandle(MuninnPagedFile.class, "headerState", Long.TYPE);
            HIGHEST_EVICTED_TRANSACTION_ID = l.findVarHandle(MuninnPagedFile.class, "highestEvictedTransactionId", Long.TYPE);
            TRANSLATION_TABLE_ARRAY = MethodHandles.arrayElementVarHandle(int[].class);
        }
        catch (ReflectiveOperationException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

