/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.watcher.FileWatcher;

public interface FileSystemAbstraction
extends Closeable {
    public static final int INVALID_FILE_DESCRIPTOR = -1;
    public static final CopyOption[] EMPTY_COPY_OPTIONS = new CopyOption[0];

    public FileWatcher fileWatcher() throws IOException;

    public StoreChannel open(Path var1, Set<OpenOption> var2) throws IOException;

    public OutputStream openAsOutputStream(Path var1, boolean var2) throws IOException;

    public InputStream openAsInputStream(Path var1) throws IOException;

    public Reader openAsReader(Path var1, Charset var2) throws IOException;

    public Writer openAsWriter(Path var1, Charset var2, boolean var3) throws IOException;

    public StoreChannel write(Path var1) throws IOException;

    public StoreChannel read(Path var1) throws IOException;

    public boolean fileExists(Path var1);

    public void mkdir(Path var1) throws IOException;

    public void mkdirs(Path var1) throws IOException;

    public long getFileSize(Path var1) throws IOException;

    public long getBlockSize(Path var1) throws IOException;

    default public void delete(Path path) throws IOException {
        if (this.isDirectory(path)) {
            this.deleteRecursively(path);
        } else {
            this.deleteFile(path);
        }
    }

    public void deleteFile(Path var1) throws IOException;

    public void deleteRecursively(Path var1) throws IOException;

    public void deleteRecursively(Path var1, Predicate<Path> var2) throws IOException;

    public void renameFile(Path var1, Path var2, CopyOption ... var3) throws IOException;

    public Path[] listFiles(Path var1) throws IOException;

    public Path[] listFiles(Path var1, DirectoryStream.Filter<Path> var2) throws IOException;

    public boolean isDirectory(Path var1);

    public void moveToDirectory(Path var1, Path var2) throws IOException;

    public void copyToDirectory(Path var1, Path var2) throws IOException;

    default public void copyFile(Path from, Path to) throws IOException {
        this.copyFile(from, to, StandardCopyOption.REPLACE_EXISTING);
    }

    public void copyFile(Path var1, Path var2, CopyOption ... var3) throws IOException;

    public void copyRecursively(Path var1, Path var2) throws IOException;

    public void truncate(Path var1, long var2) throws IOException;

    public long lastModifiedTime(Path var1) throws IOException;

    public void deleteFileOrThrow(Path var1) throws IOException;

    public Stream<FileHandle> streamFilesRecursive(Path var1) throws IOException;

    public int getFileDescriptor(StoreChannel var1);
}

