/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.PageList;

final class MuninnReadPageCursor
extends MuninnPageCursor {
    private long lockStamp;

    MuninnReadPageCursor(long victimPage, CursorContext cursorContext) {
        super(victimPage, cursorContext);
    }

    @Override
    protected void unpinCurrentPage() {
        if (this.pinnedPageRef != 0L) {
            this.pinEvent.done();
        }
        this.lockStamp = 0L;
        this.clearPageCursorState();
    }

    @Override
    public boolean next() throws IOException {
        this.unpinCurrentPage();
        long lastPageId = this.assertPagedFileStillMappedAndGetIdOfLastPage();
        if (this.nextPageId > lastPageId || this.nextPageId < 0L) {
            this.storeCurrentPageId(-1L);
            return false;
        }
        this.storeCurrentPageId(this.nextPageId);
        ++this.nextPageId;
        long filePageId = this.loadPlainCurrentPageId();
        this.pinEvent = this.tracer.beginPin(false, filePageId, this.swapper);
        this.pin(filePageId);
        this.verifyContext();
        return true;
    }

    @Override
    protected boolean tryLockPage(long pageRef) {
        this.lockStamp = PageList.tryOptimisticReadLock(pageRef);
        return true;
    }

    @Override
    protected void unlockPage(long pageRef) {
    }

    @Override
    protected void pinCursorToPage(long pageRef, long filePageId, PageSwapper swapper) {
        this.reset(pageRef);
        if (this.updateUsage) {
            PageList.incrementUsage(pageRef);
        }
    }

    @Override
    protected void convertPageFaultLock(long pageRef) {
        this.lockStamp = PageList.unlockExclusive(pageRef);
    }

    @Override
    public boolean shouldRetry() throws IOException {
        MuninnReadPageCursor cursor = this;
        do {
            long pageRef;
            if ((pageRef = cursor.pinnedPageRef) == 0L || PageList.validateReadLock(pageRef, cursor.lockStamp)) continue;
            this.assertPagedFileStillMappedAndGetIdOfLastPage();
            this.startRetryLinkedChain();
            return true;
        } while ((cursor = (MuninnReadPageCursor)cursor.linkedCursor) != null);
        return false;
    }

    private void startRetryLinkedChain() throws IOException {
        MuninnReadPageCursor cursor = this;
        do {
            long pageRef;
            if ((pageRef = cursor.pinnedPageRef) == 0L) continue;
            cursor.startRetry(pageRef);
        } while ((cursor = (MuninnReadPageCursor)cursor.linkedCursor) != null);
    }

    private void startRetry(long pageRef) throws IOException {
        this.setOffset(0);
        this.checkAndClearBoundsFlag();
        this.clearCursorException();
        this.lockStamp = PageList.tryOptimisticReadLock(pageRef);
        if (!PageList.isBoundTo(pageRef, this.pagedFile.swapperId, this.loadPlainCurrentPageId())) {
            this.clearPageReference();
            this.pin(this.loadPlainCurrentPageId());
        }
    }

    @Override
    public void putByte(byte value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putLong(long value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putInt(int value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putBytes(byte[] data, int arrayOffset, int length) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putShort(short value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void shiftBytes(int sourceStart, int length, int shift) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void zapPage() {
        throw new IllegalStateException("Cannot write to read-locked page");
    }
}

