/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.compress;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;

public class ZipUtils {
    public static void zip(FileSystemAbstraction fileSystem, Path sourceToCompress, Path destinationZip) throws IOException {
        ZipUtils.zip(fileSystem, sourceToCompress, destinationZip, false);
    }

    public static void zip(FileSystemAbstraction fileSystem, Path sourceToCompress, Path destinationZip, boolean includeSourceDirectoryInRelativePath) throws IOException {
        if (!fileSystem.fileExists(sourceToCompress)) {
            return;
        }
        if (ZipUtils.isEmptyDirectory(fileSystem, sourceToCompress)) {
            return;
        }
        Map<String, String> env = Map.of("create", "true");
        URI archiveAbsoluteURI = URI.create("jar:file:" + destinationZip.toUri().getRawPath());
        Path baseForRelativePath = sourceToCompress;
        if (includeSourceDirectoryInRelativePath) {
            baseForRelativePath = sourceToCompress.getParent();
        }
        try (FileSystem zipFs = FileSystems.newFileSystem(archiveAbsoluteURI, env);){
            List fileHandles = fileSystem.streamFilesRecursive(sourceToCompress).collect(Collectors.toList());
            for (FileHandle fileHandle : fileHandles) {
                Path zipFsPath;
                Path sourcePath = fileHandle.getPath();
                Path path = zipFsPath = fileSystem.isDirectory(sourceToCompress) ? zipFs.getPath(baseForRelativePath.relativize(sourcePath).toString(), new String[0]) : zipFs.getPath(sourcePath.getFileName().toString(), new String[0]);
                if (zipFsPath.getParent() != null) {
                    Files.createDirectories(zipFsPath.getParent(), new FileAttribute[0]);
                }
                Files.copy(sourcePath, zipFsPath, new CopyOption[0]);
            }
        }
    }

    public static void unzipResource(Class<?> klass, String zipName, Path targetFile) throws IOException {
        URL resource = klass.getResource(zipName);
        if (resource == null) {
            throw new NoSuchFileException(zipName);
        }
        ZipUtils.unzip(resource.getFile(), targetFile);
    }

    public static void unzip(String sourceZip, Path targetFile) throws IOException {
        try (ZipFile zipFile = new ZipFile(sourceZip);){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            if (!entries.hasMoreElements()) {
                throw new IllegalStateException("Zip file '" + sourceZip + "' does not contain any elements.");
            }
            ZipEntry entry = entries.nextElement();
            if (!targetFile.getFileName().toString().equals(entry.getName())) {
                throw new IllegalStateException("Zip file '" + sourceZip + "' does not contain target file '" + targetFile.getFileName() + "'.");
            }
            Files.copy(zipFile.getInputStream(entry), targetFile, new CopyOption[0]);
        }
    }

    private static boolean isEmptyDirectory(FileSystemAbstraction fileSystem, Path sourceToCompress) throws IOException {
        if (fileSystem.isDirectory(sourceToCompress)) {
            Path[] files = fileSystem.listFiles(sourceToCompress);
            return files.length == 0;
        }
        return false;
    }
}

