/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.state;

import java.io.IOException;
import java.nio.file.Path;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.fs.PhysicalFlushableChannel;
import org.neo4j.io.fs.ReadAheadChannel;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.marshal.ChannelMarshal;
import org.neo4j.io.marshal.EndOfStreamException;
import org.neo4j.io.memory.NativeScopedBuffer;
import org.neo4j.io.state.SimpleStorage;
import org.neo4j.memory.MemoryTracker;

public class SimpleFileStorage<T>
implements SimpleStorage<T> {
    private final FileSystemAbstraction fileSystem;
    private final ChannelMarshal<T> marshal;
    private final MemoryTracker memoryTracker;
    private final Path path;

    public SimpleFileStorage(FileSystemAbstraction fileSystem, Path path, ChannelMarshal<T> marshal, MemoryTracker memoryTracker) {
        this.fileSystem = fileSystem;
        this.path = path;
        this.marshal = marshal;
        this.memoryTracker = memoryTracker;
    }

    @Override
    public boolean exists() {
        return this.fileSystem.fileExists(this.path);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public T readState() throws IOException {
        try (ReadAheadChannel<StoreChannel> channel = new ReadAheadChannel<StoreChannel>(this.fileSystem.read(this.path), new NativeScopedBuffer(ReadAheadChannel.DEFAULT_READ_AHEAD_SIZE, this.memoryTracker));){
            T t = this.marshal.unmarshal(channel);
            return t;
        }
        catch (EndOfStreamException e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeState(T state) throws IOException {
        if (this.path.getParent() != null) {
            this.fileSystem.mkdirs(this.path.getParent());
        }
        if (this.fileSystem.fileExists(this.path)) {
            this.fileSystem.deleteFile(this.path);
        }
        try (PhysicalFlushableChannel channel = new PhysicalFlushableChannel(this.fileSystem.write(this.path), new NativeScopedBuffer(ByteUnit.kibiBytes(512L), this.memoryTracker));){
            this.marshal.marshal(state, channel);
        }
    }

    @Override
    public void removeState() throws IOException {
        if (this.exists()) {
            this.fileSystem.deleteFile(this.path);
        }
    }
}

