/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.bufferpool.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.bufferpool.impl.Bucket;
import org.neo4j.io.bufferpool.impl.NeoBufferPoolConfigOverride;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

class BucketBootstrapper {
    private static final double DEFAULT_SMALL_BUFFER_SLICE_COEFFICIENT = 0.125;
    private static final int DEFAULT_LARGE_BUFFER_SLICE_COUNT = 1;
    private static final int DEFAULT_SMALLEST_POOLED_BUFFER = 256;
    private static final int DEFAULT_LARGEST_POOLED_BUFFER = (int)ByteUnit.mebiBytes(1L);
    private static final int DEFAULT_LARGE_BUFFER_THRESHOLD = (int)ByteUnit.kibiBytes(64L);
    private final List<Bucket> buckets;
    private final int maxPooledBufferCapacity;

    BucketBootstrapper(NeoBufferPoolConfigOverride configOverride, MemoryTracker memoryTracker) {
        if (configOverride.getBuckets() == null || configOverride.getBuckets().isEmpty()) {
            this.buckets = new ArrayList<Bucket>();
            for (int bufferSize = 256; bufferSize <= DEFAULT_LARGEST_POOLED_BUFFER; bufferSize <<= 1) {
                int bufferCapacity = bufferSize;
                if ((long)bufferCapacity == ByteUnit.kibiBytes(16L)) {
                    bufferCapacity = (int)ByteUnit.kibiBytes(16L) + 512;
                }
                this.buckets.add(this.createBucket(bufferCapacity, memoryTracker));
            }
        } else {
            this.buckets = configOverride.getBuckets().stream().map(bucketConfig -> this.createBucket((NeoBufferPoolConfigOverride.BucketConfig)bucketConfig, memoryTracker)).sorted(Comparator.comparingInt(Bucket::getBufferCapacity)).collect(Collectors.toList());
        }
        this.maxPooledBufferCapacity = this.buckets.get(this.buckets.size() - 1).getBufferCapacity();
    }

    private Bucket createBucket(NeoBufferPoolConfigOverride.BucketConfig bucketConfig, MemoryTracker memoryTracker) {
        int sliceCount = this.getSliceCount(bucketConfig);
        return new Bucket(bucketConfig.getBufferCapacity(), sliceCount, memoryTracker);
    }

    private Bucket createBucket(int bufferCapacity, MemoryTracker memoryTracker) {
        int sliceCount = 1;
        if (bufferCapacity <= DEFAULT_LARGE_BUFFER_THRESHOLD) {
            sliceCount = this.calculateSliceCount(0.125);
        }
        return new Bucket(bufferCapacity, sliceCount, memoryTracker);
    }

    private int getSliceCount(NeoBufferPoolConfigOverride.BucketConfig bucketConfig) {
        if (bucketConfig.getSliceCoefficient() != null) {
            return this.calculateSliceCount(bucketConfig.getSliceCoefficient());
        }
        return bucketConfig.getSliceCount();
    }

    private int calculateSliceCount(double coefficient) {
        return (int)Math.ceil((double)this.getAvailableCpuCount() * coefficient);
    }

    List<Bucket> getBuckets() {
        return this.buckets;
    }

    int getMaxPooledBufferCapacity() {
        return this.maxPooledBufferCapacity;
    }

    @VisibleForTesting
    protected int getAvailableCpuCount() {
        return Runtime.getRuntime().availableProcessors();
    }
}

