/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.impl.FileIsNotMappedException;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.PageList;

final class MuninnWritePageCursor
extends MuninnPageCursor {
    MuninnWritePageCursor(long victimPage, CursorContext cursorContext) {
        super(victimPage, cursorContext);
    }

    @Override
    protected void unpinCurrentPage() {
        long pageRef = this.pinnedPageRef;
        if (pageRef != 0L) {
            this.pinEvent.done();
            if (this.eagerFlush) {
                this.eagerlyFlushAndUnlockPage(pageRef);
            } else {
                PageList.unlockWrite(pageRef);
            }
        }
        this.clearPageCursorState();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void eagerlyFlushAndUnlockPage(long pageRef) {
        long flushStamp = PageList.unlockWriteAndTryTakeFlushLock(pageRef);
        if (flushStamp != 0L) {
            boolean success = false;
            try {
                success = this.pagedFile.flushLockedPage(pageRef, this.loadPlainCurrentPageId());
            }
            finally {
                PageList.unlockFlush(pageRef, flushStamp, success);
            }
        }
    }

    @Override
    public boolean next() throws IOException {
        this.unpinCurrentPage();
        long lastPageId = this.assertPagedFileStillMappedAndGetIdOfLastPage();
        if (this.nextPageId < 0L) {
            this.storeCurrentPageId(-1L);
            return false;
        }
        if (this.nextPageId > lastPageId) {
            if (this.noGrow) {
                this.storeCurrentPageId(-1L);
                return false;
            }
            this.pagedFile.increaseLastPageIdTo(this.nextPageId);
        }
        this.storeCurrentPageId(this.nextPageId);
        ++this.nextPageId;
        long filePageId = this.loadPlainCurrentPageId();
        this.pinEvent = this.tracer.beginPin(true, filePageId, this.swapper);
        this.pin(filePageId);
        return true;
    }

    @Override
    protected boolean tryLockPage(long pageRef) {
        return PageList.tryWriteLock(pageRef);
    }

    @Override
    protected void unlockPage(long pageRef) {
        PageList.unlockWrite(pageRef);
    }

    @Override
    protected void pinCursorToPage(long pageRef, long filePageId, PageSwapper swapper) throws FileIsNotMappedException {
        this.reset(pageRef);
        this.assertPagedFileStillMappedAndGetIdOfLastPage();
        PageList.incrementUsage(pageRef);
        PageList.setLastModifiedTxId(pageRef, this.versionContext.committingTransactionId());
    }

    @Override
    protected void convertPageFaultLock(long pageRef) {
        PageList.unlockExclusiveAndTakeWriteLock(pageRef);
    }

    @Override
    public boolean shouldRetry() {
        return false;
    }
}

