/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.io.fs.FileSystemAbstraction;

public final class FileSystemUtils {
    private FileSystemUtils() {
    }

    public static OutputStream createOrOpenAsOutputStream(FileSystemAbstraction fs, Path file, boolean append) throws IOException {
        if (file.getParent() != null) {
            fs.mkdirs(file.getParent());
        }
        return fs.openAsOutputStream(file, append);
    }

    public static boolean isEmptyOrNonExistingDirectory(FileSystemAbstraction fs, Path directory) throws IOException {
        if (fs.isDirectory(directory)) {
            Object[] files = fs.listFiles(directory);
            return ArrayUtils.isEmpty((Object[])files);
        }
        return !fs.fileExists(directory);
    }

    public static long size(FileSystemAbstraction fs, Path file) throws IOException {
        if (fs.isDirectory(file)) {
            Path[] files = fs.listFiles(file);
            long size = 0L;
            for (Path child : files) {
                size += FileSystemUtils.size(fs, child);
            }
            return size;
        }
        return fs.getFileSize(file);
    }

    public static void deleteFile(FileSystemAbstraction fs, Path fileToDelete) throws IOException {
        if (fs.isDirectory(fileToDelete)) {
            fs.deleteRecursively(fileToDelete);
        } else {
            fs.deleteFile(fileToDelete);
        }
    }
}

