/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache;

import java.io.File;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.Optional;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;

public interface PageCache
extends AutoCloseable {
    public static final int PAGE_SIZE = 8192;

    default public PagedFile map(File file, int pageSize) throws IOException {
        return this.map(file, this.versionContextSupplier(), pageSize, (ImmutableSet<OpenOption>)Sets.immutable.empty());
    }

    default public PagedFile map(File file, int pageSize, ImmutableSet<OpenOption> openOptions) throws IOException {
        return this.map(file, this.versionContextSupplier(), pageSize, openOptions);
    }

    public PagedFile map(File var1, VersionContextSupplier var2, int var3, ImmutableSet<OpenOption> var4) throws IOException;

    public Optional<PagedFile> getExistingMapping(File var1) throws IOException;

    public List<PagedFile> listExistingMappings() throws IOException;

    public void flushAndForce() throws IOException;

    public void flushAndForce(IOLimiter var1) throws IOException;

    @Override
    public void close();

    public int pageSize();

    public long maxCachedPages();

    public VersionContextSupplier versionContextSupplier();
}

