/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.internal.unsafe.UnsafeUtil;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.OffHeapPageLock;
import org.neo4j.io.pagecache.impl.muninn.SwapperSet;
import org.neo4j.io.pagecache.tracing.EvictionEvent;
import org.neo4j.io.pagecache.tracing.EvictionEventOpportunity;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.util.FeatureToggles;

class PageList {
    private static final boolean forceSlowMemoryClear = FeatureToggles.flag(PageList.class, (String)"forceSlowMemoryClear", (boolean)false);
    static final int META_DATA_BYTES_PER_PAGE = 32;
    static final long MAX_PAGES = Integer.MAX_VALUE;
    private static final int UNBOUND_LAST_MODIFIED_TX_ID = -1;
    private static final long MAX_USAGE_COUNT = 4L;
    private static final int SHIFT_FILE_PAGE_ID = 24;
    private static final int SHIFT_SWAPPER_ID = 3;
    private static final int SHIFT_PARTIAL_FILE_PAGE_ID = 21;
    private static final long MASK_USAGE_COUNT = 7L;
    private static final long MASK_NOT_FILE_PAGE_ID = 0xFFFFFFL;
    private static final long MASK_SHIFTED_SWAPPER_ID = 0x1FFFFFL;
    private static final long MASK_NOT_SWAPPER_ID = -16777209L;
    private static final long UNBOUND_PAGE_BINDING = -16777216L;
    private static final long MAX_FILE_PAGE_ID = 0xFFFFFFFFFFL;
    private static final int OFFSET_LOCK_WORD = 0;
    private static final int OFFSET_ADDRESS = 8;
    private static final int OFFSET_LAST_TX_ID = 16;
    private static final int OFFSET_PAGE_BINDING = 24;
    private final int pageCount;
    private final int cachePageSize;
    private final MemoryAllocator memoryAllocator;
    private final SwapperSet swappers;
    private final long victimPageAddress;
    private final long baseAddress;
    private final long bufferAlignment;

    PageList(int pageCount, int cachePageSize, MemoryAllocator memoryAllocator, SwapperSet swappers, long victimPageAddress, long bufferAlignment) {
        this.pageCount = pageCount;
        this.cachePageSize = cachePageSize;
        this.memoryAllocator = memoryAllocator;
        this.swappers = swappers;
        this.victimPageAddress = victimPageAddress;
        long bytes = (long)pageCount * 32L;
        this.baseAddress = memoryAllocator.allocateAligned(bytes, 8L);
        this.bufferAlignment = bufferAlignment;
        this.clearMemory(this.baseAddress, pageCount);
    }

    PageList(PageList pageList) {
        this.pageCount = pageList.pageCount;
        this.cachePageSize = pageList.cachePageSize;
        this.memoryAllocator = pageList.memoryAllocator;
        this.swappers = pageList.swappers;
        this.victimPageAddress = pageList.victimPageAddress;
        this.baseAddress = pageList.baseAddress;
        this.bufferAlignment = pageList.bufferAlignment;
    }

    private void clearMemory(long baseAddress, long pageCount) {
        long memcpyChunkSize = UnsafeUtil.pageSize();
        long metaDataEntriesPerChunk = memcpyChunkSize / 32L;
        if (pageCount < metaDataEntriesPerChunk || forceSlowMemoryClear) {
            this.clearMemorySimple(baseAddress, pageCount);
        } else {
            this.clearMemoryFast(baseAddress, pageCount, memcpyChunkSize, metaDataEntriesPerChunk);
        }
        UnsafeUtil.fullFence();
    }

    private void clearMemorySimple(long baseAddress, long pageCount) {
        long address = baseAddress - 8L;
        long initialLockWord = OffHeapPageLock.initialLockWordWithExclusiveLock();
        for (long i = 0L; i < pageCount; ++i) {
            UnsafeUtil.putLong((long)(address += 8L), (long)initialLockWord);
            UnsafeUtil.putLong((long)(address += 8L), (long)0L);
            UnsafeUtil.putLong((long)(address += 8L), (long)0L);
            UnsafeUtil.putLong((long)(address += 8L), (long)-16777216L);
        }
    }

    private void clearMemoryFast(long baseAddress, long pageCount, long memcpyChunkSize, long metaDataEntriesPerChunk) {
        this.clearMemorySimple(baseAddress, metaDataEntriesPerChunk);
        long chunkCopies = pageCount / metaDataEntriesPerChunk - 1L;
        long address = baseAddress + memcpyChunkSize;
        int i = 0;
        while ((long)i < chunkCopies) {
            UnsafeUtil.copyMemory((long)baseAddress, (long)address, (long)memcpyChunkSize);
            address += memcpyChunkSize;
            ++i;
        }
        long tailCount = pageCount % metaDataEntriesPerChunk;
        this.clearMemorySimple(address, tailCount);
    }

    int getPageCount() {
        return this.pageCount;
    }

    SwapperSet getSwappers() {
        return this.swappers;
    }

    long deref(int pageId) {
        long id = pageId;
        return this.baseAddress + id * 32L;
    }

    int toId(long pageRef) {
        return (int)(pageRef - this.baseAddress >> 5);
    }

    private long offLastModifiedTransactionId(long pageRef) {
        return pageRef + 16L;
    }

    private long offLock(long pageRef) {
        return pageRef + 0L;
    }

    private long offAddress(long pageRef) {
        return pageRef + 8L;
    }

    private long offPageBinding(long pageRef) {
        return pageRef + 24L;
    }

    long tryOptimisticReadLock(long pageRef) {
        return OffHeapPageLock.tryOptimisticReadLock(this.offLock(pageRef));
    }

    boolean validateReadLock(long pageRef, long stamp) {
        return OffHeapPageLock.validateReadLock(this.offLock(pageRef), stamp);
    }

    boolean isModified(long pageRef) {
        return OffHeapPageLock.isModified(this.offLock(pageRef));
    }

    boolean isExclusivelyLocked(long pageRef) {
        return OffHeapPageLock.isExclusivelyLocked(this.offLock(pageRef));
    }

    boolean tryWriteLock(long pageRef) {
        return OffHeapPageLock.tryWriteLock(this.offLock(pageRef));
    }

    void unlockWrite(long pageRef) {
        OffHeapPageLock.unlockWrite(this.offLock(pageRef));
    }

    long unlockWriteAndTryTakeFlushLock(long pageRef) {
        return OffHeapPageLock.unlockWriteAndTryTakeFlushLock(this.offLock(pageRef));
    }

    boolean tryExclusiveLock(long pageRef) {
        return OffHeapPageLock.tryExclusiveLock(this.offLock(pageRef));
    }

    long unlockExclusive(long pageRef) {
        return OffHeapPageLock.unlockExclusive(this.offLock(pageRef));
    }

    void unlockExclusiveAndTakeWriteLock(long pageRef) {
        OffHeapPageLock.unlockExclusiveAndTakeWriteLock(this.offLock(pageRef));
    }

    long tryFlushLock(long pageRef) {
        return OffHeapPageLock.tryFlushLock(this.offLock(pageRef));
    }

    void unlockFlush(long pageRef, long stamp, boolean success) {
        OffHeapPageLock.unlockFlush(this.offLock(pageRef), stamp, success);
    }

    void explicitlyMarkPageUnmodifiedUnderExclusiveLock(long pageRef) {
        OffHeapPageLock.explicitlyMarkPageUnmodifiedUnderExclusiveLock(this.offLock(pageRef));
    }

    int getCachePageSize() {
        return this.cachePageSize;
    }

    long getAddress(long pageRef) {
        return UnsafeUtil.getLong((long)this.offAddress(pageRef));
    }

    void initBuffer(long pageRef) {
        if (this.getAddress(pageRef) == 0L) {
            long addr = this.memoryAllocator.allocateAligned(this.getCachePageSize(), this.bufferAlignment);
            UnsafeUtil.putLong((long)this.offAddress(pageRef), (long)addr);
        }
    }

    private byte getUsageCounter(long pageRef) {
        return (byte)(UnsafeUtil.getLongVolatile((long)this.offPageBinding(pageRef)) & 7L);
    }

    void incrementUsage(long pageRef) {
        long address = this.offPageBinding(pageRef);
        long value = UnsafeUtil.getLongVolatile((long)address);
        long usage = value & 7L;
        if (usage < 4L) {
            long update = value + 1L;
            UnsafeUtil.compareAndSwapLong(null, (long)address, (long)value, (long)update);
        }
    }

    boolean decrementUsage(long pageRef) {
        long address = this.offPageBinding(pageRef);
        long value = UnsafeUtil.getLongVolatile((long)address);
        long usage = value & 7L;
        if (usage > 0L) {
            long update = value - 1L;
            UnsafeUtil.compareAndSwapLong(null, (long)address, (long)value, (long)update);
        }
        return usage <= 1L;
    }

    long getFilePageId(long pageRef) {
        long filePageId = UnsafeUtil.getLong((long)this.offPageBinding(pageRef)) >>> 24;
        return filePageId == 0xFFFFFFFFFFL ? -1L : filePageId;
    }

    private void setFilePageId(long pageRef, long filePageId) {
        if (filePageId > 0xFFFFFFFFFFL) {
            throw new IllegalArgumentException(String.format("File page id: %s is bigger then max supported value %s.", filePageId, 0xFFFFFFFFFFL));
        }
        long address = this.offPageBinding(pageRef);
        long v = UnsafeUtil.getLong((long)address);
        filePageId = (filePageId << 24) + (v & 0xFFFFFFL);
        UnsafeUtil.putLong((long)address, (long)filePageId);
    }

    long getLastModifiedTxId(long pageRef) {
        return UnsafeUtil.getLongVolatile((long)this.offLastModifiedTransactionId(pageRef));
    }

    long getAndResetLastModifiedTransactionId(long pageRef) {
        return UnsafeUtil.getAndSetLong(null, (long)this.offLastModifiedTransactionId(pageRef), (long)-1L);
    }

    void setLastModifiedTxId(long pageRef, long modifierTxId) {
        UnsafeUtil.compareAndSetMaxLong(null, (long)this.offLastModifiedTransactionId(pageRef), (long)modifierTxId);
    }

    int getSwapperId(long pageRef) {
        long v = UnsafeUtil.getLong((long)this.offPageBinding(pageRef)) >>> 3;
        return (int)(v & 0x1FFFFFL);
    }

    private void setSwapperId(long pageRef, int swapperId) {
        long address = this.offPageBinding(pageRef);
        long v = UnsafeUtil.getLong((long)address) & 0xFFFFFFFFFF000007L;
        UnsafeUtil.putLong((long)address, (long)(v + (long)(swapperId <<= 3)));
    }

    boolean isLoaded(long pageRef) {
        return this.getFilePageId(pageRef) != -1L;
    }

    boolean isBoundTo(long pageRef, int swapperId, long filePageId) {
        long expectedBinding = (filePageId << 21) + (long)swapperId;
        long address = this.offPageBinding(pageRef);
        long actualBinding = UnsafeUtil.getLong((long)address) >>> 3;
        return expectedBinding == actualBinding;
    }

    void fault(long pageRef, PageSwapper swapper, int swapperId, long filePageId, PageFaultEvent event) throws IOException {
        if (swapper == null) {
            throw PageList.swapperCannotBeNull();
        }
        int currentSwapper = this.getSwapperId(pageRef);
        long currentFilePageId = this.getFilePageId(pageRef);
        if (filePageId == -1L || !this.isExclusivelyLocked(pageRef) || currentSwapper != 0 || currentFilePageId != -1L) {
            throw PageList.cannotFaultException(pageRef, swapper, swapperId, filePageId, currentSwapper, currentFilePageId);
        }
        this.setFilePageId(pageRef, filePageId);
        long bytesRead = swapper.read(filePageId, this.getAddress(pageRef));
        event.addBytesRead(bytesRead);
        event.setCachePageId(this.toId(pageRef));
        this.setSwapperId(pageRef, swapperId);
    }

    private static IllegalArgumentException swapperCannotBeNull() {
        return new IllegalArgumentException("swapper cannot be null");
    }

    private static IllegalStateException cannotFaultException(long pageRef, PageSwapper swapper, int swapperId, long filePageId, int currentSwapper, long currentFilePageId) {
        String msg = String.format("Cannot fault page {filePageId = %s, swapper = %s (swapper id = %s)} into cache page %s. Already bound to {filePageId = %s, swapper id = %s}.", filePageId, swapper, swapperId, pageRef, currentFilePageId, currentSwapper);
        return new IllegalStateException(msg);
    }

    boolean tryEvict(long pageRef, EvictionEventOpportunity evictionOpportunity) throws IOException {
        if (this.tryExclusiveLock(pageRef)) {
            if (this.isLoaded(pageRef)) {
                try (EvictionEvent evictionEvent = evictionOpportunity.beginEviction();){
                    this.evict(pageRef, evictionEvent);
                    boolean bl = true;
                    return bl;
                }
            }
            this.unlockExclusive(pageRef);
        }
        return false;
    }

    private void evict(long pageRef, EvictionEvent evictionEvent) throws IOException {
        SwapperSet.SwapperMapping swapperMapping;
        long filePageId = this.getFilePageId(pageRef);
        evictionEvent.setFilePageId(filePageId);
        evictionEvent.setCachePageId(pageRef);
        int swapperId = this.getSwapperId(pageRef);
        if (swapperId != 0 && (swapperMapping = this.swappers.getAllocation(swapperId)) != null) {
            PageSwapper swapper = swapperMapping.swapper;
            evictionEvent.setSwapper(swapper);
            if (this.isModified(pageRef)) {
                this.flushModifiedPage(pageRef, evictionEvent, filePageId, swapper);
            }
            swapper.evicted(filePageId);
        }
        this.clearBinding(pageRef);
    }

    private void flushModifiedPage(long pageRef, EvictionEvent evictionEvent, long filePageId, PageSwapper swapper) throws IOException {
        FlushEvent flushEvent = evictionEvent.flushEventOpportunity().beginFlush(filePageId, pageRef, swapper);
        try {
            long address = this.getAddress(pageRef);
            long bytesWritten = swapper.write(filePageId, address);
            this.explicitlyMarkPageUnmodifiedUnderExclusiveLock(pageRef);
            flushEvent.addBytesWritten(bytesWritten);
            flushEvent.addPagesFlushed(1);
            flushEvent.done();
        }
        catch (IOException e) {
            this.unlockExclusive(pageRef);
            flushEvent.done(e);
            evictionEvent.threwException(e);
            throw e;
        }
    }

    private void clearBinding(long pageRef) {
        UnsafeUtil.putLong((long)this.offPageBinding(pageRef), (long)-16777216L);
    }

    void toString(long pageRef, StringBuilder sb) {
        sb.append("Page[ id = ").append(this.toId(pageRef));
        sb.append(", address = ").append(this.getAddress(pageRef));
        sb.append(", filePageId = ").append(this.getFilePageId(pageRef));
        sb.append(", swapperId = ").append(this.getSwapperId(pageRef));
        sb.append(", usageCounter = ").append(this.getUsageCounter(pageRef));
        sb.append(" ] ").append(OffHeapPageLock.toString(this.offLock(pageRef)));
    }
}

