/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.fs;

import java.io.Closeable;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.file.CopyOption;
import java.nio.file.OpenOption;
import java.nio.file.StandardCopyOption;
import java.util.Set;
import java.util.stream.Stream;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.StoreChannel;
import org.neo4j.io.fs.watcher.FileWatcher;

public interface FileSystemAbstraction
extends Closeable {
    public static final int INVALID_FILE_DESCRIPTOR = -1;
    public static final CopyOption[] EMPTY_COPY_OPTIONS = new CopyOption[0];

    public FileWatcher fileWatcher() throws IOException;

    public StoreChannel open(File var1, Set<OpenOption> var2) throws IOException;

    public OutputStream openAsOutputStream(File var1, boolean var2) throws IOException;

    public InputStream openAsInputStream(File var1) throws IOException;

    public Reader openAsReader(File var1, Charset var2) throws IOException;

    public Writer openAsWriter(File var1, Charset var2, boolean var3) throws IOException;

    public StoreChannel write(File var1) throws IOException;

    public StoreChannel read(File var1) throws IOException;

    public boolean fileExists(File var1);

    public boolean mkdir(File var1);

    public void mkdirs(File var1) throws IOException;

    public long getFileSize(File var1);

    public long getBlockSize(File var1) throws IOException;

    public boolean deleteFile(File var1);

    public void deleteRecursively(File var1) throws IOException;

    public void renameFile(File var1, File var2, CopyOption ... var3) throws IOException;

    public File[] listFiles(File var1);

    public File[] listFiles(File var1, FilenameFilter var2);

    public boolean isDirectory(File var1);

    public void moveToDirectory(File var1, File var2) throws IOException;

    public void copyToDirectory(File var1, File var2) throws IOException;

    default public void copyFile(File from, File to) throws IOException {
        this.copyFile(from, to, StandardCopyOption.REPLACE_EXISTING);
    }

    public void copyFile(File var1, File var2, CopyOption ... var3) throws IOException;

    public void copyRecursively(File var1, File var2) throws IOException;

    public void truncate(File var1, long var2) throws IOException;

    public long lastModifiedTime(File var1);

    public void deleteFileOrThrow(File var1) throws IOException;

    public Stream<FileHandle> streamFilesRecursive(File var1) throws IOException;

    public int getFileDescriptor(StoreChannel var1);
}

