/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.compress;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.neo4j.io.fs.FileHandle;
import org.neo4j.io.fs.FileSystemAbstraction;

public class ZipUtils {
    public static void zip(FileSystemAbstraction fileSystem, File sourceToCompress, File destinationZip) throws IOException {
        if (!fileSystem.fileExists(sourceToCompress)) {
            return;
        }
        if (ZipUtils.isEmptyDirectory(fileSystem, sourceToCompress)) {
            return;
        }
        Map<String, String> env = Map.of("create", "true");
        Path rootPath = sourceToCompress.toPath();
        URI archiveAbsoluteURI = URI.create("jar:file:" + destinationZip.toURI().getRawPath());
        try (FileSystem zipFs = FileSystems.newFileSystem(archiveAbsoluteURI, env);){
            List fileHandles = fileSystem.streamFilesRecursive(sourceToCompress).collect(Collectors.toList());
            for (FileHandle fileHandle : fileHandles) {
                Path zipFsPath;
                Path sourcePath = fileHandle.getFile().toPath();
                Path path = zipFsPath = fileSystem.isDirectory(sourceToCompress) ? zipFs.getPath(rootPath.relativize(sourcePath).toString(), new String[0]) : zipFs.getPath(sourcePath.getFileName().toString(), new String[0]);
                if (zipFsPath.getParent() != null) {
                    Files.createDirectories(zipFsPath.getParent(), new FileAttribute[0]);
                }
                Files.copy(sourcePath, zipFsPath, new CopyOption[0]);
            }
        }
    }

    private static boolean isEmptyDirectory(FileSystemAbstraction fileSystem, File sourceToCompress) {
        if (fileSystem.isDirectory(sourceToCompress)) {
            File[] files = fileSystem.listFiles(sourceToCompress);
            return files == null || files.length == 0;
        }
        return false;
    }
}

