/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public enum ByteUnit {
    Byte(0L, "B"),
    KibiByte(1L, "KiB", "KB", "K", "kB", "kb", "k"),
    MebiByte(2L, "MiB", "MB", "M", "mB", "mb", "m"),
    GibiByte(3L, "GiB", "GB", "G", "gB", "gb", "g"),
    TebiByte(4L, "TiB", "TB"),
    PebiByte(5L, "PiB", "PB"),
    ExbiByte(6L, "EiB", "EB");

    public static final long ONE_KIBI_BYTE;
    public static final long ONE_MEBI_BYTE;
    public static final long ONE_GIBI_BYTE;
    public static final String VALID_MULTIPLIERS;
    private static final long EIC_MULTIPLIER = 1024L;
    private final long factor;
    private final String shortName;
    private final String[] names;

    private ByteUnit(long power, String ... names) {
        this.factor = this.factorFromPower(power);
        this.shortName = names[0];
        this.names = names;
    }

    private long factorFromPower(long power) {
        if (power == 0L) {
            return 1L;
        }
        long product = 1024L;
        int i = 0;
        while ((long)i < power - 1L) {
            product *= 1024L;
            ++i;
        }
        return product;
    }

    public String abbreviation() {
        return this.shortName;
    }

    public long convert(long value, ByteUnit toUnit) {
        return this.toBytes(value) / toUnit.factor;
    }

    public long toBytes(long value) {
        return this.factor * value;
    }

    public long toKibiBytes(long value) {
        return this.convert(value, KibiByte);
    }

    public long toMebiBytes(long value) {
        return this.convert(value, MebiByte);
    }

    public long toGibiBytes(long value) {
        return this.convert(value, GibiByte);
    }

    public long toTebiBytes(long value) {
        return this.convert(value, TebiByte);
    }

    public long toPebiBytes(long value) {
        return this.convert(value, PebiByte);
    }

    public long toExbiBytes(long value) {
        return this.convert(value, ExbiByte);
    }

    public static long bytes(long bytes) {
        return bytes;
    }

    public static long kibiBytes(long kibibytes) {
        return KibiByte.toBytes(kibibytes);
    }

    public static long mebiBytes(long mebibytes) {
        return MebiByte.toBytes(mebibytes);
    }

    public static long gibiBytes(long gibibytes) {
        return GibiByte.toBytes(gibibytes);
    }

    public static long tebiBytes(long tebibytes) {
        return TebiByte.toBytes(tebibytes);
    }

    public static long pebiBytes(long pebibytes) {
        return PebiByte.toBytes(pebibytes);
    }

    public static long exbiBytes(long exbibytes) {
        return ExbiByte.toBytes(exbibytes);
    }

    public static String bytesToString(long bytes) {
        if (bytes >= ONE_GIBI_BYTE) {
            return String.format(Locale.ROOT, "%.4g%s", (double)bytes / (double)ONE_GIBI_BYTE, ByteUnit.GibiByte.shortName);
        }
        if (bytes >= ONE_MEBI_BYTE) {
            return String.format(Locale.ROOT, "%.4g%s", (double)bytes / (double)ONE_MEBI_BYTE, ByteUnit.MebiByte.shortName);
        }
        if (bytes >= ONE_KIBI_BYTE) {
            return String.format(Locale.ROOT, "%.4g%s", (double)bytes / (double)ONE_KIBI_BYTE, ByteUnit.KibiByte.shortName);
        }
        return bytes + ByteUnit.Byte.shortName;
    }

    public static String bytesToStringWithoutDecimals(long bytes) {
        long kibi;
        long mebi;
        long gibi;
        if (bytes >= ONE_GIBI_BYTE && bytes - (gibi = bytes / ONE_GIBI_BYTE) * ONE_GIBI_BYTE == 0L) {
            return String.format(Locale.ROOT, "%d%s", gibi, ByteUnit.GibiByte.shortName);
        }
        if (bytes >= ONE_MEBI_BYTE && bytes - (mebi = bytes / ONE_MEBI_BYTE) * ONE_MEBI_BYTE == 0L) {
            return String.format(Locale.ROOT, "%d%s", mebi, ByteUnit.MebiByte.shortName);
        }
        if (bytes >= ONE_KIBI_BYTE && bytes - (kibi = bytes / ONE_KIBI_BYTE) * ONE_KIBI_BYTE == 0L) {
            return String.format(Locale.ROOT, "%d%s", kibi, ByteUnit.KibiByte.shortName);
        }
        return bytes + ByteUnit.Byte.shortName;
    }

    public static long parse(String text) {
        int digit;
        char ch;
        int i;
        long result = 0L;
        int len = text.length();
        int unitCharacters = 0;
        int digitCharacters = 0;
        Map<String, ByteUnit> units = ByteUnit.listUnits();
        for (i = 0; i < len && Character.isWhitespace(ch = text.charAt(i)); ++i) {
        }
        while (i < len && (digit = Character.digit(ch = text.charAt(i), 10)) != -1) {
            result *= 10L;
            result += (long)digit;
            ++i;
            ++digitCharacters;
        }
        while (i < len && Character.isWhitespace(ch = text.charAt(i))) {
            ++i;
        }
        int unitStart = i;
        while (i < len && !Character.isWhitespace(ch = text.charAt(i))) {
            ++i;
            ++unitCharacters;
        }
        if (digitCharacters == 0) {
            throw ByteUnit.invalidFormat(text);
        }
        if (unitCharacters == 0) {
            return result;
        }
        ByteUnit unit = units.get(text.substring(unitStart, unitStart + unitCharacters));
        if (unit == null) {
            throw ByteUnit.invalidFormat(text);
        }
        result = unit.toBytes(result);
        return result;
    }

    private static IllegalArgumentException invalidFormat(String text) {
        return new IllegalArgumentException("Invalid number format: '" + text + "'");
    }

    private static Map<String, ByteUnit> listUnits() {
        HashMap<String, ByteUnit> units = new HashMap<String, ByteUnit>();
        for (ByteUnit unit : ByteUnit.values()) {
            for (String name : unit.names) {
                units.put(name, unit);
            }
        }
        return units;
    }

    static {
        ONE_KIBI_BYTE = KibiByte.toBytes(1L);
        ONE_MEBI_BYTE = MebiByte.toBytes(1L);
        ONE_GIBI_BYTE = GibiByte.toBytes(1L);
        VALID_MULTIPLIERS = Arrays.stream(ByteUnit.values()).flatMap(unit -> Arrays.stream(unit.names)).collect(Collectors.joining("`, `", "`", "`"));
    }
}

