/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.layout;

import java.util.Arrays;
import java.util.List;
import org.neo4j.util.Preconditions;

public enum DatabaseFile {
    NODE_STORE("neostore.nodestore.db"),
    NODE_LABEL_STORE("neostore.nodestore.db.labels"),
    PROPERTY_STORE("neostore.propertystore.db"),
    PROPERTY_ARRAY_STORE("neostore.propertystore.db.arrays"),
    PROPERTY_STRING_STORE("neostore.propertystore.db.strings"),
    PROPERTY_KEY_TOKEN_STORE("neostore.propertystore.db.index"),
    PROPERTY_KEY_TOKEN_NAMES_STORE("neostore.propertystore.db.index.keys"),
    RELATIONSHIP_STORE("neostore.relationshipstore.db"),
    RELATIONSHIP_GROUP_STORE("neostore.relationshipgroupstore.db"),
    RELATIONSHIP_TYPE_TOKEN_STORE("neostore.relationshiptypestore.db"),
    RELATIONSHIP_TYPE_TOKEN_NAMES_STORE("neostore.relationshiptypestore.db.names"),
    LABEL_TOKEN_STORE("neostore.labeltokenstore.db"),
    LABEL_TOKEN_NAMES_STORE("neostore.labeltokenstore.db.names"),
    SCHEMA_STORE("neostore.schemastore.db"),
    COUNTS_STORES(false, "neostore.counts.db.a", "neostore.counts.db.b"),
    COUNTS_STORE_A(false, "neostore.counts.db.a"),
    COUNTS_STORE_B(false, "neostore.counts.db.b"),
    METADATA_STORE("neostore"),
    LABEL_SCAN_STORE(false, "neostore.labelscanstore.db");

    private final List<String> names;
    private final boolean hasIdFile;

    private DatabaseFile(String name) {
        this(true, name);
    }

    private DatabaseFile(boolean hasIdFile, String ... names) {
        this.names = Arrays.asList(names);
        this.hasIdFile = hasIdFile;
    }

    Iterable<String> getNames() {
        return this.names;
    }

    String getName() {
        Preconditions.checkState((this.names.size() == 1 ? 1 : 0) != 0, (String)"Database file has more then one file names.");
        return this.names.get(0);
    }

    boolean hasIdFile() {
        return this.hasIdFile;
    }
}

