/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.util.Collection;

public final class IOUtils {
    private IOUtils() {
    }

    public static <T extends AutoCloseable> void closeAll(Collection<T> closeables) throws IOException {
        IOUtils.closeAll((AutoCloseable[])closeables.toArray(new AutoCloseable[closeables.size()]));
    }

    public static <T extends AutoCloseable> void closeAllSilently(Collection<T> closeables) {
        try {
            IOUtils.closeAll(closeables);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @SafeVarargs
    public static <T extends AutoCloseable> void closeAll(T ... closeables) throws IOException {
        IOUtils.closeAll(IOException.class, closeables);
    }

    @SafeVarargs
    public static <T extends AutoCloseable> void closeAllSilently(T ... closeables) {
        try {
            IOUtils.closeAll(closeables);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @SafeVarargs
    public static <T extends AutoCloseable, E extends Throwable> void closeAll(Class<E> throwableClass, T ... closeables) throws E {
        Throwable closeThrowable = null;
        for (T closeable : closeables) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Throwable t) {
                if (closeThrowable == null) {
                    closeThrowable = t;
                    continue;
                }
                closeThrowable.addSuppressed(t);
            }
        }
        if (closeThrowable != null) {
            throw IOUtils.newThrowable(throwableClass, "Exception closing multiple resources", closeThrowable);
        }
    }

    public static <T extends AutoCloseable> void closeAllUnchecked(Collection<T> closeables) throws UncheckedIOException {
        try {
            IOUtils.closeAll(closeables);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private static <E extends Throwable> E newThrowable(Class<E> throwableClass, String message, Throwable cause) {
        try {
            Constructor<E> constructor = throwableClass.getConstructor(String.class, Throwable.class);
            return (E)((Throwable)constructor.newInstance(message, cause));
        }
        catch (Throwable t) {
            RuntimeException runtimeException = new RuntimeException("Unable to create exception to throw. Original message: " + message, t);
            runtimeException.addSuppressed(cause);
            throw runtimeException;
        }
    }
}

