/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.mem;

import org.neo4j.io.ByteUnit;
import org.neo4j.io.mem.MemoryAllocator;
import org.neo4j.io.mem.NativeMemoryAllocationRefusedError;
import org.neo4j.memory.MemoryAllocationTracker;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;
import org.neo4j.util.FeatureToggles;

public final class GrabAllocator
implements MemoryAllocator {
    private static final long GRAB_SIZE = FeatureToggles.getInteger(GrabAllocator.class, (String)"GRAB_SIZE", (int)((int)ByteUnit.kibiBytes(512L)));
    private long memoryReserve;
    private final MemoryAllocationTracker memoryTracker;
    private Grab grabs;

    GrabAllocator(long expectedMaxMemory, MemoryAllocationTracker memoryTracker) {
        this.memoryReserve = expectedMaxMemory;
        this.memoryTracker = memoryTracker;
    }

    @Override
    public synchronized long usedMemory() {
        long sum = 0L;
        Grab grab = this.grabs;
        while (grab != null) {
            sum += grab.nextPointer - grab.address;
            grab = grab.next;
        }
        return sum;
    }

    @Override
    public synchronized long availableMemory() {
        Grab grab = this.grabs;
        long availableInCurrentGrab = 0L;
        if (grab != null) {
            availableInCurrentGrab = grab.limit - grab.nextPointer;
        }
        return Math.max(this.memoryReserve, 0L) + availableInCurrentGrab;
    }

    @Override
    public synchronized long allocateAligned(long bytes, long alignment) {
        if (alignment <= 0L) {
            throw new IllegalArgumentException("Invalid alignment: " + alignment + ". Alignment must be positive.");
        }
        long grabSize = Math.min(GRAB_SIZE, this.memoryReserve);
        try {
            if (bytes > GRAB_SIZE) {
                Grab nextGrab = this.grabs == null ? null : this.grabs.next;
                Grab allocationGrab = new Grab(nextGrab, grabSize = bytes, this.memoryTracker);
                if (!allocationGrab.canAllocate(bytes)) {
                    allocationGrab.free();
                    grabSize = bytes + alignment;
                    allocationGrab = new Grab(nextGrab, grabSize, this.memoryTracker);
                }
                long allocation = allocationGrab.allocate(bytes, alignment);
                this.grabs = this.grabs == null ? allocationGrab : this.grabs.setNext(allocationGrab);
                this.memoryReserve -= bytes;
                return allocation;
            }
            if (this.grabs == null || !this.grabs.canAllocate(bytes)) {
                if (grabSize < bytes) {
                    grabSize = bytes;
                    Grab grab = new Grab(this.grabs, grabSize, this.memoryTracker);
                    if (grab.canAllocate(bytes)) {
                        this.memoryReserve -= grabSize;
                        this.grabs = grab;
                        return this.grabs.allocate(bytes, alignment);
                    }
                    grab.free();
                    grabSize = bytes + alignment;
                }
                this.grabs = new Grab(this.grabs, grabSize, this.memoryTracker);
                this.memoryReserve -= grabSize;
            }
            return this.grabs.allocate(bytes, alignment);
        }
        catch (OutOfMemoryError oome) {
            NativeMemoryAllocationRefusedError error = new NativeMemoryAllocationRefusedError(grabSize, this.usedMemory());
            this.initCause(error, oome);
            throw error;
        }
    }

    private void initCause(NativeMemoryAllocationRefusedError error, OutOfMemoryError cause) {
        try {
            error.initCause(cause);
        }
        catch (Throwable ignore) {
            try {
                error.addSuppressed(cause);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected synchronized void finalize() throws Throwable {
        super.finalize();
        Grab current = this.grabs;
        while (current != null) {
            current.free();
            current = current.next;
        }
    }

    private static class Grab {
        public final Grab next;
        private final long address;
        private final long limit;
        private final MemoryAllocationTracker memoryTracker;
        private long nextPointer;

        Grab(Grab next, long size, MemoryAllocationTracker memoryTracker) {
            this.next = next;
            this.address = UnsafeUtil.allocateMemory((long)size, (MemoryAllocationTracker)memoryTracker);
            this.limit = this.address + size;
            this.memoryTracker = memoryTracker;
            this.nextPointer = this.address;
        }

        Grab(Grab next, long address, long limit, long nextPointer, MemoryAllocationTracker memoryTracker) {
            this.next = next;
            this.address = address;
            this.limit = limit;
            this.nextPointer = nextPointer;
            this.memoryTracker = memoryTracker;
        }

        private long nextAligned(long pointer, long alignment) {
            long mask = alignment - 1L;
            if ((pointer & (mask ^ 0xFFFFFFFFFFFFFFFFL)) == pointer) {
                return pointer;
            }
            return pointer + mask & (mask ^ 0xFFFFFFFFFFFFFFFFL);
        }

        long allocate(long bytes, long alignment) {
            long allocation = this.nextAligned(this.nextPointer, alignment);
            this.nextPointer = allocation + bytes;
            return allocation;
        }

        void free() {
            UnsafeUtil.free((long)this.address, (long)(this.limit - this.address), (MemoryAllocationTracker)this.memoryTracker);
        }

        boolean canAllocate(long bytes) {
            return this.nextPointer + bytes <= this.limit;
        }

        Grab setNext(Grab grab) {
            return new Grab(grab, this.address, this.limit, this.nextPointer, this.memoryTracker);
        }

        public String toString() {
            long size = this.limit - this.address;
            long reserve = this.nextPointer > this.limit ? 0L : this.limit - this.nextPointer;
            double use = (1.0 - (double)reserve / (double)size) * 100.0;
            return String.format("Grab[size = %d bytes, reserve = %d bytes, use = %5.2f %%]", size, reserve, use);
        }
    }
}

