/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io;

import java.util.Locale;

public enum ByteUnit {
    Byte(0L, "B"),
    KibiByte(1L, "KiB"),
    MebiByte(2L, "MiB"),
    GibiByte(3L, "GiB"),
    TebiByte(4L, "TiB"),
    PebiByte(5L, "PiB"),
    ExbiByte(6L, "EiB");

    public static final long ONE_KIBI_BYTE;
    public static final long ONE_MEBI_BYTE;
    public static final long ONE_GIBI_BYTE;
    private static final long EIC_MULTIPLIER = 1024L;
    private final long factor;
    private final String shortName;

    private ByteUnit(long power, String shortName) {
        this.factor = this.factorFromPower(power);
        this.shortName = shortName;
    }

    private long factorFromPower(long power) {
        if (power == 0L) {
            return 1L;
        }
        long product = 1024L;
        int i = 0;
        while ((long)i < power - 1L) {
            product *= 1024L;
            ++i;
        }
        return product;
    }

    public String abbreviation() {
        return this.shortName;
    }

    public long convert(long value, ByteUnit toUnit) {
        return this.toBytes(value) / toUnit.factor;
    }

    public long toBytes(long value) {
        return this.factor * value;
    }

    public long toKibiBytes(long value) {
        return this.convert(value, KibiByte);
    }

    public long toMebiBytes(long value) {
        return this.convert(value, MebiByte);
    }

    public long toGibiBytes(long value) {
        return this.convert(value, GibiByte);
    }

    public long toTebiBytes(long value) {
        return this.convert(value, TebiByte);
    }

    public long toPebiBytes(long value) {
        return this.convert(value, PebiByte);
    }

    public long toExbiBytes(long value) {
        return this.convert(value, ExbiByte);
    }

    public static long bytes(long bytes) {
        return bytes;
    }

    public static long kibiBytes(long kibibytes) {
        return KibiByte.toBytes(kibibytes);
    }

    public static long mebiBytes(long mebibytes) {
        return MebiByte.toBytes(mebibytes);
    }

    public static long gibiBytes(long gibibytes) {
        return GibiByte.toBytes(gibibytes);
    }

    public static long tebiBytes(long tebibytes) {
        return TebiByte.toBytes(tebibytes);
    }

    public static long pebiBytes(long pebibytes) {
        return PebiByte.toBytes(pebibytes);
    }

    public static long exbiBytes(long exbibytes) {
        return ExbiByte.toBytes(exbibytes);
    }

    public static String bytesToString(long bytes) {
        if (bytes > ONE_GIBI_BYTE) {
            return String.format(Locale.ROOT, "%.4g%s", (double)bytes / (double)ONE_GIBI_BYTE, ByteUnit.GibiByte.shortName);
        }
        if (bytes > ONE_MEBI_BYTE) {
            return String.format(Locale.ROOT, "%.4g%s", (double)bytes / (double)ONE_MEBI_BYTE, ByteUnit.MebiByte.shortName);
        }
        if (bytes > ONE_KIBI_BYTE) {
            return String.format(Locale.ROOT, "%.4g%s", (double)bytes / (double)ONE_KIBI_BYTE, ByteUnit.KibiByte.shortName);
        }
        return bytes + ByteUnit.Byte.shortName;
    }

    static {
        ONE_KIBI_BYTE = KibiByte.toBytes(1L);
        ONE_MEBI_BYTE = MebiByte.toBytes(1L);
        ONE_GIBI_BYTE = GibiByte.toBytes(1L);
    }
}

