/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Arrays;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageEvictionCallback;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.PagedReadableByteChannel;
import org.neo4j.io.pagecache.impl.PagedWritableByteChannel;
import org.neo4j.io.pagecache.impl.muninn.CursorPool;
import org.neo4j.io.pagecache.impl.muninn.LatchMap;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.PageList;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

final class MuninnPagedFile
extends PageList
implements PagedFile,
Flushable {
    static final int UNMAPPED_TTE = -1;
    private static final int translationTableChunkSizePower = Integer.getInteger("org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile.translationTableChunkSizePower", 12);
    private static final int translationTableChunkSize = 1 << translationTableChunkSizePower;
    private static final long translationTableChunkSizeMask = translationTableChunkSize - 1;
    private static final int translationTableChunkArrayBase = UnsafeUtil.arrayBaseOffset(int[].class);
    private static final int translationTableChunkArrayScale = UnsafeUtil.arrayIndexScale(int[].class);
    private static final long headerStateOffset = UnsafeUtil.getFieldOffset(MuninnPagedFile.class, (String)"headerState");
    private static final int headerStateRefCountShift = 48;
    private static final int headerStateRefCountMax = Short.MAX_VALUE;
    private static final long headerStateRefCountMask = 0x7FFF000000000000L;
    private static final long headerStateLastPageIdMask = -9223090561878065153L;
    final MuninnPageCache pageCache;
    final int filePageSize;
    final PageCacheTracer pageCacheTracer;
    final LatchMap pageFaultLatches;
    volatile int[][] translationTable;
    final PageSwapper swapper;
    final int swapperId;
    private final CursorPool cursorPool;
    private boolean deleteOnClose;
    private volatile Exception closeStackTrace;
    private static final long evictedTransactionIdOffset = UnsafeUtil.getFieldOffset(MuninnPagedFile.class, (String)"highestEvictedTransactionId");
    private volatile long highestEvictedTransactionId;
    private volatile long headerState;

    MuninnPagedFile(File file, MuninnPageCache pageCache, int filePageSize, PageSwapperFactory swapperFactory, PageCacheTracer pageCacheTracer, PageCursorTracerSupplier pageCursorTracerSupplier, VersionContextSupplier versionContextSupplier, boolean createIfNotExists, boolean truncateExisting) throws IOException {
        super(pageCache.pages);
        this.pageCache = pageCache;
        this.filePageSize = filePageSize;
        this.cursorPool = new CursorPool(this, pageCursorTracerSupplier, pageCacheTracer, versionContextSupplier);
        this.pageCacheTracer = pageCacheTracer;
        this.pageFaultLatches = new LatchMap();
        PageEvictionCallback onEviction = this::evictPage;
        this.swapper = swapperFactory.createPageSwapper(file, filePageSize, onEviction, createIfNotExists);
        if (truncateExisting) {
            this.swapper.truncate();
        }
        long lastPageId = this.swapper.getLastPageId();
        int initialChunks = 1 + MuninnPagedFile.computeChunkId(lastPageId);
        int[][] tt = new int[initialChunks][];
        for (int i = 0; i < initialChunks; ++i) {
            tt[i] = MuninnPagedFile.newChunk();
        }
        this.translationTable = tt;
        this.initialiseLastPageId(lastPageId);
        this.swapperId = this.getSwappers().allocate(this.swapper);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.swapper.file() + "]";
    }

    @Override
    public PageCursor io(long pageId, int pf_flags) {
        int lockMask = 3;
        if ((pf_flags & lockMask) == 0) {
            throw new IllegalArgumentException("Must specify either PF_SHARED_WRITE_LOCK or PF_SHARED_READ_LOCK");
        }
        if ((pf_flags & lockMask) == lockMask) {
            throw new IllegalArgumentException("Cannot specify both PF_SHARED_WRITE_LOCK and PF_SHARED_READ_LOCK");
        }
        MuninnPageCursor cursor = (pf_flags & 1) == 0 ? this.cursorPool.takeWriteCursor(pageId, pf_flags) : this.cursorPool.takeReadCursor(pageId, pf_flags);
        cursor.rewind();
        return cursor;
    }

    @Override
    public int pageSize() {
        return this.filePageSize;
    }

    @Override
    public long fileSize() {
        long lastPageId = this.getLastPageId();
        if (lastPageId < 0L) {
            return 0L;
        }
        return (lastPageId + 1L) * (long)this.pageSize();
    }

    @Override
    public File file() {
        return this.swapper.file();
    }

    @Override
    public void close() throws IOException {
        this.pageCache.unmap(this);
    }

    @Override
    public ReadableByteChannel openReadableByteChannel() throws IOException {
        return new PagedReadableByteChannel(this);
    }

    @Override
    public WritableByteChannel openWritableByteChannel() throws IOException {
        return new PagedWritableByteChannel(this);
    }

    void closeSwapper() throws IOException {
        this.closeStackTrace = new Exception("tracing paged file closing");
        if (!this.deleteOnClose) {
            this.swapper.close();
        } else {
            this.swapper.closeAndDelete();
        }
        if (this.getSwappers().free(this.swapperId)) {
            this.pageCache.vacuum(this.getSwappers());
        }
    }

    @Override
    public void flushAndForce() throws IOException {
        this.flushAndForce(IOLimiter.unlimited());
    }

    @Override
    public void flushAndForce(IOLimiter limiter) throws IOException {
        if (limiter == null) {
            throw new IllegalArgumentException("IOPSLimiter cannot be null");
        }
        try (MajorFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush(this.swapper);){
            this.flushAndForceInternal(flushEvent.flushEventOpportunity(), false, limiter);
            this.syncDevice();
        }
        this.pageCache.clearEvictorException();
    }

    void flushAndForceForClose() throws IOException {
        if (this.deleteOnClose) {
            this.markAllDirtyPagesAsClean();
            return;
        }
        try (MajorFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush(this.swapper);){
            this.flushAndForceInternal(flushEvent.flushEventOpportunity(), true, IOLimiter.unlimited());
            this.syncDevice();
        }
        this.pageCache.clearEvictorException();
    }

    private void markAllDirtyPagesAsClean() {
        int[][] tt;
        long filePageId = -1L;
        for (int[] chunk : tt = this.translationTable) {
            block1: for (int i = 0; i < chunk.length; ++i) {
                int pageId;
                long offset = MuninnPagedFile.computeChunkOffset(++filePageId);
                while ((pageId = UnsafeUtil.getIntVolatile((Object)chunk, (long)offset)) != -1) {
                    long pageRef = this.deref(pageId);
                    long stamp = this.tryOptimisticReadLock(pageRef);
                    if (!this.isModified(pageRef) && this.validateReadLock(pageRef, stamp)) continue block1;
                    if (!this.tryExclusiveLock(pageRef)) continue;
                    if (!this.isBoundTo(pageRef, this.swapperId, filePageId) || !this.isModified(pageRef)) continue block1;
                    this.explicitlyMarkPageUnmodifiedUnderExclusiveLock(pageRef);
                    this.unlockExclusive(pageRef);
                    continue block1;
                }
            }
        }
    }

    void flushAndForceInternal(FlushEventOpportunity flushOpportunity, boolean forClosing, IOLimiter limiter) throws IOException {
        int[][] tt;
        long[] pages = new long[translationTableChunkSize];
        long[] flushStamps = forClosing ? null : new long[translationTableChunkSize];
        long[] bufferAddresses = new long[translationTableChunkSize];
        long filePageId = -1L;
        long limiterStamp = 0L;
        for (int[] chunk : tt = this.translationTable) {
            int pagesGrabbed = 0;
            block1: for (int i = 0; i < chunk.length; ++i) {
                int pageId;
                long offset = MuninnPagedFile.computeChunkOffset(++filePageId);
                while ((pageId = UnsafeUtil.getIntVolatile((Object)chunk, (long)offset)) != -1) {
                    long pageRef = this.deref(pageId);
                    long stamp = this.tryOptimisticReadLock(pageRef);
                    if (!this.isModified(pageRef) && this.validateReadLock(pageRef, stamp)) break;
                    long flushStamp = 0L;
                    if (!(forClosing ? this.tryExclusiveLock(pageRef) : (flushStamp = this.tryFlushLock(pageRef)) != 0L)) continue;
                    if (this.isBoundTo(pageRef, this.swapperId, filePageId) && this.isModified(pageRef)) {
                        pages[pagesGrabbed] = pageRef;
                        if (!forClosing) {
                            flushStamps[pagesGrabbed] = flushStamp;
                        }
                        bufferAddresses[pagesGrabbed] = this.getAddress(pageRef);
                        ++pagesGrabbed;
                        continue block1;
                    }
                    if (forClosing) {
                        this.unlockExclusive(pageRef);
                        break;
                    }
                    this.unlockFlush(pageRef, flushStamp, false);
                    break;
                }
                if (pagesGrabbed <= 0) continue;
                this.vectoredFlush(pages, bufferAddresses, flushStamps, pagesGrabbed, flushOpportunity, forClosing);
                limiterStamp = limiter.maybeLimitIO(limiterStamp, pagesGrabbed, this);
                pagesGrabbed = 0;
            }
            if (pagesGrabbed <= 0) continue;
            this.vectoredFlush(pages, bufferAddresses, flushStamps, pagesGrabbed, flushOpportunity, forClosing);
            limiterStamp = limiter.maybeLimitIO(limiterStamp, pagesGrabbed, this);
        }
        this.swapper.force();
    }

    private void vectoredFlush(long[] pages, long[] bufferAddresses, long[] flushStamps, int pagesGrabbed, FlushEventOpportunity flushOpportunity, boolean forClosing) throws IOException {
        FlushEvent flush = null;
        boolean successful = false;
        try {
            long firstPageRef = pages[0];
            long startFilePageId = this.getFilePageId(firstPageRef);
            flush = flushOpportunity.beginFlush(startFilePageId, this.toId(firstPageRef), this.swapper);
            long bytesWritten = this.swapper.write(startFilePageId, bufferAddresses, 0, pagesGrabbed);
            flush.addBytesWritten(bytesWritten);
            flush.addPagesFlushed(pagesGrabbed);
            flush.done();
            successful = true;
        }
        catch (IOException ioe) {
            if (flush != null) {
                flush.done(ioe);
            }
            throw ioe;
        }
        finally {
            if (forClosing) {
                for (int i = 0; i < pagesGrabbed; ++i) {
                    long pageRef = pages[i];
                    if (successful) {
                        this.explicitlyMarkPageUnmodifiedUnderExclusiveLock(pageRef);
                    }
                    this.unlockExclusive(pageRef);
                }
            } else {
                for (int i = 0; i < pagesGrabbed; ++i) {
                    this.unlockFlush(pages[i], flushStamps[i], successful);
                }
            }
        }
    }

    boolean flushLockedPage(long pageRef, long filePageId) {
        boolean success = false;
        try (MajorFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush(this.swapper);){
            FlushEvent flush = flushEvent.flushEventOpportunity().beginFlush(filePageId, this.toId(pageRef), this.swapper);
            long address = this.getAddress(pageRef);
            try {
                long bytesWritten = this.swapper.write(filePageId, address);
                flush.addBytesWritten(bytesWritten);
                flush.addPagesFlushed(1);
                flush.done();
                success = true;
            }
            catch (IOException e) {
                flush.done(e);
            }
        }
        return success;
    }

    private void syncDevice() throws IOException {
        this.pageCache.syncDevice();
    }

    @Override
    public void flush() throws IOException {
        this.swapper.force();
    }

    @Override
    public long getLastPageId() {
        long state = this.getHeaderState();
        if (this.refCountOf(state) == 0L) {
            String msg = "File has been unmapped: " + this.file().getPath();
            IllegalStateException exception = new IllegalStateException(msg);
            Exception closedBy = this.closeStackTrace;
            if (closedBy != null) {
                exception.addSuppressed(closedBy);
            }
            throw exception;
        }
        return state & 0x8000FFFFFFFFFFFFL;
    }

    private long getHeaderState() {
        return UnsafeUtil.getLongVolatile((Object)this, (long)headerStateOffset);
    }

    private long refCountOf(long state) {
        return (state & 0x7FFF000000000000L) >>> 48;
    }

    private void initialiseLastPageId(long lastPageIdFromFile) {
        if (lastPageIdFromFile < 0L) {
            UnsafeUtil.putLongVolatile((Object)this, (long)headerStateOffset, (long)Long.MIN_VALUE);
        } else {
            UnsafeUtil.putLongVolatile((Object)this, (long)headerStateOffset, (long)lastPageIdFromFile);
        }
    }

    void increaseLastPageIdTo(long newLastPageId) {
        long update;
        long current;
        long lastPageId;
        do {
            current = this.getHeaderState();
            update = newLastPageId + (current & 0x7FFF000000000000L);
        } while ((lastPageId = current & 0x8000FFFFFFFFFFFFL) < newLastPageId && !UnsafeUtil.compareAndSwapLong((Object)this, (long)headerStateOffset, (long)current, (long)update));
    }

    void incrementRefCount() {
        long count;
        long update;
        long current;
        do {
            if ((count = this.refCountOf(current = this.getHeaderState()) + 1L) <= 32767L) continue;
            throw new IllegalStateException("Cannot map file because reference counter would overflow. Maximum reference count is 32767. File is " + this.swapper.file().getAbsolutePath());
        } while (!UnsafeUtil.compareAndSwapLong((Object)this, (long)headerStateOffset, (long)current, (long)(update = (current & 0x8000FFFFFFFFFFFFL) + (count << 48))));
    }

    boolean decrementRefCount() {
        long count;
        long update;
        long current;
        do {
            if ((count = this.refCountOf(current = this.getHeaderState()) - 1L) >= 0L) continue;
            throw new IllegalStateException("File has already been closed and unmapped. It cannot be closed any further.");
        } while (!UnsafeUtil.compareAndSwapLong((Object)this, (long)headerStateOffset, (long)current, (long)(update = (current & 0x8000FFFFFFFFFFFFL) + (count << 48))));
        return count == 0L;
    }

    int getRefCount() {
        return (int)this.refCountOf(this.getHeaderState());
    }

    void markDeleteOnClose(boolean deleteOnClose) {
        this.deleteOnClose |= deleteOnClose;
    }

    long grabFreeAndExclusivelyLockedPage(PageFaultEvent faultEvent) throws IOException {
        return this.pageCache.grabFreeAndExclusivelyLockedPage(faultEvent);
    }

    void evictPage(long filePageId) {
        int chunkId = MuninnPagedFile.computeChunkId(filePageId);
        long chunkOffset = MuninnPagedFile.computeChunkOffset(filePageId);
        int[] chunk = this.translationTable[chunkId];
        int mappedPageId = UnsafeUtil.getIntVolatile((Object)chunk, (long)chunkOffset);
        long pageRef = this.deref(mappedPageId);
        this.setHighestEvictedTransactionId(this.getAndResetLastModifiedTransactionId(pageRef));
        UnsafeUtil.putIntVolatile((Object)chunk, (long)chunkOffset, (int)-1);
    }

    private void setHighestEvictedTransactionId(long modifiedTransactionId) {
        UnsafeUtil.compareAndSetMaxLong((Object)this, (long)evictedTransactionIdOffset, (long)modifiedTransactionId);
    }

    long getHighestEvictedTransactionId() {
        return UnsafeUtil.getLongVolatile((Object)this, (long)evictedTransactionIdOffset);
    }

    synchronized int[][] expandCapacity(int maxChunkId) {
        Object tt = this.translationTable;
        if (((int[][])tt).length <= maxChunkId) {
            int newLength = this.computeNewRootTableLength(maxChunkId);
            int[][] ntt = new int[newLength][];
            System.arraycopy(tt, 0, ntt, 0, ((int[][])tt).length);
            for (int i = ((int[][])tt).length; i < ntt.length; ++i) {
                ntt[i] = MuninnPagedFile.newChunk();
            }
            this.translationTable = tt = (Object)ntt;
        }
        return tt;
    }

    private static int[] newChunk() {
        int[] chunk = new int[translationTableChunkSize];
        Arrays.fill(chunk, -1);
        return chunk;
    }

    private int computeNewRootTableLength(int maxChunkId) {
        return 1 + (int)((double)maxChunkId * 1.1);
    }

    static int computeChunkId(long filePageId) {
        return (int)(filePageId >>> translationTableChunkSizePower);
    }

    static long computeChunkOffset(long filePageId) {
        int index = (int)(filePageId & translationTableChunkSizeMask);
        return UnsafeUtil.arrayOffset((int)index, (int)translationTableChunkArrayBase, (int)translationTableChunkArrayScale);
    }
}

