/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.IOException;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.impl.muninn.CursorPool;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracer;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;

final class MuninnReadPageCursor
extends MuninnPageCursor {
    private final CursorPool.CursorSets cursorSets;
    private long lockStamp;
    MuninnReadPageCursor nextCursor;

    MuninnReadPageCursor(CursorPool.CursorSets cursorSets, long victimPage, PageCursorTracer pageCursorTracer, VersionContextSupplier versionContextSupplier) {
        super(victimPage, pageCursorTracer, versionContextSupplier);
        this.cursorSets = cursorSets;
    }

    @Override
    protected void unpinCurrentPage() {
        if (this.pinnedPageRef != 0L) {
            this.pinEvent.done();
        }
        this.lockStamp = 0L;
        this.clearPageState();
    }

    @Override
    public boolean next() throws IOException {
        this.unpinCurrentPage();
        long lastPageId = this.assertPagedFileStillMappedAndGetIdOfLastPage();
        if (this.nextPageId > lastPageId | this.nextPageId < 0L) {
            return false;
        }
        this.pin(this.nextPageId, false);
        this.currentPageId = this.nextPageId++;
        this.verifyContext();
        return true;
    }

    @Override
    protected boolean tryLockPage(long pageRef) {
        this.lockStamp = this.pagedFile.tryOptimisticReadLock(pageRef);
        return true;
    }

    @Override
    protected void unlockPage(long pageRef) {
    }

    @Override
    protected void pinCursorToPage(long pageRef, long filePageId, PageSwapper swapper) {
        this.reset(pageRef);
        this.pagedFile.incrementUsage(pageRef);
    }

    @Override
    protected void convertPageFaultLock(long pageRef) {
        this.lockStamp = this.pagedFile.unlockExclusive(pageRef);
    }

    @Override
    protected void releaseCursor() {
        this.nextCursor = this.cursorSets.readCursors;
        this.cursorSets.readCursors = this;
    }

    @Override
    public boolean shouldRetry() throws IOException {
        MuninnReadPageCursor cursor = this;
        do {
            long pageRef;
            if ((pageRef = cursor.pinnedPageRef) == 0L || this.pagedFile.validateReadLock(pageRef, cursor.lockStamp)) continue;
            this.startRetryLinkedChain();
            return true;
        } while ((cursor = (MuninnReadPageCursor)cursor.linkedCursor) != null);
        return false;
    }

    private void startRetryLinkedChain() throws IOException {
        MuninnReadPageCursor cursor = this;
        do {
            if (cursor.pinnedPageRef == 0L) continue;
            cursor.startRetry();
        } while ((cursor = (MuninnReadPageCursor)cursor.linkedCursor) != null);
    }

    private void startRetry() throws IOException {
        this.setOffset(0);
        this.checkAndClearBoundsFlag();
        this.clearCursorException();
        this.lockStamp = this.pagedFile.tryOptimisticReadLock(this.pinnedPageRef);
        if (!this.pagedFile.isBoundTo(this.pinnedPageRef, this.pagedFile.swapperId, this.currentPageId)) {
            this.pinnedPageRef = 0L;
            this.pin(this.currentPageId, false);
        }
    }

    @Override
    public void putByte(byte value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putLong(long value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putInt(int value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putBytes(byte[] data, int arrayOffset, int length) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void putShort(short value) {
        throw new IllegalStateException("Cannot write to read-locked page");
    }

    @Override
    public void zapPage() {
        throw new IllegalStateException("Cannot write to read-locked page");
    }
}

