/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.io.pagecache.impl.muninn;

import java.io.File;
import java.io.Flushable;
import java.io.IOException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import org.neo4j.io.pagecache.IOLimiter;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.PageSwapper;
import org.neo4j.io.pagecache.PageSwapperFactory;
import org.neo4j.io.pagecache.PagedFile;
import org.neo4j.io.pagecache.impl.PagedReadableByteChannel;
import org.neo4j.io.pagecache.impl.PagedWritableByteChannel;
import org.neo4j.io.pagecache.impl.muninn.CursorPool;
import org.neo4j.io.pagecache.impl.muninn.MuninnPage;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCache;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageCursor;
import org.neo4j.io.pagecache.impl.muninn.MuninnPageEvictionCallback;
import org.neo4j.io.pagecache.tracing.FlushEvent;
import org.neo4j.io.pagecache.tracing.FlushEventOpportunity;
import org.neo4j.io.pagecache.tracing.MajorFlushEvent;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.io.pagecache.tracing.PageFaultEvent;
import org.neo4j.io.pagecache.tracing.cursor.PageCursorTracerSupplier;
import org.neo4j.io.pagecache.tracing.cursor.context.VersionContextSupplier;
import org.neo4j.unsafe.impl.internal.dragons.UnsafeUtil;

final class MuninnPagedFile
implements PagedFile,
Flushable {
    private static final int translationTableChunkSizePower = Integer.getInteger("org.neo4j.io.pagecache.impl.muninn.MuninnPagedFile.translationTableChunkSizePower", 12);
    private static final int translationTableChunkSize = 1 << translationTableChunkSizePower;
    private static final long translationTableChunkSizeMask = translationTableChunkSize - 1;
    private static final int translationTableChunkArrayBase = UnsafeUtil.arrayBaseOffset(MuninnPage[].class);
    private static final int translationTableChunkArrayScale = UnsafeUtil.arrayIndexScale(MuninnPage[].class);
    private static final long headerStateOffset = UnsafeUtil.getFieldOffset(MuninnPagedFile.class, (String)"headerState");
    private static final int headerStateRefCountShift = 48;
    private static final int headerStateRefCountMax = Short.MAX_VALUE;
    private static final long headerStateRefCountMask = 0x7FFF000000000000L;
    private static final long headerStateLastPageIdMask = -9223090561878065153L;
    final MuninnPageCache pageCache;
    final int filePageSize;
    final PageCacheTracer pageCacheTracer;
    volatile Object[][] translationTable;
    final PageSwapper swapper;
    private final CursorPool cursorPool;
    private boolean deleteOnClose;
    private volatile Exception closeStackTrace;
    private static final long evictedTransactionIdOffset = UnsafeUtil.getFieldOffset(MuninnPagedFile.class, (String)"highestEvictedTransactionId");
    private volatile long highestEvictedTransactionId;
    private volatile long headerState;

    MuninnPagedFile(File file, MuninnPageCache pageCache, int filePageSize, PageSwapperFactory swapperFactory, PageCacheTracer pageCacheTracer, PageCursorTracerSupplier pageCursorTracerSupplier, VersionContextSupplier versionContextSupplier, boolean createIfNotExists, boolean truncateExisting) throws IOException {
        this.pageCache = pageCache;
        this.filePageSize = filePageSize;
        this.cursorPool = new CursorPool(this, pageCursorTracerSupplier, pageCacheTracer, versionContextSupplier);
        this.pageCacheTracer = pageCacheTracer;
        MuninnPageEvictionCallback onEviction = new MuninnPageEvictionCallback(this);
        this.swapper = swapperFactory.createPageSwapper(file, filePageSize, onEviction, createIfNotExists);
        if (truncateExisting) {
            this.swapper.truncate();
        }
        long lastPageId = this.swapper.getLastPageId();
        int initialChunks = 1 + MuninnPagedFile.computeChunkId(lastPageId);
        Object[][] tt = new Object[initialChunks][];
        for (int i = 0; i < initialChunks; ++i) {
            tt[i] = new Object[translationTableChunkSize];
        }
        this.translationTable = tt;
        this.initialiseLastPageId(lastPageId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.swapper.file() + "]";
    }

    @Override
    public PageCursor io(long pageId, int pf_flags) {
        int lockMask = 3;
        if ((pf_flags & lockMask) == 0) {
            throw new IllegalArgumentException("Must specify either PF_SHARED_WRITE_LOCK or PF_SHARED_READ_LOCK");
        }
        if ((pf_flags & lockMask) == lockMask) {
            throw new IllegalArgumentException("Cannot specify both PF_SHARED_WRITE_LOCK and PF_SHARED_READ_LOCK");
        }
        MuninnPageCursor cursor = (pf_flags & 1) == 0 ? this.cursorPool.takeWriteCursor(pageId, pf_flags) : this.cursorPool.takeReadCursor(pageId, pf_flags);
        cursor.rewind();
        return cursor;
    }

    @Override
    public int pageSize() {
        return this.filePageSize;
    }

    @Override
    public long fileSize() {
        long lastPageId = this.getLastPageId();
        if (lastPageId < 0L) {
            return 0L;
        }
        return (lastPageId + 1L) * (long)this.pageSize();
    }

    @Override
    public File file() {
        return this.swapper.file();
    }

    @Override
    public void close() throws IOException {
        this.pageCache.unmap(this);
    }

    @Override
    public ReadableByteChannel openReadableByteChannel() throws IOException {
        return new PagedReadableByteChannel(this);
    }

    @Override
    public WritableByteChannel openWritableByteChannel() throws IOException {
        return new PagedWritableByteChannel(this);
    }

    void closeSwapper() throws IOException {
        this.closeStackTrace = new Exception("tracing paged file closing");
        if (!this.deleteOnClose) {
            this.swapper.close();
        } else {
            this.swapper.closeAndDelete();
        }
    }

    @Override
    public void flushAndForce() throws IOException {
        this.flushAndForce(IOLimiter.unlimited());
    }

    @Override
    public void flushAndForce(IOLimiter limiter) throws IOException {
        if (limiter == null) {
            throw new IllegalArgumentException("IOPSLimiter cannot be null");
        }
        try (MajorFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush(this.swapper);){
            this.flushAndForceInternal(flushEvent.flushEventOpportunity(), false, limiter);
            this.syncDevice();
        }
        this.pageCache.clearEvictorException();
    }

    void flushAndForceForClose() throws IOException {
        if (this.deleteOnClose) {
            this.markAllDirtyPagesAsClean();
            return;
        }
        try (MajorFlushEvent flushEvent = this.pageCacheTracer.beginFileFlush(this.swapper);){
            this.flushAndForceInternal(flushEvent.flushEventOpportunity(), true, IOLimiter.unlimited());
            this.syncDevice();
        }
        this.pageCache.clearEvictorException();
    }

    private void markAllDirtyPagesAsClean() {
        Object[][] tt;
        long filePageId = -1L;
        for (Object[] chunk : tt = this.translationTable) {
            block1: for (int i = 0; i < chunk.length; ++i) {
                Object element;
                long offset = MuninnPagedFile.computeChunkOffset(++filePageId);
                while ((element = UnsafeUtil.getObjectVolatile((Object)chunk, (long)offset)) instanceof MuninnPage) {
                    MuninnPage page = (MuninnPage)element;
                    long stamp = page.tryOptimisticReadLock();
                    if (!page.isDirty() && page.validateReadLock(stamp)) continue block1;
                    if (!page.tryExclusiveLock()) continue;
                    if (!page.isBoundTo(this.swapper, filePageId) || !page.isDirty()) continue block1;
                    page.markAsClean();
                    page.unlockExclusive();
                    continue block1;
                }
            }
        }
    }

    void flushAndForceInternal(FlushEventOpportunity flushOpportunity, boolean forClosing, IOLimiter limiter) throws IOException {
        Object[][] tt;
        MuninnPage[] pages = new MuninnPage[translationTableChunkSize];
        long filePageId = -1L;
        long limiterStamp = 0L;
        for (Object[] chunk : tt = this.translationTable) {
            int pagesGrabbed = 0;
            block1: for (int i = 0; i < chunk.length; ++i) {
                Object element;
                long offset = MuninnPagedFile.computeChunkOffset(++filePageId);
                while ((element = UnsafeUtil.getObjectVolatile((Object)chunk, (long)offset)) instanceof MuninnPage) {
                    MuninnPage page = (MuninnPage)element;
                    long stamp = page.tryOptimisticReadLock();
                    if (!page.isDirty() && page.validateReadLock(stamp)) break;
                    if (!(forClosing ? page.tryExclusiveLock() : page.tryFlushLock())) continue;
                    if (page.isBoundTo(this.swapper, filePageId) && page.isDirty()) {
                        pages[pagesGrabbed] = page;
                        ++pagesGrabbed;
                        continue block1;
                    }
                    if (forClosing) {
                        page.unlockExclusive();
                        break;
                    }
                    page.unlockFlush();
                    break;
                }
                if (pagesGrabbed <= 0) continue;
                this.vectoredFlush(pages, pagesGrabbed, flushOpportunity, forClosing);
                limiterStamp = limiter.maybeLimitIO(limiterStamp, pagesGrabbed, this);
                pagesGrabbed = 0;
            }
            if (pagesGrabbed <= 0) continue;
            this.vectoredFlush(pages, pagesGrabbed, flushOpportunity, forClosing);
            limiterStamp = limiter.maybeLimitIO(limiterStamp, pagesGrabbed, this);
        }
        this.swapper.force();
    }

    private void vectoredFlush(MuninnPage[] pages, int pagesGrabbed, FlushEventOpportunity flushOpportunity, boolean forClosing) throws IOException {
        FlushEvent flush = null;
        try {
            MuninnPage firstPage = pages[0];
            long startFilePageId = firstPage.getFilePageId();
            for (int j = 0; j < pagesGrabbed; ++j) {
                pages[j].markAsClean();
            }
            flush = flushOpportunity.beginFlush(startFilePageId, firstPage.getCachePageId(), this.swapper);
            long bytesWritten = this.swapper.write(startFilePageId, pages, 0, pagesGrabbed);
            flush.addBytesWritten(bytesWritten);
            flush.addPagesFlushed(pagesGrabbed);
            flush.done();
        }
        catch (IOException ioe) {
            for (int j = 0; j < pagesGrabbed; ++j) {
                pages[j].markAsDirty();
            }
            if (flush != null) {
                flush.done(ioe);
            }
            throw ioe;
        }
        finally {
            for (int j = 0; j < pagesGrabbed; ++j) {
                if (forClosing) {
                    pages[j].unlockExclusive();
                    continue;
                }
                pages[j].unlockFlush();
            }
        }
    }

    private void syncDevice() throws IOException {
        this.pageCache.syncDevice();
    }

    @Override
    public void flush() throws IOException {
        this.swapper.force();
    }

    @Override
    public long getLastPageId() {
        long state = this.getHeaderState();
        if (this.refCountOf(state) == 0L) {
            String msg = "File has been unmapped: " + this.file().getPath();
            IllegalStateException exception = new IllegalStateException(msg);
            Exception closedBy = this.closeStackTrace;
            if (closedBy != null) {
                exception.addSuppressed(closedBy);
            }
            throw exception;
        }
        return state & 0x8000FFFFFFFFFFFFL;
    }

    private long getHeaderState() {
        return UnsafeUtil.getLongVolatile((Object)this, (long)headerStateOffset);
    }

    private long refCountOf(long state) {
        return (state & 0x7FFF000000000000L) >>> 48;
    }

    private void initialiseLastPageId(long lastPageIdFromFile) {
        if (lastPageIdFromFile < 0L) {
            UnsafeUtil.putLongVolatile((Object)this, (long)headerStateOffset, (long)Long.MIN_VALUE);
        } else {
            UnsafeUtil.putLongVolatile((Object)this, (long)headerStateOffset, (long)lastPageIdFromFile);
        }
    }

    void increaseLastPageIdTo(long newLastPageId) {
        long update;
        long current;
        long lastPageId;
        do {
            current = this.getHeaderState();
            update = newLastPageId + (current & 0x7FFF000000000000L);
        } while ((lastPageId = current & 0x8000FFFFFFFFFFFFL) < newLastPageId && !UnsafeUtil.compareAndSwapLong((Object)this, (long)headerStateOffset, (long)current, (long)update));
    }

    void incrementRefCount() {
        long count;
        long update;
        long current;
        do {
            if ((count = this.refCountOf(current = this.getHeaderState()) + 1L) <= 32767L) continue;
            throw new IllegalStateException("Cannot map file because reference counter would overflow. Maximum reference count is 32767. File is " + this.swapper.file().getAbsolutePath());
        } while (!UnsafeUtil.compareAndSwapLong((Object)this, (long)headerStateOffset, (long)current, (long)(update = (current & 0x8000FFFFFFFFFFFFL) + (count << 48))));
    }

    boolean decrementRefCount() {
        long count;
        long update;
        long current;
        do {
            if ((count = this.refCountOf(current = this.getHeaderState()) - 1L) >= 0L) continue;
            throw new IllegalStateException("File has already been closed and unmapped. It cannot be closed any further.");
        } while (!UnsafeUtil.compareAndSwapLong((Object)this, (long)headerStateOffset, (long)current, (long)(update = (current & 0x8000FFFFFFFFFFFFL) + (count << 48))));
        return count == 0L;
    }

    int getRefCount() {
        return (int)this.refCountOf(this.getHeaderState());
    }

    void markDeleteOnClose(boolean deleteOnClose) {
        this.deleteOnClose |= deleteOnClose;
    }

    MuninnPage grabFreeAndExclusivelyLockedPage(PageFaultEvent faultEvent) throws IOException {
        return this.pageCache.grabFreeAndExclusivelyLockedPage(faultEvent);
    }

    MuninnPage evictPage(long filePageId) {
        long chunkOffset;
        int chunkId = MuninnPagedFile.computeChunkId(filePageId);
        Object[] chunk = this.translationTable[chunkId];
        Object element = UnsafeUtil.getObjectVolatile((Object)chunk, (long)(chunkOffset = MuninnPagedFile.computeChunkOffset(filePageId)));
        if (element instanceof MuninnPage) {
            MuninnPage page = (MuninnPage)element;
            this.setHighestEvictedTransactionId(page.getAndResetLastModifiedTransactionId());
            UnsafeUtil.putObjectVolatile((Object)chunk, (long)chunkOffset, null);
            return page;
        }
        throw new IllegalStateException("Expected to evict a MuninnPage but found " + element);
    }

    private void setHighestEvictedTransactionId(long modifiedTransactionId) {
        UnsafeUtil.compareAndSetMaxLong((Object)this, (long)evictedTransactionIdOffset, (long)modifiedTransactionId);
    }

    long getHighestEvictedTransactionId() {
        return UnsafeUtil.getLongVolatile((Object)this, (long)evictedTransactionIdOffset);
    }

    synchronized Object[][] expandCapacity(int maxChunkId) {
        Object[][] tt = this.translationTable;
        if (tt.length <= maxChunkId) {
            int newLength = this.computeNewRootTableLength(maxChunkId);
            Object[][] ntt = new Object[newLength][];
            System.arraycopy(tt, 0, ntt, 0, tt.length);
            for (int i = tt.length; i < ntt.length; ++i) {
                ntt[i] = new Object[translationTableChunkSize];
            }
            tt = ntt;
            this.translationTable = tt;
        }
        return tt;
    }

    private int computeNewRootTableLength(int maxChunkId) {
        return 1 + (int)((double)maxChunkId * 1.1);
    }

    static int computeChunkId(long filePageId) {
        return (int)(filePageId >>> translationTableChunkSizePower);
    }

    static long computeChunkOffset(long filePageId) {
        int index = (int)(filePageId & translationTableChunkSizeMask);
        return UnsafeUtil.arrayOffset((int)index, (int)translationTableChunkArrayBase, (int)translationTableChunkArrayScale);
    }
}

